/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.labymod.user.cosmetic.animation.EnumAnimationMetaType;
import net.labymod.user.cosmetic.animation.IModelTransformer;
import net.labymod.user.cosmetic.animation.model.Animation;
import net.labymod.user.cosmetic.animation.model.BoneAnimation;
import net.labymod.user.cosmetic.animation.model.KeyframeVector;
import net.labymod.user.cosmetic.util.CosmeticData;

public class AnimationController {
    private Animation animation;
    private float startTick;
    private float tickLength;
    private float speed = 1.0f;
    private float changedSpeedPointer;
    private final List<Animation> queue = new ArrayList<Animation>();

    public void play(Animation animation, float currentTick) {
        String animationSpeedString;
        boolean hasToReachNextInQueue;
        boolean playFromQueue;
        boolean bl = playFromQueue = !this.queue.isEmpty();
        if (playFromQueue) {
            animation = this.queue.remove(0);
        }
        this.animation = animation;
        this.startTick = currentTick;
        this.tickLength = (float)animation.getLength() / 50.0f;
        this.changedSpeedPointer = 0.0f;
        float speed = 1.0f;
        boolean bl2 = hasToReachNextInQueue = !this.queue.isEmpty();
        if (hasToReachNextInQueue && (animationSpeedString = animation.getMetaValue(EnumAnimationMetaType.SPEED)) != null) {
            speed = Float.parseFloat(animationSpeedString);
        }
        this.setSpeed(speed, currentTick);
    }

    public void addToPlayQueue(Animation animation) {
        if (this.queue.size() < 10) {
            this.queue.add(animation);
        }
    }

    public void transformAndRender(IModelTransformer transformer, pk entity, CosmeticData cosmeticData, float movementFactor, float walkingSpeed, float currentTick, float renderScale, float partialTicks, boolean rightSide) {
        long offset = (long)(this.getAnimationTickTime(currentTick) * 50.0f);
        if (this.animation != null) {
            for (Map.Entry<String, BoneAnimation> entry : this.animation.getBoneAnimations().entrySet()) {
                BoneAnimation animation = entry.getValue();
                KeyframeVector rotation = animation.rotation.get(offset);
                KeyframeVector position = animation.position.get(offset);
                KeyframeVector scale = animation.scale.get(offset);
                transformer.transform(entry.getKey(), rotation, position, scale);
            }
        }
        transformer.applyEffects(entity, cosmeticData, movementFactor, walkingSpeed, currentTick, partialTicks, rightSide);
        transformer.renderModel(renderScale);
        if (this.animation != null) {
            for (Map.Entry<String, BoneAnimation> entry : this.animation.getBoneAnimations().entrySet()) {
                transformer.resetTransformation(entry.getKey());
            }
        }
    }

    private float getAnimationTickTime(float currentTick) {
        float tick = currentTick - this.startTick;
        float speedTick = tick - this.changedSpeedPointer;
        if (this.speed == 1.0f) {
            return tick;
        }
        return this.changedSpeedPointer + speedTick * this.speed;
    }

    public boolean isPlaying(float currentTick) {
        return this.animation != null && this.startTick <= currentTick && this.getAnimationTickTime(currentTick) < this.tickLength;
    }

    public void stop() {
        this.startTick = 0.0f;
    }

    public Animation getCurrentAnimation() {
        return this.animation;
    }

    public void setSpeed(float speed, float currentTick) {
        this.changedSpeedPointer = this.getAnimationTickTime(currentTick);
        this.speed = speed;
    }

    public boolean hasAnimationInQueue(Animation animation) {
        for (Animation animationInQueue : this.queue) {
            if (animationInQueue != animation) continue;
            return true;
        }
        return false;
    }

    public float getSpeed() {
        return this.speed;
    }
}

