/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;
import net.labymod.support.util.Debug;
import net.labymod.user.User;
import net.labymod.user.cosmetic.custom.CosmeticImageHandler;
import net.labymod.user.cosmetic.custom.handler.AngelWingsImageHandler;
import net.labymod.user.cosmetic.custom.handler.BandanaImageHandler;
import net.labymod.user.cosmetic.custom.handler.BunnyShoesImageHandler;
import net.labymod.user.cosmetic.custom.handler.CapImageHandler;
import net.labymod.user.cosmetic.custom.handler.CloakImageHandler;
import net.labymod.user.cosmetic.custom.handler.CoverMaskImageHandler;
import net.labymod.user.cosmetic.custom.handler.KawaiiMaskImageHandler;
import net.labymod.user.cosmetic.custom.handler.PetDragonImageHandler;
import net.labymod.user.cosmetic.custom.handler.ScarfImageHandler;
import net.labymod.user.cosmetic.custom.handler.ShoesImageHandler;
import net.labymod.user.cosmetic.custom.handler.StickerImageHandler;
import net.labymod.user.cosmetic.custom.handler.WatchImageHandler;

public class CosmeticImageManager {
    private List<CosmeticImageHandler> cosmeticImageHandlers = new ArrayList<CosmeticImageHandler>();
    private final CloakImageHandler cloakImageHandler;
    private final BandanaImageHandler bandanaImageHandler;
    private final ShoesImageHandler shoesImageHandler;
    private final StickerImageHandler stickerImageHandler;
    private final KawaiiMaskImageHandler kawaiiMaskImageHandler;
    private final CoverMaskImageHandler coverMaskImageHandler;
    private final WatchImageHandler watchImageHandler;
    private final AngelWingsImageHandler angelWingsImageHandler;
    private final CapImageHandler capImageHandler;
    private final PetDragonImageHandler petDragonImageHandler;
    private final BunnyShoesImageHandler bunnyShoesImageHandler;
    private final ScarfImageHandler scarfImageHandler;

    public CosmeticImageManager(String userAgent) {
        this.cloakImageHandler = new CloakImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.cloakImageHandler);
        this.bandanaImageHandler = new BandanaImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.bandanaImageHandler);
        this.shoesImageHandler = new ShoesImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.shoesImageHandler);
        this.stickerImageHandler = new StickerImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.stickerImageHandler);
        this.kawaiiMaskImageHandler = new KawaiiMaskImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.kawaiiMaskImageHandler);
        this.coverMaskImageHandler = new CoverMaskImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.coverMaskImageHandler);
        this.watchImageHandler = new WatchImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.watchImageHandler);
        this.angelWingsImageHandler = new AngelWingsImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.angelWingsImageHandler);
        this.capImageHandler = new CapImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.capImageHandler);
        this.petDragonImageHandler = new PetDragonImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.petDragonImageHandler);
        this.bunnyShoesImageHandler = new BunnyShoesImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.bunnyShoesImageHandler);
        this.scarfImageHandler = new ScarfImageHandler(userAgent);
        this.cosmeticImageHandlers.add(this.scarfImageHandler);
    }

    public void loadPlayersInView() {
        if (!LabyMod.getInstance().isInGame()) {
            return;
        }
        for (wn player : LabyModCore.getMinecraft().getWorld().j) {
            if (player.equals((Object)LabyModCore.getMinecraft().getPlayer())) continue;
            User user = LabyMod.getInstance().getUserManager().getUser(player.aK());
            for (CosmeticImageHandler handler : this.cosmeticImageHandlers) {
                handler.validate(user);
            }
        }
    }

    public void unloadUnusedTextures(boolean forceNotIngame, boolean forceSelf) {
        for (CosmeticImageHandler handler : new ArrayList<CosmeticImageHandler>(this.cosmeticImageHandlers)) {
            if (handler == null || !handler.isCanUnload() && !forceSelf) continue;
            try {
                ArrayList<UUID> toRemove = new ArrayList<UUID>(handler.getResourceLocations().keySet());
                if (LabyMod.getInstance().isInGame() && !forceNotIngame) {
                    for (wn player : LabyModCore.getMinecraft().getWorld().j) {
                        UUID uuid = player.aK();
                        if (!toRemove.contains(uuid)) continue;
                        toRemove.remove(uuid);
                    }
                }
                int noImage = 0;
                for (UUID rem : toRemove) {
                    if (rem.equals(LabyMod.getInstance().getPlayerUUID()) && !forceSelf) continue;
                    jy resourceLocation = handler.getResourceLocations().get(rem).getDefault();
                    if (resourceLocation == null || !resourceLocation.a().startsWith(handler.getResourceName() + "/")) {
                        ++noImage;
                    } else {
                        for (jy frame : handler.getResourceLocations().get(rem).getAllFrames()) {
                            ave.A().P().c(frame);
                        }
                        Debug.log(Debug.EnumDebugMode.COSMETIC_IMAGE_MANAGER, "Unloaded " + resourceLocation.a());
                    }
                    handler.getResourceLocations().remove(rem);
                    User user = LabyMod.getInstance().getUserManager().getUser(rem);
                    if (user == null) continue;
                    user.unloadCosmeticTextures();
                }
                handler.unload();
                Debug.log(Debug.EnumDebugMode.COSMETIC_IMAGE_MANAGER, "Unloaded " + toRemove.size() + " unused " + handler.getResourceName() + " and " + noImage + " had no labymod textures! " + handler.getResourceLocations().size() + " " + handler.getResourceName() + " left.");
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }

    public List<CosmeticImageHandler> getCosmeticImageHandlers() {
        return this.cosmeticImageHandlers;
    }

    public CloakImageHandler getCloakImageHandler() {
        return this.cloakImageHandler;
    }

    public BandanaImageHandler getBandanaImageHandler() {
        return this.bandanaImageHandler;
    }

    public ShoesImageHandler getShoesImageHandler() {
        return this.shoesImageHandler;
    }

    public StickerImageHandler getStickerImageHandler() {
        return this.stickerImageHandler;
    }

    public KawaiiMaskImageHandler getKawaiiMaskImageHandler() {
        return this.kawaiiMaskImageHandler;
    }

    public CoverMaskImageHandler getCoverMaskImageHandler() {
        return this.coverMaskImageHandler;
    }

    public WatchImageHandler getWatchImageHandler() {
        return this.watchImageHandler;
    }

    public AngelWingsImageHandler getAngelWingsImageHandler() {
        return this.angelWingsImageHandler;
    }

    public CapImageHandler getCapImageHandler() {
        return this.capImageHandler;
    }

    public PetDragonImageHandler getPetDragonImageHandler() {
        return this.petDragonImageHandler;
    }

    public BunnyShoesImageHandler getBunnyShoesImageHandler() {
        return this.bunnyShoesImageHandler;
    }

    public ScarfImageHandler getScarfImageHandler() {
        return this.scarfImageHandler;
    }
}

