/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Inflater;
import net.labymod.api.events.PluginMessageEvent;
import net.labymod.api.events.ServerMessageEvent;
import net.labymod.labyconnect.packets.PacketActionPlay;
import net.labymod.labyconnect.packets.PacketActionPlayResponse;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.splash.SplashLoader;
import net.labymod.support.util.Debug;
import net.labymod.user.User;
import net.labymod.user.cosmetic.CosmeticImageManager;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.custom.CosmeticImageHandler;
import net.labymod.user.cosmetic.custom.UserTextureContainer;
import net.labymod.user.cosmetic.custom.handler.CloakImageHandler;
import net.labymod.user.cosmetic.custom.handler.RemoteImageHandler;
import net.labymod.user.cosmetic.remote.IRemoteCallback;
import net.labymod.user.cosmetic.remote.RemoteCosmeticLoader;
import net.labymod.user.cosmetic.remote.objects.data.RemoteData;
import net.labymod.user.cosmetic.util.CosmeticClassLoader;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.user.cosmetic.util.EnumLegacyCosmeticType;
import net.labymod.user.group.GroupManager;
import net.labymod.user.group.LabyGroup;
import net.labymod.user.gui.UserActionGui;
import net.labymod.user.util.FutureMap;
import net.labymod.user.util.UserResolvedCallback;
import net.labymod.utils.Consumer;
import net.labymod.utils.ModColor;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;

public class UserManager
implements ServerMessageEvent,
PluginMessageEvent {
    private ExecutorService executorService = Executors.newFixedThreadPool(5);
    private Map<UUID, User> users = new HashMap<UUID, User>();
    private boolean whitelistLoaded = false;
    private boolean subTitlesModified = false;
    private List<Long> whitelistedUsers = new ArrayList<Long>();
    private Map<UUID, Boolean> checkedUsers = new HashMap<UUID, Boolean>();
    private Map<Integer, Class<?>> cosmeticIdToClassData = new HashMap();
    private JsonParser jsonParser = new JsonParser();
    private CosmeticImageManager cosmeticImageManager = new CosmeticImageManager(Source.getUserAgent());
    private UserActionGui userActionGui = new UserActionGui(this);
    private CosmeticClassLoader cosmeticClassLoader = new CosmeticClassLoader();
    private GroupManager groupManager = new GroupManager();
    private RemoteCosmeticLoader remoteCosmeticLoader = new RemoteCosmeticLoader();
    protected AtomicInteger currentRequestId = new AtomicInteger(Short.MIN_VALUE);
    protected FutureMap<Short, PacketActionPlayResponse> responseFutureMap = new FutureMap<Short, Object>(requestId -> {}, 1000L, null);
    protected boolean lastSpamProtectedLegState = false;
    private CloakImageHandler.EnumCapePriority capePriority;

    public UserManager() {
        try {
            try {
                for (Class<?> loadedClassInfo : this.cosmeticClassLoader.getCosmeticClasses()) {
                    CosmeticRenderer cosmeticRenderer = (CosmeticRenderer)loadedClassInfo.newInstance();
                    for (Class<?> subClasses : loadedClassInfo.getClasses()) {
                        if (!CosmeticData.class.isAssignableFrom(subClasses)) continue;
                        this.cosmeticIdToClassData.put(cosmeticRenderer.getCosmeticId(), subClasses);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.remoteCosmeticLoader.getAsync(new IRemoteCallback(){

                @Override
                public void load(CosmeticRenderer<?> renderer) {
                    for (Class<?> subClasses : renderer.getClass().getClasses()) {
                        if (!CosmeticData.class.isAssignableFrom(subClasses)) continue;
                        int id = renderer.getCosmeticId();
                        UserManager.this.cosmeticIdToClassData.put(renderer.getCosmeticId(), subClasses);
                        for (User user : LabyMod.getInstance().getUserManager().getUsers().values()) {
                            if (!user.getPossibleRemoteIds().containsKey(id)) continue;
                            try {
                                CosmeticData data = UserManager.this.loadData(user, renderer.getCosmeticId(), user.getPossibleRemoteIds().get(id), subClasses);
                                user.getCosmetics().put(id, data);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }

                @Override
                public void unload(CosmeticRenderer<?> renderer) {
                    int id = renderer.getCosmeticId();
                    UserManager.this.cosmeticIdToClassData.remove(id);
                    for (User user : LabyMod.getInstance().getUserManager().getUsers().values()) {
                        user.getCosmetics().remove(id);
                    }
                }
            });
            Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Registered " + this.cosmeticIdToClassData.size() + " cosmetics!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LabyMod.getInstance().getEventManager().register(this);
        LabyMod.getInstance().getEventManager().register(this);
        try {
            this.capePriority = CloakImageHandler.EnumCapePriority.valueOf(LabyMod.getSettings().capePriority);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    @Override
    public void onServerMessage(String messageKey, JsonElement serverMessage) {
        if (messageKey.equals("account_subtitle")) {
            this.subTitlesModified = true;
            try {
                JsonArray jsonArray = serverMessage.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    double subTitleSize;
                    String subTitle;
                    JsonObject accountEntry = jsonArray.get(i).getAsJsonObject();
                    if (!accountEntry.has("uuid")) continue;
                    UUID uuid = UUID.fromString(accountEntry.get("uuid").getAsString());
                    User user = this.getUser(uuid);
                    boolean prevHasSubTitle = user.getSubTitle() != null;
                    String string = subTitle = accountEntry.has("value") ? accountEntry.get("value").getAsString() : null;
                    if (subTitle != null) {
                        subTitle = ModColor.createColors(subTitle);
                    }
                    double d = subTitleSize = accountEntry.has("size") ? accountEntry.get("size").getAsDouble() : 0.5;
                    if (subTitleSize < 0.8) {
                        subTitleSize = 0.8;
                    }
                    if (subTitleSize > 1.6) {
                        subTitleSize = 1.6;
                    }
                    user.setSubTitle(subTitle);
                    user.setSubTitleSize(subTitleSize);
                    if (!prevHasSubTitle && subTitle != null) {
                        Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Added subtitle for " + uuid.toString() + ": " + subTitle);
                        continue;
                    }
                    if (prevHasSubTitle && subTitle == null) {
                        Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Removed subtitle of " + uuid.toString() + "!");
                        continue;
                    }
                    Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Updated subtitle of " + uuid.toString() + " to " + subTitle);
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }

    @Override
    public void receiveMessage(String channelName, em packetBuffer) {
        if (this.subTitlesModified && channelName.equals("MC|Brand")) {
            for (User user : this.users.values()) {
                user.setSubTitle(null);
            }
            this.subTitlesModified = false;
        }
    }

    public void init(final UUID clientUUID, final Consumer<Boolean> consumer) {
        this.loadWhitelist(new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Loaded " + accepted + " whitelisted users.");
                UserManager.this.setChecked(clientUUID, false);
                if (clientUUID != null && UserManager.this.containsInCSV(clientUUID)) {
                    UserManager.this.getUserDataOf(clientUUID, new Consumer<User>(){

                        @Override
                        public void accept(User user) {
                            UserManager.this.setChecked(clientUUID, true);
                            consumer.accept(true);
                            UserManager.this.remoteCosmeticLoader.load();
                        }
                    });
                } else {
                    consumer.accept(accepted != 0);
                    UserManager.this.remoteCosmeticLoader.load();
                }
            }
        });
    }

    public User getUser(UUID uuid) {
        User user = this.users.get(uuid);
        if (user == null) {
            user = new User(uuid);
            this.users.put(uuid, user);
        }
        return user;
    }

    public boolean isWhitelisted(final UUID uuid) {
        if (!this.whitelistLoaded) {
            return false;
        }
        Boolean result = this.checkedUsers.get(uuid);
        if (result == null) {
            this.checkedUsers.put(uuid, false);
            if (this.containsInCSV(uuid)) {
                this.getUserDataOf(uuid, new Consumer<User>(){

                    @Override
                    public void accept(User user) {
                        UserManager.this.setChecked(uuid, true);
                    }
                });
            }
            return false;
        }
        return result;
    }

    private boolean containsInCSV(UUID uuid) {
        long uuidPart = uuid.getMostSignificantBits() >> 32 & 0xFFFFFFFFL;
        return this.whitelistedUsers.contains(uuidPart);
    }

    private void getUserDataOf(UUID uuid, final Consumer<User> callback) {
        try {
            try {
                final User user = this.getUser(uuid);
                this.loadUserData(user, new UserResolvedCallback(){

                    @Override
                    public void resolvedGroup(LabyGroup group) {
                        user.setGroup(group);
                    }

                    @Override
                    public void resolvedCosmetics(Map<Integer, CosmeticData> cosmetics) {
                        user.setCosmetics(cosmetics);
                    }

                    @Override
                    public void resolvedDailyEmoteFlat(boolean value) {
                        user.setDailyEmoteFlat(value);
                    }

                    @Override
                    public void complete() {
                        if (callback != null) {
                            callback.accept(user);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception error) {
            Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Error while resolving user data of " + uuid.toString() + " (" + error.getMessage() + ")");
            error.printStackTrace();
        }
    }

    public void updateUsersJson(final UUID uuid, final String json, final Consumer<Boolean> callback) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        final User user = UserManager.this.getUser(uuid);
                        UserManager.this.handleJsonString(user, json, new UserResolvedCallback(){

                            @Override
                            public void resolvedGroup(LabyGroup group) {
                                user.setGroup(group);
                            }

                            @Override
                            public void resolvedCosmetics(Map<Integer, CosmeticData> cosmetics) {
                                user.setCosmetics(cosmetics);
                            }

                            @Override
                            public void resolvedDailyEmoteFlat(boolean value) {
                                user.setDailyEmoteFlat(value);
                            }

                            @Override
                            public void complete() {
                                if (callback != null) {
                                    callback.accept(true);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block2;
                        callback.accept(false);
                    }
                }
            }
        });
    }

    private void loadUserData(final User user, final UserResolvedCallback callback) throws Exception {
        String url = String.format("https://dl.labymod.net/userdata/%s.json", user.getUuid().toString());
        Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Load user data of " + user.getUuid().toString());
        DownloadServerRequest.getStringAsync(url, new ServerResponse<String>(){

            @Override
            public void success(String json) {
                try {
                    UserManager.this.handleJsonString(user, json, callback);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void failed(RequestException exception) {
                Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Response code for " + user.getUuid().toString() + " is " + exception.getCode());
            }
        });
    }

    private void handleJsonString(User user, String jsonString, UserResolvedCallback callback) throws Exception {
        boolean isClient = user.getUuid().equals(LabyMod.getInstance().getPlayerUUID());
        if (isClient) {
            Debug.log(Debug.EnumDebugMode.USER_MANAGER, jsonString);
        }
        JsonElement jsonElement = this.jsonParser.parse(jsonString);
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        user.setHideCape(false);
        try {
            JsonObject flatObject;
            JsonObject group;
            short id;
            LabyGroup labyGroup;
            JsonArray groupArray;
            if (jsonObject.has("c")) {
                JsonArray jsonArray = jsonObject.get("c").getAsJsonArray();
                Iterator cosmeticIterator = jsonArray.iterator();
                HashMap<Integer, CosmeticData> storedCosmeticData = new HashMap<Integer, CosmeticData>();
                HashMap<EnumLegacyCosmeticType, Integer> priorityLevels = new HashMap<EnumLegacyCosmeticType, Integer>();
                while (cosmeticIterator.hasNext()) {
                    EnumLegacyCosmeticType type;
                    JsonObject cosmeticJsonObject = ((JsonElement)cosmeticIterator.next()).getAsJsonObject();
                    if (!cosmeticJsonObject.has("i")) {
                        Debug.log(Debug.EnumDebugMode.USER_MANAGER, cosmeticJsonObject.toString() + " has no id");
                        continue;
                    }
                    int id2 = cosmeticJsonObject.get("i").getAsInt();
                    this.remoteCosmeticLoader.discover(id2);
                    if (!cosmeticJsonObject.has("d")) {
                        Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Cosmetic id " + id2 + " has no data (" + cosmeticJsonObject.toString() + ")");
                        continue;
                    }
                    JsonArray dataArray = cosmeticJsonObject.get("d").getAsJsonArray();
                    Iterator dataIterator = dataArray.iterator();
                    ArrayList<String> dataList = new ArrayList<String>();
                    while (dataIterator.hasNext()) {
                        JsonElement dataElement = (JsonElement)dataIterator.next();
                        if (dataElement.isJsonNull()) continue;
                        String dataString = dataElement.getAsString();
                        dataList.add(dataString);
                    }
                    Class<?> dataClass = this.cosmeticIdToClassData.get(id2);
                    if (dataClass == null) {
                        user.getPossibleRemoteIds().put(id2, dataList);
                        Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Cosmetic id " + id2 + " not found in cosmeticIdToClassData (size=" + this.cosmeticIdToClassData.size() + ") Maybe a remote cosmetic?");
                        continue;
                    }
                    CosmeticData data = this.loadData(user, id2, dataList, dataClass);
                    storedCosmeticData.put(id2, data);
                    if (id2 == 22) {
                        user.getBandanaContainer().resolved();
                    }
                    if (id2 == 33) {
                        user.getWatchContainer().resolved();
                    }
                    if (id2 == 24) {
                        user.getAngelWingsContainer().resolved();
                    }
                    if (id2 == 19) {
                        user.getCapContainer().resolved();
                    }
                    if (priorityLevels.containsKey((Object)(type = data.getType()))) {
                        int level;
                        data.priorityLevel = level = (Integer)priorityLevels.get((Object)type) + 1;
                        priorityLevels.put(type, data.priorityLevel);
                        continue;
                    }
                    data.priorityLevel = 0;
                    priorityLevels.put(type, 0);
                }
                callback.resolvedCosmetics(storedCosmeticData);
                for (CosmeticData data : storedCosmeticData.values()) {
                    data.completed(user);
                }
            }
            if (jsonObject.has("e")) {
                JsonArray emoteArray = jsonObject.get("e").getAsJsonArray();
                Iterator emoteIterator = emoteArray.iterator();
                ArrayList<Short> emotes = new ArrayList<Short>();
                while (emoteIterator.hasNext()) {
                    JsonElement element = (JsonElement)emoteIterator.next();
                    short emoteId = element.getAsShort();
                    emotes.add(emoteId);
                }
                user.setEmotes(emotes);
            }
            if (jsonObject.has("st") || jsonObject.has("s")) {
                JsonObject stickerObject = (jsonObject.has("s") ? jsonObject.get("s") : jsonObject.get("st")).getAsJsonObject();
                Iterator packsArray = stickerObject.get("p").getAsJsonArray().iterator();
                ArrayList<Short> packs = new ArrayList<Short>();
                while (packsArray.hasNext()) {
                    short packId = ((JsonElement)packsArray.next()).getAsShort();
                    packs.add(packId);
                }
                user.setStickerPacks(packs);
            }
            if (jsonObject.has("g") && (groupArray = jsonObject.get("g").getAsJsonArray()).size() > 0 && (labyGroup = this.groupManager.getGroupById(id = (group = groupArray.get(0).getAsJsonObject()).get("i").getAsShort())) != null) {
                callback.resolvedGroup(labyGroup);
            }
            if (jsonObject.has("f") && (flatObject = jsonObject.get("f").getAsJsonObject()).has("e")) {
                callback.resolvedDailyEmoteFlat(flatObject.get("e").getAsBoolean());
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        callback.complete();
    }

    private CosmeticData loadData(User user, int id, List<String> dataList, Class<?> dataClass) throws InstantiationException, IllegalAccessException {
        CosmeticData cosmeticData = (CosmeticData)dataClass.newInstance();
        boolean isClient = user.getUuid().equals(LabyMod.getInstance().getPlayerUUID());
        try {
            cosmeticData.init(id, user);
            String[] array = dataList.toArray(new String[dataList.size()]);
            if (array.length != 0) {
                cosmeticData.loadData(array);
            }
            if (isClient) {
                Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Loaded cosmetic " + id + " for client");
            }
        }
        catch (Exception error) {
            Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Parse error while loading " + dataClass.getSimpleName() + ": " + error.getMessage());
        }
        if (cosmeticData instanceof RemoteData) {
            for (CosmeticImageHandler cosmeticImageHandler : this.getCosmeticImageManager().getCosmeticImageHandlers()) {
                if (!(cosmeticImageHandler instanceof RemoteImageHandler) || ((RemoteImageHandler)cosmeticImageHandler).id != id) continue;
                UserTextureContainer container = cosmeticImageHandler.getContainer(user);
                UUID textureUUID = ((RemoteData)cosmeticData).textureUUID;
                if (container != null && textureUUID != null) {
                    container.setFileName(textureUUID);
                }
                if (!((RemoteImageHandler)cosmeticImageHandler).isHideCape()) continue;
                user.setHideCape(true);
            }
        }
        for (Map.Entry entry : user.getRemoteContainer().entrySet()) {
            if ((Integer)entry.getKey() != id) continue;
            ((UserTextureContainer)entry.getValue()).resolved();
        }
        return cosmeticData;
    }

    public void loadWhitelist(final Consumer<Integer> callback) {
        Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Load whitelist..");
        DownloadServerRequest.getBytesAsync("https://dl.labymod.net/whitelist.bin", new ServerResponse<byte[]>(){

            @Override
            public void success(byte[] compressedBytes) {
                try {
                    int count;
                    Inflater inflater = new Inflater();
                    inflater.setInput(compressedBytes);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream(compressedBytes.length);
                    byte[] buffer2 = new byte[1024];
                    while (!inflater.finished() && (count = inflater.inflate(buffer2)) != 0) {
                        outputStream.write(buffer2, 0, count);
                    }
                    outputStream.close();
                    byte[] decompressedBytes = outputStream.toByteArray();
                    for (int b2 = 0; b2 < decompressedBytes.length; b2 += 8) {
                        long uuidPart = 0L;
                        for (int i = 0; i < 8; ++i) {
                            uuidPart += ((long)decompressedBytes[b2 + i] & 0xFFL) << 8 * i;
                        }
                        UserManager.this.whitelistedUsers.add(uuidPart);
                    }
                    UserManager.this.whitelistLoaded = true;
                    callback.accept(UserManager.this.whitelistedUsers.size());
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
            }
        });
    }

    public void setChecked(UUID uuid, boolean value) {
        this.checkedUsers.put(uuid, value);
    }

    public void removeCheckedUser(UUID uuid) {
        this.checkedUsers.remove(uuid);
    }

    public void clearCache() {
        this.whitelistLoaded = false;
        this.users.clear();
        this.whitelistedUsers.clear();
        this.checkedUsers.clear();
        this.cosmeticImageManager.unloadUnusedTextures(true, true);
    }

    public void requestAction(short id, byte[] bytes, FutureCallback<PacketActionPlayResponse> callback) {
        int requestId = 0;
        requestId = this.currentRequestId.incrementAndGet();
        if (requestId > Short.MAX_VALUE) {
            this.currentRequestId.set(Short.MIN_VALUE);
            requestId = Short.MIN_VALUE;
        }
        Futures.addCallback(this.responseFutureMap.get((short)requestId), callback);
        LabyMod.getInstance().getLabyConnect().getClientConnection().sendPacket(new PacketActionPlay((short)requestId, id, bytes));
    }

    public void resolveAction(short requestId, PacketActionPlayResponse packetActionPlayResponse) {
        this.responseFutureMap.resolve(requestId, packetActionPlayResponse);
    }

    public void refresh() {
        this.remoteCosmeticLoader.reset();
        this.clearCache();
        this.init(LabyMod.getInstance().getPlayerUUID(), new Consumer<Boolean>(){

            @Override
            public void accept(Boolean success) {
                LabyMod.getInstance().getUserManager().getCosmeticImageManager().loadPlayersInView();
            }
        });
        this.getGroupManager().load();
        LabyMod.getInstance().getEmoteRegistry().loadEmoteSources();
        LabyMod.getInstance().getStickerRegistry().loadPacks();
        SplashLoader.getLoader().load();
    }

    public boolean canSeeDraftCosmetics(User user) {
        return this.groupManager.hasPermissionOf(user, (short)11);
    }

    public User getClientUser() {
        UUID uuid = LabyMod.getInstance().getPlayerUUID();
        return uuid == null ? null : this.getUser(LabyMod.getInstance().getPlayerUUID());
    }

    public void resetFamiliars() {
        for (User user : this.users.values()) {
            user.setFamiliar(false);
        }
    }

    public Map<UUID, User> getUsers() {
        return this.users;
    }

    public Map<Integer, Class<?>> getCosmeticIdToClassData() {
        return this.cosmeticIdToClassData;
    }

    public CosmeticImageManager getCosmeticImageManager() {
        return this.cosmeticImageManager;
    }

    public UserActionGui getUserActionGui() {
        return this.userActionGui;
    }

    public CosmeticClassLoader getCosmeticClassLoader() {
        return this.cosmeticClassLoader;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public RemoteCosmeticLoader getRemoteCosmeticLoader() {
        return this.remoteCosmeticLoader;
    }

    public CloakImageHandler.EnumCapePriority getCapePriority() {
        return this.capePriority;
    }

    public void setCapePriority(CloakImageHandler.EnumCapePriority capePriority) {
        this.capePriority = capePriority;
    }
}

