/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.support.gui;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.SliderElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.JsonParse;
import net.labymod.utils.LauncherDirectoryUtils;
import net.labymod.utils.Material;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModUtils;
import org.apache.commons.io.IOUtils;
import org.lwjgl.input.Keyboard;

public class GuiMemoryUpgrade
extends axu {
    private final File launcherProfilesFile = new File(LauncherDirectoryUtils.getWorkingDirectory(), "launcher_profiles.json");
    private final GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
    private static final long TRIGGER_MAX_MEMORY = 2048000000L;
    private static final int TRIGGER_SCORE = 3;
    private static final long TRIGGER_FRAME_DURATION = 100L;
    private static long maxMemoryUsed = 0L;
    private static long lastMemoryMax = 0L;
    private static boolean outOfMemoryDetected = false;
    private static long lastFrameMemory = -1L;
    private static long lastFrameTimestamp = -1L;
    private static int frameHits = 0;
    private SliderElement element;
    private avs buttonRestartGame;
    private String errorMessage = null;
    private int totalMB;
    private int updatedMB;

    public GuiMemoryUpgrade() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        int totalMB = (int)(maxMemory / 1000000L);
        if (totalMB < 1) {
            totalMB = 1;
        }
        this.totalMB = totalMB;
        this.updatedMB = totalMB;
    }

    public void b() {
        this.n.clear();
        int divY = this.m / 2 - 40 + 50;
        this.n.add(new avs(0, this.l / 2 - 100, divY + 30, 90, 20, LanguageManager.translate("button_cancel")));
        this.buttonRestartGame = new avs(1, this.l / 2 + 10, divY + 30, 90, 20, LanguageManager.translate("button_restart"));
        this.n.add(this.buttonRestartGame);
        this.buttonRestartGame.l = this.totalMB != this.updatedMB;
        this.element = new SliderElement(LanguageManager.translate("out_of_memory_slider"), new ControlElement.IconData(Material.IRON_PICKAXE), this.updatedMB).addCallback(new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                ((GuiMemoryUpgrade)GuiMemoryUpgrade.this).buttonRestartGame.l = GuiMemoryUpgrade.this.totalMB != accepted;
                GuiMemoryUpgrade.this.updatedMB = accepted;
            }
        }).setRange(512, 4096).setSteps(512);
        super.b();
    }

    private boolean updateMemoryArguments(String version, int mb) throws Exception {
        String javaArgs;
        JsonObject mainObject = JsonParse.parse(IOUtils.toString((InputStream)new FileInputStream(this.launcherProfilesFile))).getAsJsonObject();
        JsonObject profiles = mainObject.get("profiles").getAsJsonObject();
        if (!profiles.has(version)) {
            return false;
        }
        JsonObject versionObject = profiles.get(version).getAsJsonObject();
        if (versionObject.has(javaArgs = "javaArgs")) {
            String arguments = versionObject.get(javaArgs).getAsString();
            String newArguments = arguments.replaceAll("-[x|X][m|M][x|X][0-9]+\\w+", "-Xmx" + mb + "M");
            versionObject.addProperty(javaArgs, newArguments);
        } else {
            versionObject.addProperty(javaArgs, "-Xmx" + mb + "M");
        }
        IOUtils.write((String)this.gsonBuilder.create().toJson((JsonElement)mainObject), (OutputStream)new FileOutputStream(this.launcherProfilesFile), (Charset)Charset.forName("UTF-8"));
        return true;
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c(0);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int divY = this.m / 2 - 40;
        draw.drawCenteredString(ModColor.cl('c') + LanguageManager.translate("out_of_memory_slider"), this.l / 2, divY);
        draw.drawCenteredString(LanguageManager.translate("out_of_memory_subtitle"), this.l / 2, divY + 10);
        draw.drawCenteredString(this.errorMessage == null ? ModColor.cl('a') + LanguageManager.translate("out_of_memory_recommendation") : ModColor.cl("4") + this.errorMessage, this.l / 2, divY + 30);
        int centerPosX = this.l / 2;
        int centerPosY = divY + 55;
        int elementWidth = 200;
        int elementHeight = 22;
        String value = ModColor.cl('b') + "= " + ModUtils.humanReadableByteCount((long)this.updatedMB * 1000000L, true, true);
        draw.drawString(value, centerPosX + elementWidth / 2 + 5, centerPosY - 3);
        this.element.draw(centerPosX - elementWidth / 2, centerPosY - elementHeight / 2, centerPosX + elementWidth / 2, centerPosY + elementHeight / 2, mouseX, mouseY);
        super.a(mouseX, mouseY, partialTicks);
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.element.mouseClicked(mouseX, mouseY, mouseButton);
        super.a(mouseX, mouseY, mouseButton);
    }

    protected void b(int mouseX, int mouseY, int state) {
        this.element.mouseRelease(mouseX, mouseY, state);
        super.b(mouseX, mouseY, state);
    }

    protected void a(avs button) throws IOException {
        switch (button.k) {
            case 0: {
                ave.A().a((axu)(LabyMod.getInstance().isInGame() ? null : new aya()));
                break;
            }
            case 1: {
                try {
                    String version = ave.A().c();
                    this.killMinecraftLauncher();
                    if (this.updateMemoryArguments(Source.PROFILE_VERSION_NAME, this.updatedMB) | this.updateMemoryArguments(version, this.updatedMB)) {
                        ave.A().m();
                        break;
                    }
                    this.errorMessage = LanguageManager.translate("out_of_memory_profile_not_found", version);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.errorMessage = "ERROR: " + e.getMessage();
                }
            }
        }
        super.a(button);
    }

    private void killMinecraftLauncher() {
        try {
            Runtime runtime = Runtime.getRuntime();
            runtime.exec("taskkill /F /IM MinecraftLauncher.exe");
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public static void renderTickOutOfMemoryDetector() {
        long percent;
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory >= 2048000000L) {
            return;
        }
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        maxMemoryUsed = Math.max(usedMemory, lastMemoryMax == maxMemory ? maxMemoryUsed : usedMemory);
        lastMemoryMax = maxMemory;
        if (!outOfMemoryDetected && lastFrameMemory != -1L) {
            long frameDuration = System.currentTimeMillis() - lastFrameTimestamp;
            if (maxMemoryUsed >= 99L) {
                outOfMemoryDetected = true;
            } else if (lastFrameMemory > usedMemory) {
                if (frameDuration > 100L) {
                    if (++frameHits >= 3) {
                        outOfMemoryDetected = true;
                    }
                } else if (frameHits > 0) {
                    --frameHits;
                }
            } else if (frameDuration > 100L && frameHits > 0) {
                --frameHits;
            }
        }
        if ((percent = maxMemoryUsed * 100L / maxMemory) >= 90L) {
            lastFrameMemory = usedMemory;
            lastFrameTimestamp = System.currentTimeMillis();
        } else {
            lastFrameMemory = -1L;
        }
        if (outOfMemoryDetected) {
            GuiMemoryUpgrade.renderWarning(percent);
            frameHits = 0;
        }
    }

    private static void renderWarning(long percent) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        bfl.E();
        bfl.b((float)0.0f, (float)0.0f, (float)10.0f);
        String string = LanguageManager.translate("out_of_memory_warning_explanation");
        int margin = 3;
        int warningWidth = 200;
        List<String> lines = draw.listFormattedStringToWidth(string, warningWidth - margin * 3);
        int warningHeight = 10 + lines.size() * 10 + margin + 1;
        double warningX = draw.getWidth() - warningWidth - 1;
        int warningY = 2;
        draw.drawRect(warningX, warningY, warningX + (double)warningWidth, warningY + warningHeight, Integer.MIN_VALUE);
        draw.drawRectBorder(warningX, warningY, warningX + (double)warningWidth, warningY + warningHeight, Integer.MIN_VALUE, 1.0);
        draw.drawString(ModColor.cl('c') + ModColor.cl('n') + LanguageManager.translate("out_of_memory_warning_title"), warningX + (double)margin, warningY + margin);
        draw.drawRightString(ModColor.cl('4') + percent + "%", warningX + (double)warningWidth - (double)margin, warningY + margin);
        int lineY = 11;
        for (String line : lines) {
            draw.drawString(ModColor.cl('f') + line, warningX + (double)margin, warningY + margin + lineY);
            lineY += 10;
        }
        if (Keyboard.isKeyDown((int)50)) {
            outOfMemoryDetected = false;
            ave.A().a((axu)new GuiMemoryUpgrade());
        }
        if (Keyboard.isKeyDown((int)37)) {
            outOfMemoryDetected = false;
            LabyMod.getSettings().outOfMemoryWarning = false;
        }
        bfl.b((float)0.0f, (float)0.0f, (float)-10.0f);
        bfl.F();
    }
}

