/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.support.gui;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.DropDownMenu;
import net.labymod.gui.elements.ModTextField;
import net.labymod.main.LabyMod;
import net.labymod.support.util.Debug;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.remote.IRemoteCallback;
import net.labymod.user.cosmetic.util.CosmeticClassLoader;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiCosmeticPreview
extends axu
implements Runnable {
    public static final GuiCosmeticPreview INSTANCE = new GuiCosmeticPreview();
    private axu lastScreen;
    private ModTextField fieldExternal;
    private ModTextField fieldInternal;
    private DropDownMenu<CosmeticRenderer<CosmeticData>> dropDownMenu;
    private File file;
    private int textureId;
    private long prevLastModified;
    private boolean animation = true;
    private boolean darkMode = true;
    private float pausedTickValue = 0.0f;
    private boolean currentDragging = false;
    private boolean currentMoving = false;
    private double mouseClickedX;
    private double mouseClickedY;
    private double dragPreviewX = 0.0;
    private double dragPreviewY = 0.0;
    private double clickedYaw = 0.0;
    private double startMoveClickX = 0.0;
    private double startMoveClickY = 0.0;
    private double moveX = 0.0;
    private double moveY = 0.0;
    private double zoomValue = 200.0;
    protected Map<Integer, CosmeticRenderer<CosmeticData>> cosmeticRenderers = new HashMap<Integer, CosmeticRenderer<CosmeticData>>();
    private ModelCosmetics modelCosmetics = new ModelCosmetics(0.0625f, true);
    private CosmeticRenderer<CosmeticData> cosmeticRenderer;
    private CosmeticData cosmeticData;

    private GuiCosmeticPreview() {
        this.fieldExternal = new ModTextField(10, LabyModCore.getMinecraft().getFontRenderer(), 130, 5, 100, 20);
        this.fieldInternal = new ModTextField(11, LabyModCore.getMinecraft().getFontRenderer(), 235, 5, 100, 20);
        this.fieldInternal.setText("labymod/textures/cosmetics/");
        try {
            CosmeticClassLoader cosmeticClassLoader = new CosmeticClassLoader();
            for (Class<?> loadedClassInfo : cosmeticClassLoader.getCosmeticClasses()) {
                CosmeticRenderer cosmeticRenderer = (CosmeticRenderer)loadedClassInfo.newInstance();
                cosmeticRenderer.addModels(this.modelCosmetics, 0.0625f);
                this.cosmeticRenderers.put(cosmeticRenderer.getCosmeticId(), cosmeticRenderer);
            }
            LabyMod.getInstance().getUserManager().getRemoteCosmeticLoader().getAsync(new IRemoteCallback(){

                @Override
                public void load(CosmeticRenderer<?> renderer) {
                    renderer.addModels(GuiCosmeticPreview.this.modelCosmetics, 0.0625f);
                    GuiCosmeticPreview.this.cosmeticRenderers.put(renderer.getCosmeticId(), renderer);
                    GuiCosmeticPreview.this.b();
                }

                @Override
                public void unload(CosmeticRenderer<?> renderer) {
                    GuiCosmeticPreview.this.cosmeticRenderers.remove(renderer.getCosmeticId());
                    GuiCosmeticPreview.this.b();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this, 0L, 1L, TimeUnit.SECONDS);
    }

    public void b() {
        super.b();
        CosmeticRenderer<CosmeticData> selected = this.dropDownMenu != null ? this.dropDownMenu.getSelected() : null;
        this.dropDownMenu = new DropDownMenu("", 5, 5, 120, 20);
        this.dropDownMenu.setEntryDrawer(new DropDownMenu.DropDownEntryDrawer(){

            @Override
            public void draw(Object object, int x, int y, String trimmedEntry) {
                CosmeticRenderer cosmetic = (CosmeticRenderer)object;
                LabyMod.getInstance().getDrawUtils().drawString(ModColor.cl('c') + cosmetic.getCosmeticId() + ModColor.cl('7') + ": " + ModColor.cl(cosmetic == GuiCosmeticPreview.this.cosmeticRenderer ? (char)'e' : 'f') + cosmetic.getCosmeticName(), x, y);
            }
        });
        for (Map.Entry<Integer, CosmeticRenderer<CosmeticData>> entry : this.cosmeticRenderers.entrySet()) {
            this.dropDownMenu.addOption(entry.getValue());
        }
        this.dropDownMenu.setSelected(selected);
        this.fieldExternal.setMaxStringLength(700);
        this.fieldInternal.setMaxStringLength(700);
        this.fieldExternal.setPlaceHolder("External png file");
        this.fieldInternal.setPlaceHolder("Internal resource");
        this.fieldExternal.setCursorPositionEnd();
        this.fieldInternal.setCursorPositionEnd();
        Keyboard.enableRepeatEvents((boolean)true);
        this.n.clear();
        this.n.add(new avs(1, this.l - 85, 5, 80, 20, "Animation: " + (this.animation ? ModColor.cl('a') + "ON" : ModColor.cl('c') + "OFF")));
        this.n.add(new avs(2, this.l - 85 - 85, 5, 80, 20, "Dark mode: " + (this.darkMode ? ModColor.cl('a') + "ON" : ModColor.cl('c') + "OFF")));
        this.n.add(new avs(3, this.l - 55, 30, 50, 20, "Refresh"));
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        switch (button.k) {
            case 1: {
                this.animation = !this.animation;
                button.j = "Animation: " + (this.animation ? ModColor.cl('a') + "ON" : ModColor.cl('c') + "OFF");
                this.pausedTickValue = this.getCurrentTickValue();
                break;
            }
            case 2: {
                this.darkMode = !this.darkMode;
                button.j = "Dark Mode: " + (this.darkMode ? ModColor.cl('a') + "ON" : ModColor.cl('c') + "OFF");
                break;
            }
            case 3: {
                button.l = false;
                LabyMod.getInstance().getUserManager().refresh();
                this.cosmeticRenderer = null;
                try {
                    this.select(this.dropDownMenu.getSelected());
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c(0);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        if (LabyMod.getInstance().isInGame()) {
            avp.a((int)0, (int)0, (int)this.l, (int)this.m, (int)(this.darkMode ? ModColor.toRGB(54, 57, 63, 255) : ModColor.toRGB(180, 180, 180, 255)));
            bew player = LabyModCore.getMinecraft().getPlayer();
            if (this.cosmeticRenderer != null) {
                bfl.E();
                bfl.b((double)((double)(this.l / 2) + this.moveX), (double)((double)(this.m / 2) + this.moveY), (double)500.0);
                bfl.a((double)this.zoomValue, (double)this.zoomValue, (double)this.zoomValue);
                bfl.b((float)((float)(-this.dragPreviewX) + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                bfl.b((float)((float)this.dragPreviewY), (float)1.0f, (float)0.0f, (float)0.0f);
                bfl.k();
                bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                bfl.a((int)0);
                bfl.a((int)1);
                bfl.g();
                bfl.a((int)1032, (int)5634);
                LabyModCore.getRenderImplementation().cullFaceBack();
                float pitch = (float)((this.dragPreviewY - 180.0) % 360.0) - 180.0f;
                float prevPitch = player.z;
                player.z = pitch < 0.0f ? pitch + 360.0f : pitch;
                player.B = player.z;
                bfl.a((float)-1.0f, (float)1.0f, (float)1.0f);
                this.cosmeticRenderer.render(this.modelCosmetics, (pk)player, this.cosmeticData, 0.0625f, 0.0f, 0.0f, this.animation ? this.getCurrentTickValue() : this.pausedTickValue, 0.0f, 0.0f, partialTicks, false);
                player.B = player.z = prevPitch;
                bfl.a((int)770, (int)771, (int)1, (int)0);
                bfl.w();
                bfl.j((int)7424);
                bfl.d();
                bfl.k();
                bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                bfl.k();
                bfl.G();
                bfl.F();
            }
            bfl.b((float)0.0f, (float)0.0f, (float)800.0f);
            this.dropDownMenu.draw(mouseX, mouseY);
            this.fieldExternal.drawTextBox();
            this.fieldInternal.drawTextBox();
        } else {
            draw.drawCenteredString("Not ingame", this.l / 2, this.m / 2);
        }
        this.a(mouseX, mouseY, 0, 0L);
        super.a(mouseX, mouseY, partialTicks);
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        this.fieldExternal.mouseClicked(mouseX, mouseY, mouseButton);
        this.fieldInternal.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.dropDownMenu.onClick(mouseX, mouseY, mouseButton)) {
            try {
                CosmeticRenderer<CosmeticData> selected = this.dropDownMenu.getSelected();
                if (selected != null) {
                    this.select(selected);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mouseButton == 0 && !this.dropDownMenu.isOpen()) {
            this.currentDragging = true;
            this.mouseClickedX = (double)mouseX + this.dragPreviewX;
            this.mouseClickedY = (double)(this.clickedYaw > 180.0 ? -mouseY : mouseY) + this.dragPreviewY;
            this.clickedYaw = (this.dragPreviewX + 90.0) % 360.0;
        }
        if (mouseButton == 1 || mouseButton == 2) {
            this.startMoveClickX = -this.moveX + (double)mouseX;
            this.startMoveClickY = -this.moveY + (double)mouseY;
            this.currentMoving = true;
        }
    }

    private void select(CosmeticRenderer<CosmeticData> selected) throws Exception {
        int id = selected.getCosmeticId();
        CosmeticRenderer<CosmeticData> cosmeticRenderer = this.cosmeticRenderers.get(id);
        if (cosmeticRenderer != null && this.cosmeticRenderer != cosmeticRenderer) {
            this.cosmeticRenderer = cosmeticRenderer;
            Class<?> dataClass = LabyMod.getInstance().getUserManager().getCosmeticIdToClassData().get(id);
            this.cosmeticData = (CosmeticData)dataClass.newInstance();
            this.zoomValue = 200.0;
            this.dragPreviewX = 0.0;
            this.dragPreviewY = 0.0;
            this.moveX = 0.0;
            this.moveY = 0.0;
        }
    }

    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.dropDownMenu.onDrag(mouseX, mouseY, clickedMouseButton);
        if (this.currentDragging) {
            this.dragPreviewX = ((double)(-mouseX) + this.mouseClickedX) % 360.0;
            this.dragPreviewY = (double)(this.clickedYaw > 180.0 ? mouseY : -mouseY) + this.mouseClickedY;
        }
        if (this.currentMoving) {
            this.moveX = -this.startMoveClickX + (double)mouseX;
            this.moveY = -this.startMoveClickY + (double)mouseY;
        }
    }

    protected void b(int mouseX, int mouseY, int state) {
        super.b(mouseX, mouseY, state);
        this.dropDownMenu.onRelease(mouseX, mouseY, state);
        if (state == 0) {
            this.currentDragging = false;
            this.clickedYaw = (this.dragPreviewX + 90.0) % 360.0;
        }
        if (state == 1 || state == 2) {
            this.currentMoving = false;
        }
    }

    public void k() throws IOException {
        super.k();
        this.dropDownMenu.onScroll();
        if (!this.dropDownMenu.isOpen()) {
            int mouseScroll = Mouse.getDWheel();
            if (mouseScroll > 0) {
                this.zoomValue += 30.0;
            }
            if (mouseScroll < 0) {
                this.zoomValue -= 30.0;
            }
            if (this.zoomValue < 100.0) {
                this.zoomValue = 100.0;
            }
        }
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        boolean available;
        if (keyCode == 1 && this.lastScreen != null) {
            ave.A().a(this.lastScreen);
            return;
        }
        super.a(typedChar, keyCode);
        if (this.fieldExternal.textboxKeyTyped(typedChar, keyCode)) {
            String path = this.fieldExternal.getText();
            File file = new File(path);
            available = file.exists() && path.endsWith(".png");
            this.fieldExternal.setTextColor(available ? ModColor.GREEN.getColor().getRGB() : ModColor.RED.getColor().getRGB());
            this.file = available ? file : null;
            long l = this.prevLastModified = available ? file.lastModified() : 0L;
        }
        if (this.fieldInternal.textboxKeyTyped(typedChar, keyCode)) {
            String resourceName = this.fieldInternal.getText();
            bmk texture = ave.A().P().b(new jy(resourceName));
            available = texture != null;
            this.fieldInternal.setTextColor(available ? ModColor.GREEN.getColor().getRGB() : ModColor.RED.getColor().getRGB());
            this.textureId = available ? texture.b() : -1;
        }
    }

    public void e() {
        super.e();
        this.fieldExternal.updateCursorCounter();
        this.fieldInternal.updateCursorCounter();
    }

    private float getCurrentTickValue() {
        return (float)(System.currentTimeMillis() % 10000000L) / 50.0f;
    }

    @Override
    public void run() {
        if (this.file == null || this.textureId == -1 || !this.file.exists()) {
            return;
        }
        long lastModified = this.file.lastModified();
        if (lastModified == this.prevLastModified) {
            return;
        }
        this.prevLastModified = lastModified;
        try {
            final BufferedImage bufferedImage = ImageIO.read(this.file);
            final int[] dynamicTextureData = new int[bufferedImage.getWidth() * bufferedImage.getHeight()];
            bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), dynamicTextureData, 0, bufferedImage.getWidth());
            ave.A().a(new Runnable(){

                @Override
                public void run() {
                    bml.a((int)GuiCosmeticPreview.this.textureId, (int)bufferedImage.getWidth(), (int)bufferedImage.getHeight());
                    bml.a((int)GuiCosmeticPreview.this.textureId, (int[])dynamicTextureData, (int)bufferedImage.getWidth(), (int)bufferedImage.getHeight());
                    Debug.log(Debug.EnumDebugMode.COSMETIC_IMAGE_MANAGER, "Source " + GuiCosmeticPreview.this.file.getAbsolutePath() + " changed. Updated texture object id " + GuiCosmeticPreview.this.textureId);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static GuiCosmeticPreview create(axu lastScreen) {
        GuiCosmeticPreview.INSTANCE.lastScreen = lastScreen;
        return INSTANCE;
    }
}

