/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.splash;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import java.util.Calendar;
import java.util.Date;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.update.migration.LatestMinecraftPopupRenderer;
import net.labymod.main.update.migration.LatestMinecraftVersion;
import net.labymod.splash.SplashEntries;
import net.labymod.splash.advertisement.AdColorAdapter;
import net.labymod.splash.advertisement.Advertisement;
import net.labymod.splash.splashdates.SplashDate;
import net.labymod.support.DashboardConnector;
import net.labymod.support.util.Debug;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;

public class SplashLoader {
    private static SplashLoader loader = new SplashLoader();
    private final Gson gson;
    private final LatestMinecraftPopupRenderer latestMinecraftPopupRenderer = new LatestMinecraftPopupRenderer();
    private SplashEntries entries;
    private Advertisement hoverAdvertisement;
    private String customSplashText;
    private DashboardConnector dashboardConnector = new DashboardConnector();

    public SplashLoader() {
        this.gson = new GsonBuilder().registerTypeAdapter(Color.class, (Object)new AdColorAdapter()).create();
        this.load();
    }

    public void load() {
        DownloadServerRequest.getStringAsync("https://dl.labymod.net/advertisement/entries.json", new ServerResponse<String>(){

            @Override
            public void success(String json) {
                SplashLoader.this.entries = (SplashEntries)SplashLoader.this.gson.fromJson(json, SplashEntries.class);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                for (SplashDate date : SplashLoader.this.entries.getSplashDates()) {
                    if (calendar.get(2) + 1 != date.getMonth() || calendar.get(5) != date.getDay()) continue;
                    SplashLoader.this.customSplashText = date.getDisplayString();
                }
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
            }
        });
    }

    public void render(int mouseX, int mouseY) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        this.hoverAdvertisement = null;
        if (this.entries != null) {
            bfl.d();
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try {
                this.renderList(this.entries.getLeft(), false, 3, 3, mouseX, mouseY);
                this.renderList(this.entries.getRight(), true, draw.getWidth() - 3, 3, mouseX, mouseY);
            }
            catch (Exception error) {
                error.printStackTrace();
                this.entries = null;
            }
            if (this.latestMinecraftPopupRenderer.isVisible()) {
                LatestMinecraftVersion latest = LabyMod.getInstance().getUpdater().getLabyModUpdateChecker().getLatestMinecraftVersion();
                this.latestMinecraftPopupRenderer.draw(mouseX, mouseY, latest.minecraftVersion);
            }
            bfl.c();
        }
    }

    private void renderList(Advertisement[] advertisements, boolean rightBound, int positionX, int positionY, int mouseX, int mouseY) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int iconSize = 15;
        for (Advertisement advertisement : advertisements) {
            if (advertisement == null || !advertisement.isVisible()) continue;
            int x = positionX;
            bfl.E();
            int width = draw.getStringWidth(advertisement.getTitle()) + 2;
            if (rightBound) {
                x -= iconSize + width;
            }
            boolean hover = mouseX > x && mouseX < x + iconSize + width && mouseY > positionY && mouseY < positionY + iconSize;
            Color textColor = hover ? advertisement.getColorHover() : advertisement.getColor();
            String url = String.format("https://dl.labymod.net/advertisement/icons/%s.png", advertisement.getIconName());
            LabyMod.getInstance().getDrawUtils().drawImageUrl(url, x - (hover ? 1 : 0) + (rightBound ? width : 0), positionY - (hover ? 1 : 0), 255.0, 255.0, iconSize + (hover ? 2 : 0), iconSize + (hover ? 2 : 0));
            if (rightBound) {
                x -= iconSize + 2;
            }
            bfl.F();
            if (advertisement.isNew()) {
                float pause = (float)(Math.sin((double)System.currentTimeMillis() / 500.0) * 3.0);
                if (pause < 0.0f) {
                    pause = 0.0f;
                }
                float bounce = (float)Math.abs(Math.cos((double)System.currentTimeMillis() / 100.0) * (double)(-pause));
                ave.A().P().a(ModTextures.BUTTON_EXCLAMATION);
                draw.drawTexture(x + (rightBound ? width + 7 : 0) + 10 + (hover ? (rightBound ? -1 : 1) : 0), (float)(positionY + 5 + (hover ? 1 : 0)) - bounce, hover ? 125.0 : 0.0, 0.0, 120.0, 255.0, 5.0, 10.0, 1.0f);
            }
            draw.c(draw.getFontRenderer(), ModColor.createColors(advertisement.getTitle()), x + iconSize + 2 + (hover ? (rightBound ? -1 : 1) : 0), positionY + iconSize / 2 - 4, textColor.getRGB());
            if (hover) {
                this.hoverAdvertisement = advertisement;
            }
            positionY += iconSize + 1;
        }
        if (rightBound) {
            this.dashboardConnector.renderIcon(positionX - 10, positionY + 10, mouseX, mouseY);
        }
    }

    public void onClick(int mouseX, int mouseY) {
        if (this.hoverAdvertisement != null) {
            LabyMod.getInstance().openWebpage(this.hoverAdvertisement.getUrl(), true);
        }
        this.dashboardConnector.mouseClicked(mouseX, mouseY, 1);
        if (mouseX < 10 && mouseY > LabyMod.getInstance().getDrawUtils().getHeight() - 10) {
            Debug.openDebugConsole();
        }
        this.latestMinecraftPopupRenderer.onClick(mouseX, mouseY);
    }

    public static SplashLoader getLoader() {
        return loader;
    }

    public SplashEntries getEntries() {
        return this.entries;
    }

    public String getCustomSplashText() {
        return this.customSplashText;
    }
}

