/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings.elements;

import net.labymod.api.LabyModAddon;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ModTextField;
import net.labymod.ingamegui.Module;
import net.labymod.main.LabyMod;
import net.labymod.main.ModSettings;
import net.labymod.settings.elements.ControlElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.ModColor;
import org.lwjgl.input.Keyboard;

public class KeyElement
extends ControlElement {
    private Integer currentKey;
    private boolean allowMouseButtons = true;
    private Consumer<Integer> changeListener;
    private ModTextField textField;
    private Consumer<Integer> callback;

    public KeyElement(String displayName, final String configEntryName, ControlElement.IconData iconData) {
        super(displayName, configEntryName, iconData);
        if (!configEntryName.isEmpty()) {
            try {
                this.currentKey = (Integer)ModSettings.class.getDeclaredField(configEntryName).get(LabyMod.getSettings());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (this.currentKey == null) {
            this.currentKey = -1;
        }
        this.changeListener = new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                try {
                    ModSettings.class.getDeclaredField(configEntryName).set(LabyMod.getSettings(), accepted);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (KeyElement.this.callback != null) {
                    KeyElement.this.callback.accept(accepted);
                }
            }
        };
        this.createTextfield();
    }

    public KeyElement(Module module, ControlElement.IconData iconData, String displayName, String attribute) {
        this(module, iconData, displayName, attribute, false);
    }

    public KeyElement(final Module module, ControlElement.IconData iconData, String displayName, final String attribute, boolean allowMouseButtons) {
        super(module, iconData, displayName);
        this.allowMouseButtons = allowMouseButtons;
        this.currentKey = Integer.valueOf(module.getAttributes().get(attribute));
        if (this.currentKey == null) {
            this.currentKey = -1;
        }
        this.changeListener = new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                module.getAttributes().put(attribute, String.valueOf(accepted));
                module.loadSettings();
                if (KeyElement.this.callback != null) {
                    KeyElement.this.callback.accept(accepted);
                }
            }
        };
        this.createTextfield();
    }

    public KeyElement(String displayName, final LabyModAddon labymodAddon, ControlElement.IconData iconData, final String attributeName, int currentKey, boolean allowMouseButtons) {
        super(displayName, iconData);
        this.allowMouseButtons = allowMouseButtons;
        this.currentKey = currentKey;
        this.changeListener = new Consumer<Integer>(){

            @Override
            public void accept(Integer accepted) {
                labymodAddon.getConfig().addProperty(attributeName, (Number)accepted);
                labymodAddon.loadConfig();
                if (KeyElement.this.callback != null) {
                    KeyElement.this.callback.accept(accepted);
                }
            }
        };
        this.createTextfield();
    }

    public KeyElement(String displayName, LabyModAddon labymodAddon, ControlElement.IconData iconData, String attributeName, int currentKey) {
        this(displayName, labymodAddon, iconData, attributeName, currentKey, false);
    }

    public KeyElement(String displayName, ControlElement.IconData iconData, int currentKey, Consumer<Integer> changeListener) {
        super(displayName, iconData);
        this.currentKey = currentKey;
        this.changeListener = changeListener;
        this.createTextfield();
    }

    public KeyElement(String configEntryName, ControlElement.IconData iconData) {
        this(configEntryName, configEntryName, iconData);
    }

    public void createTextfield() {
        this.textField = new ModTextField(-2, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, this.getObjectWidth() - 5, 20);
        this.updateValue();
        this.textField.setCursorPositionEnd();
        this.textField.setFocused(false);
    }

    private void updateValue() {
        if (this.currentKey == -1) {
            this.textField.setText("NONE");
        } else {
            try {
                this.textField.setText(this.currentKey < 0 ? "Mouse " + (this.currentKey + 100) : Keyboard.getKeyName((int)this.currentKey));
            }
            catch (Exception error) {
                this.currentKey = -1;
                error.printStackTrace();
            }
        }
    }

    @Override
    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY) {
        super.draw(x, y, maxX, maxY, mouseX, mouseY);
        int width = this.getObjectWidth() - 5;
        if (this.textField == null) {
            return;
        }
        this.textField.xPosition = maxX - width - 2;
        this.textField.yPosition = y + 1;
        this.textField.drawTextBox();
        LabyMod.getInstance().getDrawUtils().drawRectangle(x - 1, y, x, maxY, ModColor.toRGB(120, 120, 120, 120));
    }

    @Override
    public void unfocus(int mouseX, int mouseY, int mouseButton) {
        boolean prevFocus = this.textField.isFocused();
        super.unfocus(mouseX, mouseY, mouseButton);
        this.textField.setFocused(false);
        if (prevFocus && this.allowMouseButtons) {
            this.textField.setFocused(false);
            this.currentKey = mouseButton - 100;
            this.changeListener.accept(this.currentKey);
            this.updateValue();
            this.updateScreen();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            this.textField.mouseClicked(mouseX, mouseY, 0);
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (keyCode == 1) {
            keyCode = -1;
        }
        if (this.textField.isFocused()) {
            this.textField.setFocused(false);
            this.currentKey = keyCode;
            this.changeListener.accept(keyCode);
            this.updateValue();
        }
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        this.textField.updateCursorCounter();
    }

    public KeyElement maxLength(int maxLength) {
        this.textField.setMaxStringLength(maxLength);
        return this;
    }

    public KeyElement setAllowMouseButtons(boolean allowMouseButtons) {
        this.allowMouseButtons = allowMouseButtons;
        return this;
    }

    public KeyElement addCallback(Consumer<Integer> callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public int getObjectWidth() {
        return 53;
    }

    public ModTextField getTextField() {
        return this.textField;
    }
}

