/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.labymod.api.LabyModAddon;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.enums.EnumDisplayType;
import net.labymod.ingamegui.enums.EnumModuleAlignment;
import net.labymod.ingamegui.enums.EnumModuleRegion;
import net.labymod.ingamegui.moduletypes.ResizeableModule;
import net.labymod.main.DefaultValues;
import net.labymod.main.LabyMod;
import net.labymod.main.ModSettings;
import net.labymod.servermanager.Server;
import net.labymod.settings.elements.ControlElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.ModColor;

public class BooleanElement
extends ControlElement {
    private boolean currentValue;
    private Consumer<Boolean> toggleListener;
    private avs buttonToggle;
    private String stringEnabled = "ON";
    private String stringDisabled = "OFF";
    private Consumer<Boolean> callback;

    public BooleanElement(String displayName, final String configEntryName, ControlElement.IconData iconData) {
        super(displayName, configEntryName, iconData);
        if (configEntryName != null) {
            if (!configEntryName.isEmpty()) {
                try {
                    this.currentValue = ModSettings.class.getDeclaredField(configEntryName).getBoolean(LabyMod.getSettings());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            this.toggleListener = new Consumer<Boolean>(){

                @Override
                public void accept(Boolean accepted) {
                    try {
                        ModSettings.class.getDeclaredField(configEntryName).set(LabyMod.getSettings(), accepted);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    BooleanElement.this.setSettingEnabled(accepted);
                }
            };
        }
        this.createButton();
    }

    public BooleanElement(String displayName, final Server server, ControlElement.IconData iconData, final String attributeName) {
        super(displayName, null, iconData);
        this.currentValue = server.getConfig().get(attributeName).getAsBoolean();
        this.toggleListener = new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                server.getConfig().addProperty(attributeName, accepted);
                server.saveConfig();
                server.loadConfig();
                BooleanElement.this.setSettingEnabled(accepted);
            }
        };
        this.createButton();
    }

    public BooleanElement(String displayName, final LabyModAddon addon, ControlElement.IconData iconData, final String attributeName, boolean defaultValue) {
        super(displayName, null, iconData);
        this.currentValue = !addon.getConfig().has(attributeName) ? defaultValue : addon.getConfig().get(attributeName).getAsBoolean();
        this.toggleListener = new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                addon.getConfig().addProperty(attributeName, accepted);
                addon.saveConfig();
                addon.loadConfig();
                BooleanElement.this.setSettingEnabled(accepted);
            }
        };
        this.createButton();
    }

    public BooleanElement(String displayName, ControlElement.IconData iconData, Consumer<Boolean> toggleListener, boolean currentValue) {
        super(displayName, null, iconData);
        this.currentValue = currentValue;
        this.toggleListener = toggleListener;
        this.createButton();
    }

    public BooleanElement(final Module module, ControlElement.IconData iconData, String displayName, final String attribute) {
        super(module, iconData, displayName);
        this.currentValue = attribute.equals("enabled") ? module.isEnabled(Module.getLastDrawnDisplayType()) : Boolean.valueOf(module.getAttributes().get(attribute)).booleanValue();
        this.toggleListener = new Consumer<Boolean>(){

            @Override
            public void accept(Boolean accepted) {
                if (attribute.equals("enabled")) {
                    module.init();
                    if (module.getListedAfter() != null) {
                        Module.getModulesByOverlistedModules().remove(module.getListedAfter());
                    }
                    if (Module.getModulesByOverlistedModules().containsKey(module.getName())) {
                        String newListedAfter = module.getListedAfter();
                        Module underlistedModule = Module.getModulesByOverlistedModules().get(module.getName());
                        underlistedModule.setListedAfter(newListedAfter);
                        underlistedModule.getModuleConfigElement().setListedAfter(newListedAfter);
                        Module.getModulesByOverlistedModules().remove(module.getName());
                        if (newListedAfter != null) {
                            Module.getModulesByOverlistedModules().put(newListedAfter, underlistedModule);
                        }
                    }
                    if (module.getListedAfter() != null) {
                        module.setListedAfter(null);
                        module.getModuleConfigElement().setListedAfter(null);
                    }
                    if (accepted.booleanValue()) {
                        if (module instanceof ResizeableModule) {
                            ((ResizeableModule)module).height[Module.getLastDrawnDisplayType().ordinal()] = Math.min(((ResizeableModule)module).height[Module.getLastDrawnDisplayType().ordinal()], Module.getLastBottom() - Module.getLastTop() - 10.0);
                            module.setAttribute("height", ((ResizeableModule)module).getStringByArray(((ResizeableModule)module).height));
                            module.getModuleConfigElement().setAttributes(module.getAttributes());
                        }
                        module.getEnabled().add(Module.getLastDrawnDisplayType());
                        if (Module.getLastDrawnDisplayType() == EnumDisplayType.INGAME) {
                            Module lastListedAfter;
                            boolean attach = true;
                            if (module.getModuleConfigElement().getLastListedAfter() != null && (lastListedAfter = Module.getModuleByName(module.getModuleConfigElement().getLastListedAfter())) != null && lastListedAfter.isEnabled(Module.getLastDrawnDisplayType())) {
                                attach = false;
                                if (Module.getModulesByOverlistedModules().containsKey(lastListedAfter.getName())) {
                                    Module attachedModule = Module.getModulesByOverlistedModules().get(lastListedAfter.getName());
                                    attachedModule.setListedAfter(module.getName());
                                    attachedModule.getModuleConfigElement().setListedAfter(attachedModule.getName());
                                    Module.getModulesByOverlistedModules().put(module.getName(), attachedModule);
                                }
                                Module.getModulesByOverlistedModules().put(lastListedAfter.getName(), module);
                                module.setListedAfter(lastListedAfter.getName());
                                module.getModuleConfigElement().setListedAfter(module.getListedAfter());
                            }
                            if (attach) {
                                boolean attachToTheRight = DefaultValues.ATTACH_MODULES_RIGHT.contains(module.getClass());
                                final int displayTypeOrdinal = Module.getLastDrawnDisplayType().ordinal();
                                ArrayList<Module> possibleModules = new ArrayList<Module>();
                                for (Module modules : Module.getModules()) {
                                    if (modules.equals(module) || !modules.isEnabled(Module.getLastDrawnDisplayType()) || module.getListedAfter() != null || (attachToTheRight || modules.getRegion(displayTypeOrdinal) != EnumModuleRegion.TOP_LEFT) && (!attachToTheRight || modules.getRegion(displayTypeOrdinal) != EnumModuleRegion.TOP_RIGHT)) continue;
                                    possibleModules.add(modules);
                                }
                                Collections.sort(possibleModules, new Comparator<Module>(){

                                    @Override
                                    public int compare(Module o1, Module o2) {
                                        return Double.valueOf(o2.getY(displayTypeOrdinal)).compareTo(o1.getY(displayTypeOrdinal));
                                    }
                                });
                                boolean createNewPosition = true;
                                if (possibleModules.size() != 0) {
                                    Module bottomModule = (Module)possibleModules.get(0);
                                    while (Module.getModulesByOverlistedModules().containsKey(bottomModule.getName())) {
                                        Module target = Module.getModulesByOverlistedModules().get(bottomModule.getName());
                                        if (target == null || !target.isEnabled(Module.getLastDrawnDisplayType())) continue;
                                        bottomModule = target;
                                    }
                                    if (bottomModule != null && bottomModule.isEnabled(Module.getLastDrawnDisplayType())) {
                                        Module.getModulesByOverlistedModules().put(bottomModule.getName(), module);
                                        module.setListedAfter(bottomModule.getName());
                                        module.getModuleConfigElement().setListedAfter(module.getListedAfter());
                                        createNewPosition = false;
                                    }
                                }
                                if (createNewPosition) {
                                    module.setRegion(displayTypeOrdinal, attachToTheRight ? EnumModuleRegion.TOP_RIGHT : EnumModuleRegion.TOP_LEFT);
                                    module.getModuleConfigElement().setAlignment(displayTypeOrdinal, EnumModuleAlignment.AUTO);
                                    module.setX(displayTypeOrdinal, module.getRegion(displayTypeOrdinal).getOffsetX(attachToTheRight ? LabyMod.getInstance().getDrawUtils().getWidth() - 3 : 3, 0.0, LabyMod.getInstance().getDrawUtils().getWidth()));
                                    module.setY(displayTypeOrdinal, module.getRegion(displayTypeOrdinal).getOffsetY(3.0, 0.0, LabyMod.getInstance().getDrawUtils().getHeight()));
                                    module.getModuleConfigElement().setX(displayTypeOrdinal, module.getX(displayTypeOrdinal));
                                    module.getModuleConfigElement().setY(displayTypeOrdinal, module.getY(displayTypeOrdinal));
                                }
                            }
                        }
                    } else {
                        module.getModuleConfigElement().setLastListedAfter(module.getListedAfter());
                        module.getEnabled().remove((Object)Module.getLastDrawnDisplayType());
                    }
                    module.getModuleConfigElement().setEnabled(module.getEnabled());
                } else {
                    module.getAttributes().put(attribute, String.valueOf(accepted));
                    module.loadSettings();
                }
                if (BooleanElement.this.callback != null) {
                    BooleanElement.this.callback.accept(accepted);
                }
                BooleanElement.this.setSettingEnabled(accepted);
                module.settingUpdated(accepted);
            }
        };
        this.createButton();
    }

    public BooleanElement(String configEntryName, ControlElement.IconData iconData) {
        this(configEntryName, configEntryName, iconData);
    }

    public void createButton() {
        this.buttonToggle = new avs(-2, 0, 0, 0, 20, "");
        this.setSettingEnabled(this.currentValue);
    }

    @Override
    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY) {
        super.draw(x, y, maxX, maxY, mouseX, mouseY);
        int width = this.getObjectWidth();
        if (this.buttonToggle == null) {
            return;
        }
        this.buttonToggle.l = false;
        LabyModCore.getMinecraft().setButtonXPosition(this.buttonToggle, maxX - width - 2);
        LabyModCore.getMinecraft().setButtonYPosition(this.buttonToggle, y + 1);
        this.buttonToggle.a(width);
        LabyModCore.getMinecraft().drawButton(this.buttonToggle, mouseX, mouseY);
        this.buttonToggle.l = true;
        int buttonWidth = this.buttonToggle.b();
        int valueXPos = this.currentValue ? (buttonWidth - 4) / 2 : (buttonWidth - 4) / 2 + 6;
        String displayString = (Object)((Object)(this.buttonToggle.a() ? ModColor.YELLOW : (this.currentValue ? ModColor.WHITE : ModColor.GRAY))) + (this.currentValue ? this.stringEnabled : this.stringDisabled);
        LabyMod.getInstance().getDrawUtils().drawCenteredString(displayString, LabyModCore.getMinecraft().getXPosition(this.buttonToggle) + valueXPos, LabyModCore.getMinecraft().getYPosition(this.buttonToggle) + 6);
        LabyMod.getInstance().getDrawUtils().drawString(this.currentValue ? ModColor.GREEN.toString() : ModColor.RED.toString(), 0.0, 0.0);
        this.mc.P().a(buttonTextures);
        int pos = (this.currentValue ? maxX - 8 : maxX - width) - 2;
        LabyMod.getInstance().getDrawUtils().b(pos, y + 1, 0, 66, 4, 20);
        LabyMod.getInstance().getDrawUtils().b(pos + 4, y + 1, 196, 66, 4, 20);
        LabyMod.getInstance().getDrawUtils().drawRectangle(x - 1, y, x, maxY, this.currentValue ? ModColor.toRGB(20, 120, 20, 120) : ModColor.toRGB(120, 20, 20, 120));
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.buttonToggle.c(ave.A(), mouseX, mouseY)) {
            boolean bl = this.currentValue = !this.currentValue;
            if (this.toggleListener != null) {
                this.toggleListener.accept(this.currentValue);
            }
            if (this.callback != null) {
                this.callback.accept(this.currentValue);
            }
            this.buttonToggle.a(this.mc.W());
        }
    }

    public BooleanElement custom(String ... args) {
        if (args.length >= 1) {
            this.stringEnabled = args[0];
        }
        if (args.length >= 2) {
            this.stringDisabled = args[1];
        }
        return this;
    }

    public BooleanElement addCallback(Consumer<Boolean> callback) {
        this.callback = callback;
        return this;
    }

    public boolean getCurrentValue() {
        return this.currentValue;
    }
}

