/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.settings.elements;

import java.util.ArrayList;
import java.util.List;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.online.info.AddonInfo;
import net.labymod.addon.online.info.OnlineAddonInfo;
import net.labymod.api.LabyModAddon;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.manager.TooltipHelper;

public class AddonElement {
    private List<SettingsElement> subSettings = new ArrayList<SettingsElement>();
    private AddonInfo addonInfo;
    private LabyModAddon installedAddon;
    private Consumer<AddonInfo.AddonActionState> callbackAction;
    private AddonInfo.AddonActionState lastActionState;
    private boolean mouseOver = false;
    private int hoverButtonId = -1;
    private boolean canHover = false;
    private double installProgress;

    public AddonElement(AddonInfo addonInfo, Consumer<AddonInfo.AddonActionState> callbackAction) {
        this.addonInfo = addonInfo;
        this.callbackAction = callbackAction;
    }

    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY) {
        this.draw(x, y, maxX, maxY, mouseX, mouseY, true);
    }

    public void draw(int x, int y, int maxX, int maxY, int mouseX, int mouseY, boolean showSettingsButton) {
        int marginY;
        int marginX;
        boolean hoverVerified;
        this.mouseOver = mouseX > x && mouseX < maxX && mouseY > y && mouseY < maxY && this.canHover;
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int iconWidth = this.getEntryHeight();
        int textLineY = y + 3;
        if (this.lastActionState == AddonInfo.AddonActionState.ERROR) {
            draw.drawRectangle(x, y, maxX, maxY, ModColor.toRGB(100, 50, 50, this.isMouseOver() ? 90 : 70));
        } else if (this.lastActionState == AddonInfo.AddonActionState.UNINSTALL || this.lastActionState == AddonInfo.AddonActionState.INSTALL && this.installProgress >= 100.0) {
            draw.drawRectangle(x, y, maxX, maxY, ModColor.toRGB(50, 50, 100, this.isMouseOver() ? 90 : 70));
        } else if (this.lastActionState == AddonInfo.AddonActionState.INSTALL) {
            double totalWidth = maxX - x - iconWidth;
            double progressbarWidth = totalWidth / 100.0 * this.installProgress;
            draw.drawRect(x + iconWidth, y, (double)(x + iconWidth) + progressbarWidth, maxY, ModColor.toRGB(50, 100, 50, this.isMouseOver() ? 90 : 70));
            draw.drawRect((double)(x + iconWidth) + totalWidth, y, (double)(x + iconWidth) + progressbarWidth, maxY, ModColor.toRGB(50, this.isAddonInstalled() ? 100 : 50, 50, this.isMouseOver() ? 90 : 70));
        } else {
            draw.drawRectangle(x, y, maxX, maxY, ModColor.toRGB(50, this.isAddonInstalled() ? 100 : 50, 50, this.isMouseOver() ? 90 : 70));
        }
        this.drawIcon(x, y, iconWidth, this.getEntryHeight());
        boolean verified = this.addonInfo instanceof OnlineAddonInfo && ((OnlineAddonInfo)this.addonInfo).isVerified();
        String titleString = ModColor.cl(this.isAddonInstalled() ? "a" : (verified ? "e" : "f")) + ModColor.cl("l") + ModColor.createColors(this.addonInfo.getName());
        draw.drawString(titleString, x + iconWidth + 5, textLineY);
        textLineY += 15;
        int vX = x + iconWidth + 5 + draw.getStringWidth(titleString) + 3;
        int vY = y + 3;
        boolean bl = hoverVerified = mouseX > vX && mouseX < vX + 8 && mouseY > vY && mouseY < vY + 8;
        if (verified) {
            ave.A().P().a(ModTextures.MISC_FEATURED);
            draw.drawTexture(vX, vY, 0.0, 0.0, 255.0, 255.0, 8.0, 8.0);
            if (hoverVerified) {
                TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, ModColor.cl("e") + "Featured");
            }
        }
        draw.drawString(ModColor.cl("a") + "by " + this.addonInfo.getAuthor(), x + iconWidth + 5, y + 12, 0.5);
        List<String> descriptionLines = draw.listFormattedStringToWidth(ModColor.createColors(this.addonInfo.getDescription()), (int)((double)(maxX - x - iconWidth - 60) / 0.7));
        int lineCount = 0;
        for (String descriptionLine : descriptionLines) {
            if (lineCount >= 3) {
                descriptionLine = descriptionLine + "...";
            }
            draw.drawString(ModColor.cl("7") + descriptionLine, x + iconWidth + 5, textLineY, 0.7);
            textLineY = (int)((double)textLineY + 7.0);
            if (++lineCount < 3) continue;
            break;
        }
        this.hoverButtonId = -1;
        if (this.lastActionState == AddonInfo.AddonActionState.INSTALL_REVOKE && this.drawButton(ModTextures.BUTTON_DOWNLOAD, y, 14, 2, marginX = 10, marginY = (maxY - y - 14) / 2, maxX, maxY, mouseX, mouseY)) {
            this.hoverButtonId = 0;
        }
        if (this.lastActionState == AddonInfo.AddonActionState.UNINSTALL_REVOKE) {
            marginX = 10;
            marginY = (maxY - y - 14) / 2;
            if (this.drawButton(ModTextures.BUTTON_TRASH, y, 14, 6, marginX, marginY, maxX, maxY, mouseX, mouseY)) {
                this.hoverButtonId = 1;
            }
            marginX = 30;
            if (showSettingsButton && !this.subSettings.isEmpty() && this.drawButton(ModTextures.BUTTON_ADDON_SETTINGS, y, 14, 6, marginX, marginY, maxX, maxY, mouseX, mouseY)) {
                this.hoverButtonId = 2;
            }
        }
        if (this.lastActionState == AddonInfo.AddonActionState.UNINSTALL) {
            marginX = 10;
            marginY = (maxY - y - 14) / 2;
            if (this.drawButton(ModTextures.BUTTON_UNDO, y, 14, 2, marginX, marginY, maxX, maxY, mouseX, mouseY)) {
                this.hoverButtonId = 3;
            }
            draw.drawRightString(ModColor.cl("4") + "Restart required to uninstall", maxX - 2, y + 2, 0.75);
        }
        if (this.lastActionState == AddonInfo.AddonActionState.INSTALL) {
            if (this.installProgress >= 100.0) {
                draw.drawRightString(ModColor.cl("4") + "Restart required to install", maxX - 2, y + 2, 0.75);
                marginX = 10;
                marginY = (maxY - y - 14) / 2;
                if (this.drawButton(ModTextures.BUTTON_UNDO, y, 14, 2, marginX, marginY, maxX, maxY, mouseX, mouseY)) {
                    this.hoverButtonId = 4;
                }
            } else {
                draw.drawRightString((double)((int)(this.installProgress * 10.0)) / 10.0 + "%", maxX - 10, y + (maxY - y - 8) / 2);
            }
        }
        if (this.isMouseOver() && !hoverVerified && this.hoverButtonId == -1) {
            String[] array = new String[descriptionLines.size()];
            descriptionLines.toArray(array);
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, array);
        }
        if (this.lastActionState == AddonInfo.AddonActionState.ERROR) {
            draw.drawRightString(ModColor.cl("4") + "ERROR", maxX - 10, y + (maxY - y - 8) / 2);
        }
        if (this.isMouseOver()) {
            switch (this.hoverButtonId) {
                case 0: {
                    TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, "Install");
                    break;
                }
                case 1: {
                    TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, "Uninstall");
                    break;
                }
                case 2: {
                    TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, "Settings");
                    break;
                }
                case 3: {
                    TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, "Enable again");
                    break;
                }
                case 4: {
                    TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, 0L, "Delete again");
                }
            }
        }
    }

    private boolean drawButton(jy resourceLocation, int y, int buttonSize, int buttonPadding, int marginX, int marginY, int maxX, int maxY, int mouseX, int mouseY) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        boolean hover = mouseX > maxX - buttonSize - marginX + 1 && mouseX < maxX - buttonSize + buttonSize - marginX + 1 && mouseY > y + marginY + 1 && mouseY < y + buttonSize + marginY + 1;
        int colorA = hover ? ModColor.toRGB(10, 10, 10, 255) : ModColor.toRGB(220, 220, 220, 255);
        int colorB = hover ? ModColor.toRGB(150, 150, 150, 255) : ModColor.toRGB(0, 0, 0, 255);
        int colorC = hover ? ModColor.toRGB(150, 150, 150, 255) : ModColor.toRGB(180, 180, 180, 255);
        draw.drawRectangle(maxX - buttonSize - (marginX += hover ? 1 : 0), y + marginY, maxX - buttonSize + buttonSize - marginX, y + buttonSize + marginY, colorA);
        draw.drawRectangle(maxX - buttonSize - marginX + 1, y + marginY + 1, maxX - buttonSize + buttonSize - marginX + 1, y + buttonSize + marginY + 1, colorB);
        draw.drawRectangle(maxX - buttonSize - marginX + 1, y + marginY + 1, maxX - buttonSize + buttonSize - marginX, y + buttonSize + marginY, colorC);
        ave.A().P().a(resourceLocation);
        draw.drawTexture(maxX - buttonSize - marginX + buttonPadding / 2 + (hover ? 1 : 0), y + marginY + buttonPadding / 2 + (hover ? 1 : 0), 256.0, 256.0, buttonSize - buttonPadding, buttonSize - buttonPadding, 0.8f);
        return hover;
    }

    public void drawIcon(int x, int y, int width, int height) {
        if (this.addonInfo.getImageURL() == null) {
            ave.A().P().a(ModTextures.MISC_HEAD_QUESTION);
            LabyMod.getInstance().getDrawUtils().drawTexture(x, y, 256.0, 256.0, width, height);
        } else {
            LabyMod.getInstance().getDrawUtils().drawImageUrl(this.addonInfo.getImageURL(), x, y, 256.0, 256.0, width, height);
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        switch (this.hoverButtonId) {
            case 0: {
                this.callbackAction.accept(AddonInfo.AddonActionState.INSTALL);
                break;
            }
            case 1: {
                this.callbackAction.accept(AddonInfo.AddonActionState.UNINSTALL);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.callbackAction.accept(AddonInfo.AddonActionState.UNINSTALL_REVOKE);
                break;
            }
            case 4: {
                this.callbackAction.accept(AddonInfo.AddonActionState.INSTALL_REVOKE);
            }
        }
    }

    public int getEntryHeight() {
        return 40;
    }

    public void mouseRelease(int mouseX, int mouseY, int mouseButton) {
    }

    public boolean isHoverSubSettingsButton() {
        return this.hoverButtonId == 2;
    }

    public boolean isAddonInstalled() {
        return this.installedAddon != null;
    }

    public AddonElement canHover(boolean flag) {
        this.canHover = flag;
        return this;
    }

    public void onMouseClickedPreview(int mouseX, int mouseY, int mouseButton) {
        LabyModAddon loadedAddon;
        if (this.addonInfo != null && (loadedAddon = AddonLoader.getInstalledAddonByInfo(this.addonInfo)) != null) {
            loadedAddon.onMouseClickedPreview(mouseX, mouseY, mouseButton);
        }
    }

    public void onRenderPreview(int mouseX, int mouseY, float partialTicks) {
        LabyModAddon loadedAddon;
        if (this.addonInfo != null && (loadedAddon = AddonLoader.getInstalledAddonByInfo(this.addonInfo)) != null) {
            loadedAddon.onRenderPreview(mouseX, mouseY, partialTicks);
        }
    }

    public LabyModAddon getInstalledAddon() {
        return this.installedAddon;
    }

    public Consumer<AddonInfo.AddonActionState> getCallbackAction() {
        return this.callbackAction;
    }

    public AddonInfo.AddonActionState getLastActionState() {
        return this.lastActionState;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public int getHoverButtonId() {
        return this.hoverButtonId;
    }

    public boolean isCanHover() {
        return this.canHover;
    }

    public double getInstallProgress() {
        return this.installProgress;
    }

    public List<SettingsElement> getSubSettings() {
        return this.subSettings;
    }

    public AddonInfo getAddonInfo() {
        return this.addonInfo;
    }

    public void setInstalledAddon(LabyModAddon installedAddon) {
        this.installedAddon = installedAddon;
    }

    public void setLastActionState(AddonInfo.AddonActionState lastActionState) {
        this.lastActionState = lastActionState;
    }

    public void setCanHover(boolean canHover) {
        this.canHover = canHover;
    }

    public void setInstallProgress(double installProgress) {
        this.installProgress = installProgress;
    }
}

