/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.servermanager;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.labymod.main.LabyMod;
import net.labymod.servermanager.group.ServerGroup;
import net.labymod.utils.ServerData;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;

public class ServerGroupProvider {
    private static final Type GROUP_MAP_TYPE = new TypeToken<Map<String, ServerGroup>>(){}.getType();
    private final Gson gson = new Gson();
    private final Map<String, ServerGroup> availableGroups = new HashMap<String, ServerGroup>();

    public ServerGroupProvider() {
        this.loadGroups();
    }

    private void loadGroups() {
        DownloadServerRequest.getJsonObjectAsync("https://dl.labymod.net/server_groups.json", new ServerResponse<JsonElement>(){

            @Override
            public void success(JsonElement result) {
                JsonObject obj = result.getAsJsonObject();
                Map groups = (Map)ServerGroupProvider.this.gson.fromJson(obj.get("server_groups"), GROUP_MAP_TYPE);
                if (groups != null) {
                    ServerGroupProvider.this.availableGroups.putAll(groups);
                }
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
                ServerGroupProvider.this.availableGroups.clear();
            }
        });
    }

    public ServerGroup detectGroup() {
        return this.detectGroup(LabyMod.getInstance().getCurrentServerData());
    }

    public ServerGroup detectGroup(ServerData data) {
        if (data == null) {
            return null;
        }
        for (ServerGroup group : this.availableGroups.values()) {
            if (!group.matches(data)) continue;
            return group;
        }
        return null;
    }
}

