/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.serverapi.common.widgets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.labymod.serverapi.common.widgets.WidgetLayout;
import net.labymod.serverapi.common.widgets.components.Widget;
import net.labymod.serverapi.common.widgets.util.EnumScreenAction;
import net.labymod.serverapi.common.widgets.util.EnumWidget;

public class WidgetScreen {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Widget.class, (src, typeOfSrc, context) -> {
        JsonObject object = new JsonObject();
        object.addProperty("type", (Number)EnumWidget.getTypeOf(src.getClass()).ordinal());
        object.add("attributes", context.serialize(src));
        return object;
    }).registerTypeAdapter(Widget.class, (json, typeOfSrc, context) -> {
        JsonObject obj = json.getAsJsonObject();
        int id = obj.get("type").getAsInt();
        JsonObject attributes = obj.get("attributes").getAsJsonObject();
        return (Widget)context.deserialize((JsonElement)attributes, EnumWidget.values()[id].getClazz());
    }).create();
    private final int id;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private WidgetLayout layout = null;

    public WidgetScreen(int id) {
        this.id = id;
    }

    public void setLayout(WidgetLayout widgetLayout) {
        this.layout = widgetLayout;
    }

    public void addWidget(Widget widget) {
        this.widgets.add(widget);
    }

    public WidgetLayout getLayout() {
        return this.layout;
    }

    public JsonObject toJsonObject(EnumScreenAction action) {
        JsonObject object = GSON.toJsonTree((Object)this).getAsJsonObject();
        object.addProperty("action", (Number)action.ordinal());
        return object;
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public int getId() {
        return this.id;
    }

    public static WidgetScreen from(JsonObject object) {
        return (WidgetScreen)GSON.fromJson((JsonElement)object, WidgetScreen.class);
    }
}

