/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.mojang.settings;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.labymod.mojang.settings.KeyBindMappings;
import net.labymod.mojang.settings.OptionsPrintWriter;

public class OptionsRemapper {
    public static final OptionsRemapper INSTANCE = new OptionsRemapper();
    private File optionsFile = null;
    private final Map<String, String> configurations = new HashMap<String, String>();

    public void init() {
        this.optionsFile = new File(ave.A().v, "options.txt");
        this.read();
        if (this.remap()) {
            try {
                FileWriter fileWriter = new FileWriter(this.optionsFile);
                for (Map.Entry<String, String> entry : this.configurations.entrySet()) {
                    fileWriter.write(entry.getKey() + ":" + entry.getValue() + "\n");
                }
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void write(PrintWriter printWriter) {
        if (printWriter instanceof OptionsPrintWriter) {
            ((OptionsPrintWriter)printWriter).write(this.configurations);
        }
    }

    private void read() {
        try {
            Scanner scanner = new Scanner(this.optionsFile);
            while (scanner.hasNextLine()) {
                String[] parts = scanner.nextLine().split(":");
                if (parts.length != 2) continue;
                this.configurations.put(parts[0], parts[1]);
            }
            scanner.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean remap() {
        boolean optionChanged = false;
        for (Map.Entry<String, String> entry : this.configurations.entrySet()) {
            int key;
            if (!entry.getKey().startsWith("key") || (key = KeyBindMappings.getScanCode(entry.getValue())) == -1) continue;
            this.configurations.put(entry.getKey(), String.valueOf(key));
            optionChanged = true;
        }
        return optionChanged;
    }
}

