/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main.update;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.labymod.main.Source;
import net.labymod.main.update.UpdateData;
import net.labymod.main.update.migration.LatestMinecraftVersion;
import net.labymod.support.util.Debug;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;

public class LabyModUpdateChecker {
    public static final short[] CLIENT_VERSION = UpdateData.getShortVersionOfString("3.9.62");
    private static final JsonParser JSON_PARSER = new JsonParser();
    private LatestMinecraftVersion latestMinecraftVersion = null;

    public CompletableFuture<UpdateData> getUpdateData() {
        final CompletableFuture<UpdateData> future = new CompletableFuture<UpdateData>();
        DownloadServerRequest.getStringAsync("https://dl.labymod.net/versions.json", new ServerResponse<String>(){

            @Override
            public void success(String json) {
                JsonObject jsonObject = JSON_PARSER.parse(json).getAsJsonObject();
                try {
                    LabyModUpdateChecker.this.latestMinecraftVersion = LatestMinecraftVersion.from(jsonObject);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String newVersionString = LabyModUpdateChecker.getLatestVersion(jsonObject);
                if (newVersionString != null) {
                    short[] latestVersion = UpdateData.getShortVersionOfString(newVersionString);
                    UpdateData data = new UpdateData(newVersionString, latestVersion, LabyModUpdateChecker.this.isOutdated(latestVersion));
                    future.complete(data);
                } else {
                    Debug.log(Debug.EnumDebugMode.UPDATER, "Minecraft " + Source.ABOUT_MC_VERSION + " has no valid version entry");
                }
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
                Debug.log(Debug.EnumDebugMode.UPDATER, "Error while checking latest labymod version info: " + exception.getMessage());
            }
        });
        return future;
    }

    private static String getLatestVersion(JsonObject jsonObject) {
        HashMap<String, String> mcVerToLMVerMap = new HashMap<String, String>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String mcVersion = (String)entry.getKey();
            JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
            JsonElement versionElement = object.get("version");
            if (versionElement == null || mcVersion == null) continue;
            mcVerToLMVerMap.put(mcVersion, versionElement.getAsString());
        }
        return (String)mcVerToLMVerMap.get(Source.ABOUT_MC_VERSION);
    }

    private boolean isOutdated(short[] latestVersion) {
        if (latestVersion == null) {
            return false;
        }
        return LabyModUpdateChecker.isClientOutdated(CLIENT_VERSION, latestVersion);
    }

    public static boolean isClientOutdated(short[] clientVersion, short[] latestVersion) {
        short latestVersionMajor = latestVersion[0];
        short latestVersionMinor = latestVersion.length > 1 ? latestVersion[1] : (short)0;
        short latestVersionPatch = latestVersion.length > 2 ? latestVersion[2] : (short)0;
        short clientVersionMajor = clientVersion[0];
        short clientVersionMinor = clientVersion[1];
        short clientVersionPatch = clientVersion[2];
        return latestVersionMajor > clientVersionMajor || latestVersionMajor == clientVersionMajor && latestVersionMinor > clientVersionMinor || latestVersionMajor == clientVersionMajor && latestVersionMinor == clientVersionMinor && latestVersionPatch > clientVersionPatch;
    }

    public LatestMinecraftVersion getLatestMinecraftVersion() {
        return this.latestMinecraftVersion;
    }
}

