/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.main;

import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.labymod.accountmanager.AsyncAccountManager;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.credentials.CredentialsAccessor;
import net.labymod.addon.AddonLoader;
import net.labymod.api.EventManager;
import net.labymod.api.LabyModAPI;
import net.labymod.api.permissions.Permissions;
import net.labymod.api.permissions.PermissionsListener;
import net.labymod.api.protocol.chunk.ChunkCachingProtocol;
import net.labymod.api.protocol.cinematic.CinematicProtocol;
import net.labymod.api.protocol.screen.ScreenProtocol;
import net.labymod.api.protocol.shadow.ShadowProtocol;
import net.labymod.core.CoreAdapter;
import net.labymod.core.LabyModCore;
import net.labymod.discordapp.DiscordApp;
import net.labymod.ingamechat.tools.ChatToolManager;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.labyconnect.ClientConnection;
import net.labymod.labyconnect.LabyConnect;
import net.labymod.labyconnect.PinManager;
import net.labymod.labyplay.LabyPlay;
import net.labymod.main.LabyModForge;
import net.labymod.main.Log4JJNDIFix;
import net.labymod.main.ModSettings;
import net.labymod.main.ModTextures;
import net.labymod.main.Source;
import net.labymod.main.lang.LanguageManager;
import net.labymod.main.listeners.AddonRecommendationListener;
import net.labymod.main.listeners.CapeReportCommand;
import net.labymod.main.listeners.ClientTickListener;
import net.labymod.main.listeners.FOVUpdateListener;
import net.labymod.main.listeners.GuiOpenListener;
import net.labymod.main.listeners.InputPromptListener;
import net.labymod.main.listeners.PluginMessageListener;
import net.labymod.main.listeners.RenderIngamePostOverlayListener;
import net.labymod.main.listeners.RenderIngamePreOverlayListener;
import net.labymod.main.listeners.RenderTickListener;
import net.labymod.main.listeners.ServerSwitchListener;
import net.labymod.main.update.Updater;
import net.labymod.mojang.afec.EntityCulling;
import net.labymod.servermanager.ServerGroupProvider;
import net.labymod.servermanager.ServerManager;
import net.labymod.support.util.Debug;
import net.labymod.user.UserManager;
import net.labymod.user.cosmetic.util.SneakingAnimationThread;
import net.labymod.user.emote.EmoteRegistry;
import net.labymod.user.sticker.StickerRegistry;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.GuiCustomAchievement;
import net.labymod.utils.LauncherDirectoryUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModTextureUtils;
import net.labymod.utils.ModUtils;
import net.labymod.utils.ServerData;
import net.labymod.utils.credentials.CredentialsStorages;
import net.labymod.utils.manager.ConfigManager;
import net.labymod.utils.manager.LavaLightUpdater;
import net.labymod.utils.manager.MarkerManager;
import net.labymod.utils.manager.TagManager;
import net.labymod.utils.manager.TooltipHelper;
import net.labymod.utils.texture.DynamicTextureManager;
import net.labymod.utils.texture.async.AsyncTextureLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.opengl.KHRDebugCallback;

@Mod(modid="labymod", name="LabyMod", version="3.9.62", acceptedMinecraftVersions="[1.8.9]")
public class LabyMod {
    private static LabyMod instance;
    private static Random random;
    private Updater updater = new Updater();
    private static ConfigManager<ModSettings> mainConfig;
    private DynamicTextureManager dynamicTextureManager = new DynamicTextureManager("labymod", ModTextures.MISC_HEAD_QUESTION);
    private DrawUtils drawUtils;
    private UserManager userManager;
    private CinematicProtocol cinematicProtocol;
    private ChunkCachingProtocol chunkCachingProtocol;
    private ShadowProtocol shadowProtocol;
    private ScreenProtocol screenProtocol;
    private Field channelField;
    private final ServerGroupProvider serverGroupProvider = new ServerGroupProvider();
    private AsyncAccountManager accountManager;
    private SneakingAnimationThread sneakingAnimationThread;
    private boolean hasLeftHand;
    private GuiCustomAchievement guiCustomAchievement;
    private EventManager eventManager;
    private LabyModAPI labyModAPI;
    private ServerManager serverManager;
    private ServerData currentServerData;
    private ClientTickListener clientTickListener;
    private RenderTickListener renderTickListener;
    private GuiOpenListener guiOpenListener;
    private RenderIngamePostOverlayListener priorityOverlayRenderer;
    private MarkerManager markerManager;
    private AsyncTextureLoader asyncTextureLoader;
    private float partialTicks;
    private EmoteRegistry emoteRegistry = new EmoteRegistry();
    private StickerRegistry stickerRegistry = new StickerRegistry();
    private DiscordApp discordApp;
    private ChatToolManager chatToolManager;
    private LabyConnect labyConnect;
    private LabyPlay labyPlay;
    protected GameProfile gameProfile = null;
    protected String playerId = null;
    private boolean serverHasEmoteSpamProtection = false;
    private Map<UUID, bdc> playerListDataCache = new HashMap<UUID, bdc>();
    private boolean playerListCacheEnabled = true;
    private final PinManager pinManager = PinManager.load();

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Debug.init();
        Log4JJNDIFix.fix();
        instance = this;
        this.hasLeftHand = !Source.ABOUT_MC_VERSION.startsWith("1.8");
        this.labyModAPI = new LabyModAPI(this);
        this.eventManager = new EventManager();
        this.updater.addShutdownHook();
        String version = "mc" + Source.getMajorVersion();
        String coreImplementationPackage = "net.labymod.core_implementation." + version;
        try {
            LabyModCore.setCoreAdapter((CoreAdapter)Class.forName(coreImplementationPackage + ".CoreImplementation").newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.drawUtils = new DrawUtils();
        this.guiCustomAchievement = new GuiCustomAchievement(ave.A());
        mainConfig = new ConfigManager<ModSettings>(Source.FILE_CONFIG, ModSettings.class);
        ModuleConfig.loadConfig(null, false);
        LanguageManager.updateLang();
        this.userManager = new UserManager();
        this.userManager.init(this.getPlayerUUID(), new Consumer<Boolean>(){

            @Override
            public void accept(Boolean success) {
                if (success.booleanValue()) {
                    Debug.log(Debug.EnumDebugMode.USER_MANAGER, "Successfully loaded all userdata");
                } else {
                    Debug.log(Debug.EnumDebugMode.USER_MANAGER, "An error occurred while loading all userdata");
                }
            }
        });
        this.chatToolManager = new ChatToolManager();
        this.chatToolManager.initTools();
        this.asyncTextureLoader = new AsyncTextureLoader();
        TagManager.init();
        File accountsFile = Source.FILE_ACCOUNTS;
        CredentialsAccessor credentialsAccessor = CredentialsStorages.createAccessorForOS();
        this.accountManager = new AsyncAccountManager(accountsFile, credentialsAccessor, LauncherDirectoryUtils.getWorkingDirectory());
        this.accountManager.loadAsync(() -> {
            this.accountManager.refreshExternalSessions();
            try {
                this.accountManager.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.eventManager.register(new PluginMessageListener());
        this.eventManager.register(new PermissionsListener());
        RenderIngamePreOverlayListener renderGameOverlay = new RenderIngamePreOverlayListener();
        this.labyModAPI.getEventManager().register(renderGameOverlay);
        this.priorityOverlayRenderer = new RenderIngamePostOverlayListener();
        this.eventManager.register(this.priorityOverlayRenderer);
        this.labyModAPI.getEventManager().register(this.priorityOverlayRenderer);
        MinecraftForge.EVENT_BUS.register(this);
        this.guiOpenListener = new GuiOpenListener();
        MinecraftForge.EVENT_BUS.register(this.guiOpenListener);
        this.renderTickListener = new RenderTickListener();
        MinecraftForge.EVENT_BUS.register(this.renderTickListener);
        MinecraftForge.EVENT_BUS.register(new FOVUpdateListener());
        this.clientTickListener = new ClientTickListener();
        MinecraftForge.EVENT_BUS.register(this.clientTickListener);
        MinecraftForge.EVENT_BUS.register(new TooltipHelper());
        this.serverManager = new ServerManager();
        MinecraftForge.EVENT_BUS.register(this.serverManager);
        this.serverManager.init();
        MinecraftForge.EVENT_BUS.register(this.emoteRegistry);
        this.emoteRegistry.init();
        this.stickerRegistry.init();
        this.markerManager = new MarkerManager();
        this.labyConnect = new LabyConnect();
        this.labyPlay = new LabyPlay();
        AddonLoader.enableAddons(this.labyModAPI);
        this.updater.checkUpdate();
        LavaLightUpdater.update();
        File serverResourcePacks = new File("server-resource-packs");
        if (!serverResourcePacks.exists()) {
            serverResourcePacks.mkdir();
        }
        this.labyModAPI.getEventManager().register(new CapeReportCommand());
        ServerSwitchListener serverSwitch = new ServerSwitchListener(this);
        this.labyModAPI.getEventManager().register(serverSwitch);
        this.labyModAPI.getEventManager().register(serverSwitch);
        this.labyModAPI.getEventManager().registerOnJoin(serverSwitch);
        AddonRecommendationListener addonRecommendation = new AddonRecommendationListener(this);
        this.labyModAPI.getEventManager().registerOnJoin(addonRecommendation);
        this.labyModAPI.getEventManager().register(addonRecommendation);
        this.labyModAPI.getEventManager().register(new InputPromptListener(this));
        this.chunkCachingProtocol = new ChunkCachingProtocol();
        this.shadowProtocol = new ShadowProtocol();
        this.cinematicProtocol = new CinematicProtocol();
        this.screenProtocol = new ScreenProtocol();
        this.discordApp = new DiscordApp();
        if (LabyMod.getSettings().discordRichPresence) {
            this.discordApp.initialize();
        }
        LabyModCore.getMinecraft().init(this);
        try {
            this.channelField = ReflectionHelper.findField(ek.class, LabyModCore.getMappingAdapter().getChannelMappings());
            this.channelField.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dynamicTextureManager.init();
        String debugOpenGL = System.getProperty("debugOpenGL");
        if (debugOpenGL != null && debugOpenGL.endsWith("true")) {
            ave.A().a(new Runnable(){

                @Override
                public void run() {
                    GL11.glEnable((int)37600);
                    GL11.glEnable((int)33346);
                    KHRDebugCallback.Handler handler = new KHRDebugCallback.Handler(){

                        public void handleMessage(int type, int id, int severity, int length, String message) {
                            Debug.log(Debug.EnumDebugMode.MINECRAFT, "OpenGL Error: " + type + " " + id + " " + message);
                            new Throwable().printStackTrace();
                        }
                    };
                    KHRDebug.glDebugMessageCallback((KHRDebugCallback)new KHRDebugCallback(handler));
                    Debug.log(Debug.EnumDebugMode.LABYMOD_CHAT, "Enabled OpenGL debugging");
                }
            });
        }
    }

    public String getPlayerName() {
        return ave.A().L().c();
    }

    public UUID getPlayerUUID() {
        avm session = ave.A().L();
        if (session.b() == null) {
            return session.e().getId();
        }
        if (this.playerId != null && this.gameProfile != null && session.b().equals(this.playerId)) {
            return this.gameProfile.getId();
        }
        this.playerId = session.b();
        this.gameProfile = session.e();
        return this.gameProfile.getId();
    }

    public boolean isInGame() {
        return LabyModCore.getMinecraft().getPlayer() != null && LabyModCore.getMinecraft().getWorld() != null;
    }

    public static ModSettings getSettings() {
        return mainConfig == null ? null : mainConfig.getSettings();
    }

    public void displayMessageInChat(String message) {
        LabyModCore.getMinecraft().displayMessageInChat(message);
    }

    public static boolean isBlocking(wn player) {
        return LabyModCore.getMinecraft().isBlocking(player);
    }

    public void notifyMessageProfile(GameProfile gameProfile, String message) {
        switch (this.labyConnect.getAlertDisplayType()) {
            case CHAT: {
                List<String> list = ModUtils.extractUrls(message);
                if (list.isEmpty()) {
                    LabyMod.getInstance().displayMessageInChat(ModColor.cl("7") + gameProfile.getName() + ModColor.cl("f") + ": " + message);
                    break;
                }
                LabyModCore.getMinecraft().displayMessageInChatURL(ModColor.cl("7") + gameProfile.getName() + ModColor.cl("f") + ": " + message, list.get(0));
                break;
            }
            case ACHIEVEMENT: {
                LabyMod.getInstance().getGuiCustomAchievement().displayAchievement(gameProfile, gameProfile.getName(), message);
                break;
            }
        }
    }

    public void notifyMessageRaw(String title, String message) {
        switch (this.labyConnect.getAlertDisplayType()) {
            case CHAT: {
                List<String> list = ModUtils.extractUrls(message);
                if (list.isEmpty()) {
                    LabyMod.getInstance().displayMessageInChat(ModColor.cl("7") + title + ModColor.cl("f") + ": " + message);
                    break;
                }
                LabyModCore.getMinecraft().displayMessageInChatURL(ModColor.cl("7") + title + ModColor.cl("f") + ": " + message, list.get(0));
                break;
            }
            case ACHIEVEMENT: {
                LabyMod.getInstance().getGuiCustomAchievement().displayAchievement(title, message);
                break;
            }
        }
    }

    public void connectToServer(String address) {
        this.switchServer(address, true);
    }

    public boolean switchServer(String address, boolean force) {
        this.serverManager.setPrevServer(ave.A().D());
        if (LabyModCore.getMinecraft().getWorld() != null) {
            bde currentServerData = ave.A().D();
            if (!force && address != null && currentServerData != null && currentServerData.b != null && ModUtils.getProfileNameByIp(currentServerData.b).equalsIgnoreCase(ModUtils.getProfileNameByIp(address))) {
                return false;
            }
            if (ave.A().aJ()) {
                LabyModCore.getMinecraft().getWorld().H();
                ave.A().a((bdb)null);
            }
        }
        this.onQuit();
        if (address != null) {
            bde serverData = new bde("Server", address, false);
            ave.A().a((axu)new awz((axu)new aya(), ave.A(), serverData));
        }
        return true;
    }

    public static boolean isForge() {
        return LabyModForge.isForge();
    }

    public static String getMessage(String key, Object ... args) {
        return LanguageManager.translate(key, args);
    }

    public void onJoinServer(bde currentServerData) {
        int port;
        String[] split = currentServerData.b.split(":");
        try {
            port = split.length > 1 ? Integer.parseInt(split[1].replaceAll(" ", "")) : 25565;
        }
        catch (Exception error) {
            port = 25565;
        }
        this.labyModAPI.lastServerSwitchTime = System.currentTimeMillis();
        this.currentServerData = new ServerData(split[0], port);
        this.labyConnect.updatePlayingOnServerState("");
        Permissions.getPermissionNotifyRenderer().checkChangedPermissions();
        try {
            this.eventManager.callJoinServer(this.currentServerData);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        if (currentServerData.b.toLowerCase().contains("hypixel")) {
            this.serverManager.getPermissionMap().put(Permissions.Permission.BLOCKBUILD, false);
            this.serverManager.getPermissionMap().put(Permissions.Permission.CHAT, false);
            this.serverHasEmoteSpamProtection = true;
        } else {
            this.serverHasEmoteSpamProtection = false;
        }
        ModuleConfig.switchProfile(currentServerData.b, false);
        EntityCulling.updateShadersModValue();
        Debug.log(Debug.EnumDebugMode.MINECRAFT, "Connected to server " + currentServerData.b);
    }

    public void onQuit() {
        this.labyModAPI.lastServerSwitchTime = System.currentTimeMillis();
        this.serverManager.reset();
        Permissions.getPermissionNotifyRenderer().quit();
        ave.A().a(() -> this.userManager.getCosmeticImageManager().unloadUnusedTextures(true, false));
        this.cinematicProtocol.reset(false);
        this.playerListDataCache.clear();
        this.priorityOverlayRenderer.reset();
        try {
            this.eventManager.callQuitServer(this.currentServerData);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        ModuleConfig.switchProfile(null, false);
        this.currentServerData = null;
        this.labyConnect.updatePlayingOnServerState("");
        this.labyConnect.getTracker().onDisconnectServer();
    }

    public boolean openWebpage(String urlString, boolean request) {
        try {
            if (!urlString.toLowerCase().startsWith("https://") && !urlString.toLowerCase().startsWith("http://")) {
                urlString = "http://" + urlString;
            }
            final URI uri = new URL(urlString).toURI();
            if (request) {
                final axu lastScreen = ave.A().m;
                ave.A().a((axu)new awy(new awx(){

                    public void a(boolean result, int id) {
                        if (result) {
                            Desktop desktop;
                            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                                try {
                                    desktop.browse(uri);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        ave.A().a(lastScreen);
                    }
                }, "Do you want to open this link in your default browser?", ModColor.cl("b") + uri.toString(), 31102009));
            } else {
                Desktop desktop;
                Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                    try {
                        desktop.browse(uri);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Channel getNettyChannel() throws Exception {
        bcy connecion = LabyModCore.getMinecraft().getConnection();
        if (connecion == null) {
            return null;
        }
        ek networkManager = connecion.a();
        return (Channel)this.channelField.get(networkManager);
    }

    @Deprecated
    public ModTextureUtils getTextureUtils() {
        return ModTextureUtils.INSTANCE;
    }

    public boolean isPremium() {
        return ave.A().L() != null && ave.A().L().d() != null && ave.A().L().d().length() > 10;
    }

    public boolean isSession(Account account) {
        avm session = ave.A().L();
        if (session == null || session.e() == null) {
            return false;
        }
        GameProfile profile = session.e();
        if (!profile.getId().equals(account.getUUID())) {
            return false;
        }
        return Objects.equals(session.d(), account.getAccessToken());
    }

    public void setSession(Account account) throws Exception {
        ClientConnection clientConnection = LabyMod.getInstance().getLabyConnect().getClientConnection();
        clientConnection.disconnect(false);
        ave mc = ave.A();
        Field field = ReflectionHelper.findField(ave.class, LabyModCore.getMappingAdapter().getSessionMappings());
        field.setAccessible(true);
        field.set(mc, new avm(account.getUsername(), account.getUUID().toString(), account.getAccessToken(), "mojang"));
        clientConnection.connect();
        Debug.log(Debug.EnumDebugMode.ACCOUNT_MANAGER, "AccountManager: You are now playing with " + account.getUsername() + ".");
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public DynamicTextureManager getDynamicTextureManager() {
        return this.dynamicTextureManager;
    }

    public DrawUtils getDrawUtils() {
        return this.drawUtils;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public CinematicProtocol getCinematicProtocol() {
        return this.cinematicProtocol;
    }

    public ChunkCachingProtocol getChunkCachingProtocol() {
        return this.chunkCachingProtocol;
    }

    public ShadowProtocol getShadowProtocol() {
        return this.shadowProtocol;
    }

    public ScreenProtocol getScreenProtocol() {
        return this.screenProtocol;
    }

    public Field getChannelField() {
        return this.channelField;
    }

    public ServerGroupProvider getServerGroupProvider() {
        return this.serverGroupProvider;
    }

    public AsyncAccountManager getAccountManager() {
        return this.accountManager;
    }

    public SneakingAnimationThread getSneakingAnimationThread() {
        return this.sneakingAnimationThread;
    }

    public boolean isHasLeftHand() {
        return this.hasLeftHand;
    }

    public GuiCustomAchievement getGuiCustomAchievement() {
        return this.guiCustomAchievement;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public LabyModAPI getLabyModAPI() {
        return this.labyModAPI;
    }

    public ServerManager getServerManager() {
        return this.serverManager;
    }

    public ServerData getCurrentServerData() {
        return this.currentServerData;
    }

    public ClientTickListener getClientTickListener() {
        return this.clientTickListener;
    }

    public RenderTickListener getRenderTickListener() {
        return this.renderTickListener;
    }

    public GuiOpenListener getGuiOpenListener() {
        return this.guiOpenListener;
    }

    public RenderIngamePostOverlayListener getPriorityOverlayRenderer() {
        return this.priorityOverlayRenderer;
    }

    public MarkerManager getMarkerManager() {
        return this.markerManager;
    }

    public AsyncTextureLoader getAsyncTextureLoader() {
        return this.asyncTextureLoader;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public EmoteRegistry getEmoteRegistry() {
        return this.emoteRegistry;
    }

    public StickerRegistry getStickerRegistry() {
        return this.stickerRegistry;
    }

    public DiscordApp getDiscordApp() {
        return this.discordApp;
    }

    public ChatToolManager getChatToolManager() {
        return this.chatToolManager;
    }

    public LabyConnect getLabyConnect() {
        return this.labyConnect;
    }

    public LabyPlay getLabyPlay() {
        return this.labyPlay;
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    public boolean isServerHasEmoteSpamProtection() {
        return this.serverHasEmoteSpamProtection;
    }

    public Map<UUID, bdc> getPlayerListDataCache() {
        return this.playerListDataCache;
    }

    public boolean isPlayerListCacheEnabled() {
        return this.playerListCacheEnabled;
    }

    public static LabyMod getInstance() {
        return instance;
    }

    public static Random getRandom() {
        return random;
    }

    public static ConfigManager<ModSettings> getMainConfig() {
        return mainConfig;
    }

    public void setSneakingAnimationThread(SneakingAnimationThread sneakingAnimationThread) {
        this.sneakingAnimationThread = sneakingAnimationThread;
    }

    public void setPartialTicks(float partialTicks) {
        this.partialTicks = partialTicks;
    }

    public void setPlayerListCacheEnabled(boolean playerListCacheEnabled) {
        this.playerListCacheEnabled = playerListCacheEnabled;
    }

    public PinManager getPinManager() {
        return this.pinManager;
    }

    static {
        random = new Random();
    }
}

