/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.labyplay.gui;

import java.io.IOException;
import java.util.List;
import net.labymod.gui.elements.MultiplayerTabs;
import net.labymod.gui.elements.Tabs;
import net.labymod.gui.layout.WindowElement;
import net.labymod.gui.layout.WindowLayout;
import net.labymod.labyplay.gui.elements.WinCurrentParty;
import net.labymod.labyplay.gui.elements.WinPartyCreator;
import net.labymod.labyplay.gui.elements.WinPartyInvites;
import net.labymod.labyplay.party.PartySystem;
import net.labymod.main.LabyMod;
import net.labymod.utils.DrawUtils;

public class GuiPlayLayout
extends WindowLayout {
    private axu parentScreen;
    private PartySystem partySystem;

    public GuiPlayLayout(axu parentScreen) {
        this.parentScreen = parentScreen;
        this.partySystem = LabyMod.getInstance().getLabyPlay().getPartySystem();
    }

    @Override
    public void b() {
        super.b();
        Tabs.initGui(this);
    }

    @Override
    protected void initLayout(List<WindowElement<?>> windowElements) {
        int partyInvitesSplit;
        this.n.clear();
        MultiplayerTabs.initMultiplayerTabs(2);
        int marginWindowX = this.l / 4;
        int marginWindowY = 10;
        int windowLeft = marginWindowX;
        int windowRight = this.l - marginWindowX;
        int windowBottom = this.m - marginWindowY;
        boolean hasParty = this.partySystem.hasParty();
        boolean hasInvites = !hasParty && this.partySystem.getPartyInvites().size() != 0;
        int partyPlaySplit = this.m - 80 + marginWindowY;
        int n = partyInvitesSplit = hasInvites ? this.l / 2 : windowRight;
        if (hasParty) {
            windowElements.add(new WinCurrentParty(this).construct(windowLeft, partyPlaySplit, partyInvitesSplit, windowBottom));
        } else {
            windowElements.add(new WinPartyCreator(this).construct(windowLeft, partyPlaySplit, partyInvitesSplit, windowBottom));
        }
        if (hasInvites) {
            windowElements.add(new WinPartyInvites(this).construct(partyInvitesSplit, partyPlaySplit, windowRight, windowBottom));
        }
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTicks) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        draw.drawAutoDimmedBackground(0, 41, this.l, this.m - 80);
        draw.drawOverlayBackground(0, 41);
        draw.drawOverlayBackground(0, this.m - 80, this.l, this.m);
        draw.drawGradientShadowTop(41.0, 0.0, this.l);
        draw.drawGradientShadowBottom(this.m - 80, 0.0, this.l);
        super.a(mouseX, mouseY, partialTicks);
        MultiplayerTabs.drawMultiplayerTabs(2, mouseX, mouseY, true, false);
        MultiplayerTabs.drawParty(mouseX, mouseY, this.l);
    }

    @Override
    protected void a(avs button) throws IOException {
        super.a(button);
    }

    @Override
    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        MultiplayerTabs.mouseClickedMultiplayerTabs(2, mouseX, mouseY);
        if (Tabs.mouseClicked(this)) {
            return;
        }
    }

    public axu getParentScreen() {
        return this.parentScreen;
    }

    public PartySystem getPartySystem() {
        return this.partySystem;
    }
}

