/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.labyconnect.gui.elements;

import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.CustomGuiButton;
import net.labymod.gui.layout.WindowElement;
import net.labymod.labyconnect.gui.GuiFriendsAddFriend;
import net.labymod.labyconnect.gui.GuiFriendsLayout;
import net.labymod.labyconnect.gui.GuiFriendsRequests;
import net.labymod.labyconnect.user.ChatUser;
import net.labymod.main.LabyMod;
import net.labymod.main.lang.LanguageManager;

public class WinMyProfile
extends WindowElement<GuiFriendsLayout> {
    private ChatUser clientUser;
    private CustomGuiButton buttonFriendRequests;
    private CustomGuiButton buttonAddFriend;
    private CustomGuiButton buttonChatSettings;
    private int totalButtonWidth;

    public WinMyProfile(GuiFriendsLayout chatLayout, ChatUser clientUser) {
        super(chatLayout);
        this.clientUser = clientUser;
    }

    @Override
    protected void init(List<avs> buttonlist, int left, int top, int right, int bottom) {
        String chatSettingsString = LanguageManager.translate("chat_settings");
        this.buttonFriendRequests = new CustomGuiButton(2, 0, top + (bottom - top - 20) / 2, 0, 20, "");
        buttonlist.add(this.buttonFriendRequests);
        this.buttonAddFriend = new CustomGuiButton(3, 0, top + (bottom - top - 20) / 2, 22, 20, "+");
        buttonlist.add(this.buttonAddFriend);
        this.buttonChatSettings = new CustomGuiButton(40, 0, top + (bottom - top - 20) / 2, LabyMod.getInstance().getDrawUtils().getStringWidth(chatSettingsString) + 10, 20, chatSettingsString);
        buttonlist.add(this.buttonChatSettings);
        this.updateButtons();
    }

    public void updateButtons() {
        int requestCount = LabyMod.getInstance().getLabyConnect().getRequests().size();
        String buttonString = LanguageManager.translate("button_requests") + (requestCount == 0 ? "" : " (" + requestCount + ")");
        int buttonWidth = LabyMod.getInstance().getDrawUtils().getStringWidth(buttonString) + 8;
        this.buttonFriendRequests.j = buttonString;
        this.buttonFriendRequests.l = requestCount != 0;
        this.buttonChatSettings.setXPosition(this.right - this.buttonChatSettings.b());
        this.buttonFriendRequests.setXPosition(this.right - buttonWidth - 4 - this.buttonChatSettings.b());
        this.buttonFriendRequests.a(buttonWidth);
        this.buttonAddFriend.setXPosition(this.right - buttonWidth - 4 - 25 - this.buttonChatSettings.b());
        this.totalButtonWidth = LabyModCore.getMinecraft().getXPosition(this.buttonAddFriend);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        super.draw(mouseX, mouseY);
        if (this.clientUser == null) {
            return;
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    @Override
    public void actionPerformed(avs button) {
        GuiFriendsLayout layout = (GuiFriendsLayout)this.layout;
        if (button.k == this.buttonAddFriend.k) {
            ave.A().a((axu)new GuiFriendsAddFriend(this.layout, layout.getChatElementSearchField().getFieldSearch().getText()));
        }
        if (button.k == this.buttonFriendRequests.k) {
            ave.A().a((axu)new GuiFriendsRequests(this.layout));
        }
        if (button.k == this.buttonChatSettings.k) {
            layout.setProfileOpen(!layout.isProfileOpen());
            ((GuiFriendsLayout)this.layout).b();
        }
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY) {
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void mouseInput() {
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void updateScreen() {
    }

    public int getTotalButtonWidth() {
        return this.totalButtonWidth;
    }
}

