/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.labyconnect.gui;

import java.io.IOException;
import java.util.List;
import net.labymod.gui.elements.MultiplayerTabs;
import net.labymod.gui.elements.Tabs;
import net.labymod.gui.layout.WindowElement;
import net.labymod.gui.layout.WindowLayout;
import net.labymod.labyconnect.gui.GuiFriendsNotConnected;
import net.labymod.labyconnect.gui.elements.WinChatlog;
import net.labymod.labyconnect.gui.elements.WinFriendlist;
import net.labymod.labyconnect.gui.elements.WinLogoutButton;
import net.labymod.labyconnect.gui.elements.WinMessageField;
import net.labymod.labyconnect.gui.elements.WinMyProfile;
import net.labymod.labyconnect.gui.elements.WinPartnerProfile;
import net.labymod.labyconnect.gui.elements.WinProfileSettings;
import net.labymod.labyconnect.gui.elements.WinSearchField;
import net.labymod.labyconnect.user.ChatUser;
import net.labymod.main.LabyMod;
import net.labymod.utils.DrawUtils;

public class GuiFriendsLayout
extends WindowLayout {
    private static final int WINDOW_SPLIT_DEPTH = 2;
    private static final int WINDOW_SPLIT_MIN = 80;
    private static final int WINDOW_SPLIT_MAX = 200;
    public static ChatUser selectedUser;
    private boolean hoverTableSplit = false;
    private boolean draggingTable = false;
    private boolean profileOpen = false;
    private WinChatlog chatElementChatlog;
    private WinFriendlist chatElementFriendlist;
    private WinMyProfile chatElementMyProfile;
    private WinPartnerProfile chatElementPartnerProfile;
    private WinMessageField chatElementMessageField;
    private WinSearchField chatElementSearchField;
    private WinLogoutButton chatElementLogoutButton;
    private WinProfileSettings chatElementProfileSettings;

    @Override
    public void b() {
        if (!LabyMod.getInstance().getLabyConnect().isOnline()) {
            ave.A().a((axu)new GuiFriendsNotConnected(this));
            selectedUser = null;
        }
        super.b();
        Tabs.initGui(this);
        this.chatElementPartnerProfile.setPartner(selectedUser);
        if (this.chatElementMessageField.getFieldMessage() != null) {
            this.chatElementMessageField.getFieldMessage().setFocused(true);
        }
    }

    @Override
    public void m() {
        LabyMod.getMainConfig().save();
        super.m();
    }

    @Override
    protected void initLayout(List<WindowElement<?>> windowElements) {
        this.n.clear();
        ChatUser clientUser = LabyMod.getInstance().getLabyConnect().getClientProfile().buildClientUser();
        int marginWindowX = 10;
        int marginWindowY = 10;
        int windowTop = 20 + marginWindowY;
        int windowLeft = marginWindowX;
        int windowRight = this.l - marginWindowX;
        int windowBottom = this.m - marginWindowY;
        int tableSplitSearchListHeight = 30;
        int tableSplitProfileLogHeight = 30;
        int tableSplitLogChatFieldHeight = 25;
        int tableSplitListLogWidth = LabyMod.getSettings().labymodChatSplitX;
        int tableSplitLogProfileWidth = this.profileOpen ? 170 : 0;
        this.chatElementPartnerProfile = new WinPartnerProfile(this);
        this.chatElementPartnerProfile.construct(windowLeft + tableSplitListLogWidth, windowTop, windowRight, windowTop + tableSplitProfileLogHeight);
        this.chatElementMyProfile = new WinMyProfile(this, clientUser);
        this.chatElementMyProfile.construct(windowLeft + tableSplitListLogWidth, windowTop, windowRight, windowTop + tableSplitProfileLogHeight);
        this.chatElementChatlog = new WinChatlog(this, clientUser);
        this.chatElementChatlog.construct(windowLeft + tableSplitListLogWidth, windowTop + tableSplitProfileLogHeight, windowRight - tableSplitLogProfileWidth, windowBottom - tableSplitLogChatFieldHeight);
        this.chatElementFriendlist = new WinFriendlist(this);
        this.chatElementFriendlist.construct(windowLeft, windowTop + tableSplitSearchListHeight, windowLeft + tableSplitListLogWidth, windowBottom - tableSplitLogChatFieldHeight);
        this.chatElementMessageField = new WinMessageField(this);
        this.chatElementMessageField.construct(windowLeft + tableSplitListLogWidth, windowBottom - tableSplitLogChatFieldHeight, windowRight - tableSplitLogProfileWidth, windowBottom);
        this.chatElementSearchField = new WinSearchField(this);
        this.chatElementSearchField.construct(windowLeft, windowTop, windowLeft + tableSplitListLogWidth, windowTop + tableSplitSearchListHeight);
        this.chatElementLogoutButton = new WinLogoutButton(this);
        this.chatElementLogoutButton.construct(windowLeft, windowBottom - tableSplitLogChatFieldHeight, windowLeft + tableSplitListLogWidth, windowBottom);
        this.chatElementProfileSettings = new WinProfileSettings(this);
        this.chatElementProfileSettings.construct(windowRight - tableSplitLogProfileWidth + 3, windowTop + tableSplitProfileLogHeight, windowRight, windowBottom - tableSplitLogChatFieldHeight);
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTicks) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        if (!LabyMod.getInstance().getLabyConnect().isOnline()) {
            ave.A().a((axu)new GuiFriendsNotConnected(this));
            selectedUser = null;
        }
        draw.drawAutoDimmedBackground(0.0);
        this.chatElementChatlog.draw(mouseX, mouseY);
        this.chatElementFriendlist.draw(mouseX, mouseY);
        if (this.profileOpen) {
            this.chatElementProfileSettings.draw(mouseX, mouseY);
        }
        this.drawHeaderAndFooter(this.chatElementChatlog.getTop(), this.chatElementChatlog.getBottom());
        this.chatElementPartnerProfile.draw(mouseX, mouseY);
        this.chatElementMyProfile.draw(mouseX, mouseY);
        this.chatElementMessageField.draw(mouseX, mouseY);
        this.chatElementSearchField.draw(mouseX, mouseY);
        this.chatElementLogoutButton.draw(mouseX, mouseY);
        boolean bl = this.hoverTableSplit = mouseX > this.chatElementFriendlist.getRight() - 2 && mouseX < this.chatElementChatlog.getLeft() + 2 && mouseY > this.chatElementFriendlist.getTop() && mouseY < this.chatElementFriendlist.getBottom();
        if (this.hoverTableSplit || this.draggingTable) {
            draw.drawCenteredString("|||", mouseX + 1, mouseY - 3);
            draw.drawRectangle(this.chatElementFriendlist.getRight() - 1, this.chatElementFriendlist.getTop(), this.chatElementChatlog.getLeft(), this.chatElementFriendlist.getBottom(), Integer.MAX_VALUE);
        }
        super.a(mouseX, mouseY, partialTicks);
        MultiplayerTabs.drawParty(mouseX, mouseY, this.l);
        Tabs.drawScreen(this, mouseX, mouseY);
    }

    private void drawHeaderAndFooter(int maxHeader, int minFooter) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        draw.drawOverlayBackground(0, maxHeader);
        draw.drawOverlayBackground(minFooter, this.m);
        draw.drawGradientShadowTop(maxHeader, 0.0, this.l);
        draw.drawGradientShadowBottom(minFooter, 0.0, this.l);
        draw.drawOverlayBackground(0, this.chatElementFriendlist.getTop(), this.chatElementFriendlist.getLeft(), this.chatElementFriendlist.getBottom());
        draw.drawOverlayBackground(this.chatElementFriendlist.getRight() - 3, this.chatElementFriendlist.getTop(), 5, this.chatElementFriendlist.getBottom());
        draw.drawOverlayBackground(this.chatElementProfileSettings.getRight(), this.chatElementChatlog.getTop(), this.l - this.chatElementProfileSettings.getRight(), this.chatElementChatlog.getBottom());
        draw.drawOverlayBackground(this.chatElementChatlog.getRight(), this.chatElementProfileSettings.getTop(), 2, this.chatElementProfileSettings.getBottom());
    }

    @Override
    public void e() {
        super.e();
        this.chatElementMessageField.updateScreen();
        this.chatElementSearchField.updateScreen();
    }

    @Override
    public void k() throws IOException {
        super.k();
        this.chatElementChatlog.handleMouseInput();
        this.chatElementFriendlist.handleMouseInput();
        if (this.profileOpen) {
            this.chatElementProfileSettings.handleMouseInput();
        }
        if (selectedUser != null) {
            selectedUser.setUnreadMessages(0);
        }
    }

    @Override
    protected void a(avs button) throws IOException {
        super.a(button);
        this.chatElementChatlog.actionPerformed(button);
        this.chatElementFriendlist.actionPerformed(button);
        this.chatElementPartnerProfile.actionPerformed(button);
        this.chatElementMyProfile.actionPerformed(button);
        this.chatElementMessageField.actionPerformed(button);
        this.chatElementSearchField.actionPerformed(button);
        this.chatElementLogoutButton.actionPerformed(button);
        if (this.profileOpen) {
            this.chatElementProfileSettings.actionPerformed(button);
        }
    }

    @Override
    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        if (Tabs.mouseClicked(this)) {
            return;
        }
        if (this.chatElementSearchField.mouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
        if (this.chatElementMyProfile.mouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
        this.chatElementChatlog.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.chatElementFriendlist.mouseClicked(mouseX, mouseY, mouseButton)) {
            return;
        }
        this.chatElementPartnerProfile.mouseClicked(mouseX, mouseY, mouseButton);
        this.chatElementMessageField.mouseClicked(mouseX, mouseY, mouseButton);
        this.chatElementLogoutButton.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.profileOpen) {
            this.chatElementProfileSettings.mouseClicked(mouseX, mouseY, mouseButton);
        }
        if (this.hoverTableSplit) {
            this.draggingTable = true;
        }
    }

    @Override
    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.chatElementChatlog.mouseClickMove(mouseX, mouseY);
        this.chatElementFriendlist.mouseClickMove(mouseX, mouseY);
        if (this.profileOpen) {
            this.chatElementProfileSettings.mouseClickMove(mouseX, mouseY);
        }
        if (this.draggingTable) {
            LabyMod.getSettings().labymodChatSplitX = mouseX - this.chatElementFriendlist.getLeft();
            if (LabyMod.getSettings().labymodChatSplitX < 80) {
                LabyMod.getSettings().labymodChatSplitX = 80;
            }
            if (LabyMod.getSettings().labymodChatSplitX > 200) {
                LabyMod.getSettings().labymodChatSplitX = 200;
            }
            this.initLayout();
        }
    }

    @Override
    protected void b(int mouseX, int mouseY, int state) {
        super.b(mouseX, mouseY, state);
        if (this.draggingTable) {
            this.draggingTable = false;
        }
    }

    @Override
    protected void a(char typedChar, int keyCode) throws IOException {
        super.a(typedChar, keyCode);
        this.chatElementChatlog.keyTyped(typedChar, keyCode);
        this.chatElementFriendlist.keyTyped(typedChar, keyCode);
        this.chatElementPartnerProfile.keyTyped(typedChar, keyCode);
        this.chatElementMyProfile.keyTyped(typedChar, keyCode);
        this.chatElementMessageField.keyTyped(typedChar, keyCode);
        this.chatElementSearchField.keyTyped(typedChar, keyCode);
        this.chatElementLogoutButton.keyTyped(typedChar, keyCode);
        if (this.profileOpen) {
            this.chatElementProfileSettings.keyTyped(typedChar, keyCode);
        }
    }

    public boolean isHoverTableSplit() {
        return this.hoverTableSplit;
    }

    public boolean isDraggingTable() {
        return this.draggingTable;
    }

    public boolean isProfileOpen() {
        return this.profileOpen;
    }

    public WinChatlog getChatElementChatlog() {
        return this.chatElementChatlog;
    }

    public WinFriendlist getChatElementFriendlist() {
        return this.chatElementFriendlist;
    }

    public WinMyProfile getChatElementMyProfile() {
        return this.chatElementMyProfile;
    }

    public WinPartnerProfile getChatElementPartnerProfile() {
        return this.chatElementPartnerProfile;
    }

    public WinMessageField getChatElementMessageField() {
        return this.chatElementMessageField;
    }

    public WinSearchField getChatElementSearchField() {
        return this.chatElementSearchField;
    }

    public WinLogoutButton getChatElementLogoutButton() {
        return this.chatElementLogoutButton;
    }

    public WinProfileSettings getChatElementProfileSettings() {
        return this.chatElementProfileSettings;
    }

    public void setProfileOpen(boolean profileOpen) {
        this.profileOpen = profileOpen;
    }
}

