/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.moduletypes.SimpleModule;
import net.labymod.main.LabyMod;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.NumberElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.settings.elements.StringElement;
import net.labymod.support.util.Debug;
import net.labymod.utils.Consumer;
import net.labymod.utils.Material;
import net.labymod.utils.request.DownloadServerRequest;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerResponse;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class YouTubeRealTimeModule
extends SimpleModule {
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11";
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private JsonParser jsonParser = new JsonParser();
    private String displayChannelUrl;
    private long requestInterval;
    private String channelUniqueId;
    private String requestSubscriberURL = null;
    private long lastRequest = 0L;
    private int subscribers;
    private String statusMessage;
    private String[] apiKeys;
    private int blocked = 6;
    private NumberFormat numberInstance = NumberFormat.getNumberInstance(Locale.US);

    public YouTubeRealTimeModule() {
        DownloadServerRequest.getJsonObjectAsync("https://dl.labymod.net/subcounter.json", new ServerResponse<JsonElement>(){

            @Override
            public void success(JsonElement result) {
                JsonObject jsonObject = result.getAsJsonObject();
                if (jsonObject.has("url")) {
                    YouTubeRealTimeModule.this.requestSubscriberURL = jsonObject.get("url").getAsString();
                }
                if (jsonObject.has("keys")) {
                    JsonArray jsonArray = jsonObject.get("keys").getAsJsonArray();
                    Iterator it = jsonArray.iterator();
                    YouTubeRealTimeModule.access$102(YouTubeRealTimeModule.this, new String[jsonArray.size()]);
                    int i = 0;
                    while (it.hasNext()) {
                        ((YouTubeRealTimeModule)YouTubeRealTimeModule.this).apiKeys[i] = ((JsonElement)it.next()).getAsString();
                        ++i;
                    }
                }
            }

            @Override
            public void failed(RequestException exception) {
                exception.printStackTrace();
            }
        });
    }

    @Override
    public String getDisplayName() {
        return "Subscriber";
    }

    @Override
    public String getDisplayValue() {
        return this.statusMessage == null ? this.numberInstance.format(this.subscribers) : this.statusMessage;
    }

    @Override
    public String getDefaultValue() {
        return "?";
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (this.getEnabled().size() == 0 || !LabyMod.getInstance().isInGame()) {
            return;
        }
        if (Module.isDrawn() && this.lastRequest < System.currentTimeMillis()) {
            this.lastRequest = System.currentTimeMillis() + 1000L * this.requestInterval;
            if (this.channelUniqueId == null || this.channelUniqueId.isEmpty()) {
                this.handleAccept(this.displayChannelUrl == null || this.displayChannelUrl.isEmpty() ? -4 : -3);
            } else if (this.blocked <= 0) {
                this.handleAccept(-5);
            } else {
                this.requestSubscriber(this.channelUniqueId, new Consumer<Integer>(){

                    @Override
                    public void accept(Integer subscriberCount) {
                        YouTubeRealTimeModule.this.handleAccept(subscriberCount);
                    }
                });
            }
        }
    }

    private void handleAccept(Integer subscriberCount) {
        switch (subscriberCount) {
            case -6: {
                this.statusMessage = "Cannot parse json!";
                break;
            }
            case -5: {
                this.statusMessage = "YouTube API is blocked! Please restart your game..";
                break;
            }
            case -4: {
                this.statusMessage = "No channel given";
                break;
            }
            case -3: {
                this.statusMessage = "Parsing url..";
                break;
            }
            case -2: {
                this.statusMessage = "Channel not found";
                break;
            }
            case -1: {
                this.statusMessage = "Request failed";
                break;
            }
            default: {
                this.statusMessage = null;
            }
        }
        if (subscriberCount == -2 || subscriberCount == -3) {
            this.lastRequest = System.currentTimeMillis() + 3000L;
            this.parseInputString(this.displayChannelUrl, new Consumer<String>(){

                @Override
                public void accept(String accepted) {
                    if (accepted == null) {
                        YouTubeRealTimeModule.this.statusMessage = "Invalid url";
                        YouTubeRealTimeModule.this.lastRequest = System.currentTimeMillis() + 500000L;
                    } else {
                        YouTubeRealTimeModule.this.channelUniqueId = accepted;
                        YouTubeRealTimeModule.this.setAttribute("channelUniqueId", accepted);
                    }
                }
            });
        }
        this.subscribers = subscriberCount;
    }

    private void parseInputString(String inputString, Consumer<String> callback) {
        if (inputString.contains("/")) {
            String[] data = inputString.split("/");
            YTChannelType foundType = null;
            for (String value : data) {
                if (foundType == YTChannelType.CHANNEL) {
                    this.statusMessage = "Load channel by channel id..";
                    if (value.contains("?")) {
                        value = value.split("\\?")[0];
                    }
                    callback.accept(value);
                    return;
                }
                if (foundType == YTChannelType.USER) {
                    this.statusMessage = "Fetching channel id by username..";
                    this.requestChannelUniqueId(foundType, value, callback);
                    return;
                }
                if (foundType == YTChannelType.C) {
                    this.statusMessage = "Fetching channel id by cname..";
                    this.requestChannelUniqueId(foundType, value, callback);
                    return;
                }
                foundType = YTChannelType.getByValue(value);
            }
            if (foundType == null) {
                this.statusMessage = "Please use ../c/<name>, ../user/<name> or ../channel/<id>";
            }
        } else {
            this.statusMessage = this.statusMessage.isEmpty() ? "Validate channel id.." : this.statusMessage + " - Validate channel id..";
            callback.accept(inputString);
        }
    }

    private void requestSubscriber(final String channelUniqueId, final Consumer<Integer> callback) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (channelUniqueId.isEmpty()) {
                    return;
                }
                try {
                    Scanner scanner;
                    if (YouTubeRealTimeModule.this.requestSubscriberURL == null) {
                        callback.accept(-1);
                        return;
                    }
                    String url = String.format(YouTubeRealTimeModule.this.requestSubscriberURL, channelUniqueId, YouTubeRealTimeModule.this.apiKeys[LabyMod.getRandom().nextInt(YouTubeRealTimeModule.this.apiKeys.length)]);
                    HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
                    connection.setRequestProperty("User-Agent", YouTubeRealTimeModule.USER_AGENT);
                    connection.connect();
                    if (connection.getResponseCode() != 200) {
                        Debug.log(Debug.EnumDebugMode.GENERAL, "YouTube API error: " + connection.getResponseCode() + " (" + url + ")");
                        YouTubeRealTimeModule.this.blocked--;
                    }
                    if ((scanner = new Scanner(connection.getInputStream())).hasNext()) {
                        try {
                            String jsonResponse = "";
                            while (scanner.hasNextLine()) {
                                jsonResponse = jsonResponse + scanner.nextLine();
                            }
                            JsonElement jsonObj = YouTubeRealTimeModule.this.jsonParser.parse(jsonResponse);
                            int count = jsonObj.getAsJsonObject().get("items").getAsJsonArray().get(0).getAsJsonObject().get("statistics").getAsJsonObject().get("subscriberCount").getAsInt();
                            if (YouTubeRealTimeModule.this.blocked < 5) {
                                YouTubeRealTimeModule.this.blocked++;
                            }
                            callback.accept(count);
                        }
                        catch (Exception error) {
                            error.printStackTrace();
                            callback.accept(-6);
                        }
                    } else {
                        callback.accept(-2);
                    }
                    scanner.close();
                }
                catch (Exception error) {
                    error.printStackTrace();
                    callback.accept(-1);
                }
            }
        });
    }

    private void requestChannelUniqueId(final YTChannelType channelType, final String channelName, final Consumer<String> callback) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (channelType == null || channelName.isEmpty()) {
                    callback.accept(null);
                    return;
                }
                try {
                    HttpURLConnection connection = (HttpURLConnection)new URL("https://socialblade.com/youtube/" + channelType.getValue() + "/" + channelName + "/realtime").openConnection();
                    connection.setRequestProperty("User-Agent", YouTubeRealTimeModule.USER_AGENT);
                    connection.connect();
                    Scanner scanner = new Scanner(connection.getInputStream());
                    while (scanner.hasNext()) {
                        String line = scanner.nextLine();
                        if (!line.startsWith("<p id=\"rawUser\" style=\"display: none;\">")) continue;
                        String uid = line.replaceAll("(?i)<p id=\"rawUser\" style=\"display: none;\">(.+?)</p>", "$1");
                        if (uid.contains("\"")) break;
                        callback.accept(uid);
                        YouTubeRealTimeModule.this.lastRequest = System.currentTimeMillis() + 1000L;
                        scanner.close();
                        return;
                    }
                    scanner.close();
                    callback.accept(null);
                }
                catch (Exception error) {
                    error.printStackTrace();
                    callback.accept(null);
                }
            }
        });
    }

    @Override
    public void loadSettings() {
        this.channelUniqueId = this.getAttribute("channelUniqueId", "");
        this.requestInterval = Integer.parseInt(this.getAttribute("interval", "30"));
        this.displayChannelUrl = this.getAttribute("displayChannelUrl", "");
        if (this.requestInterval < 30L) {
            this.requestInterval = 30L;
        }
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        settingsElements.add(new StringElement(this, new ControlElement.IconData(Material.PAPER), "Channel URL", "displayChannelUrl").maxLength(200).addCallback(new Consumer<String>(){

            @Override
            public void accept(String value) {
                YouTubeRealTimeModule.this.channelUniqueId = null;
                YouTubeRealTimeModule.this.setAttribute("channelUniqueId", "");
                YouTubeRealTimeModule.this.lastRequest = System.currentTimeMillis() + 1000L;
            }
        }));
        settingsElements.add(new NumberElement(this, new ControlElement.IconData(Material.WATCH), "Update interval", "interval").setRange(30, 500).addCallback(new Consumer<Integer>(){

            @Override
            public void accept(Integer value) {
                YouTubeRealTimeModule.this.lastRequest = System.currentTimeMillis() + (long)(1000 * value);
            }
        }));
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon("youtube");
    }

    @Override
    public String getSettingName() {
        return "youTube_subscriber_counter";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_EXTERNAL_SERVICES;
    }

    @Override
    public int getSortingId() {
        return 0;
    }

    static /* synthetic */ String[] access$102(YouTubeRealTimeModule x0, String[] x1) {
        x0.apiKeys = x1;
        return x1;
    }

    public static enum YTChannelType {
        C("c"),
        USER("user"),
        CHANNEL("channel");

        private String value;

        private YTChannelType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static YTChannelType getByValue(String value) {
            for (YTChannelType type : YTChannelType.values()) {
                if (!type.getValue().equalsIgnoreCase(value)) continue;
                return type;
            }
            return null;
        }
    }
}

