/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.labymod.gui.elements.DropDownMenu;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.moduletypes.ColoredTextModule;
import net.labymod.ingamegui.moduletypes.TextModule;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.DropDownElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Material;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModUtils;

public class MemoryModule
extends TextModule {
    private EnumMemoryType enumMemoryType;
    private boolean coloredNumber;
    private boolean moreSpace;
    private long lastUpdate = -1L;
    private List<List<ColoredTextModule.Text>> lastRenderedMemory = Collections.singletonList(new ArrayList());

    @Override
    public String[] getKeys() {
        return new String[]{"Memory"};
    }

    @Override
    public List<List<ColoredTextModule.Text>> getTextValues() {
        if (this.lastUpdate + 50L < System.currentTimeMillis()) {
            this.lastUpdate = System.currentTimeMillis();
            ArrayList<ColoredTextModule.Text> texts = new ArrayList<ColoredTextModule.Text>();
            long maxMemory = Runtime.getRuntime().maxMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            long freeMemory = Runtime.getRuntime().freeMemory();
            long usedMemory = totalMemory - freeMemory;
            long percent = usedMemory * 100L / maxMemory;
            int statusColor = this.valueColor;
            if (this.coloredNumber) {
                int n = percent >= 70L ? (percent >= 90L ? ModColor.DARK_RED.getColor().getRGB() : ModColor.RED.getColor().getRGB()) : (statusColor = statusColor);
            }
            if (this.enumMemoryType == EnumMemoryType.PERCENT || this.enumMemoryType == EnumMemoryType.USED_PERCENT) {
                texts.add(new ColoredTextModule.Text(percent + "%", statusColor));
            }
            if (this.enumMemoryType == EnumMemoryType.USED_SLASH_MAX || this.enumMemoryType == EnumMemoryType.USED_OF_MAX || this.enumMemoryType == EnumMemoryType.USED || this.enumMemoryType == EnumMemoryType.USED_PERCENT) {
                ColoredTextModule.Text readableByteCountUsedMemory = new ColoredTextModule.Text((this.enumMemoryType == EnumMemoryType.USED_PERCENT ? " " : "") + ModUtils.humanReadableByteCount(usedMemory, true, this.moreSpace), statusColor);
                texts.add(readableByteCountUsedMemory);
                if (this.enumMemoryType != EnumMemoryType.USED && this.enumMemoryType != EnumMemoryType.USED_PERCENT) {
                    ColoredTextModule.Text readableByteCountMaxMemory = new ColoredTextModule.Text(ModUtils.humanReadableByteCount(maxMemory, true, this.moreSpace), -1);
                    texts.add(new ColoredTextModule.Text(this.enumMemoryType == EnumMemoryType.USED_SLASH_MAX ? "/" : " of ", this.bracketsColor));
                    texts.add(readableByteCountMaxMemory);
                }
            }
            this.lastRenderedMemory = Collections.singletonList(texts);
            return this.lastRenderedMemory;
        }
        return this.lastRenderedMemory;
    }

    @Override
    public String[] getDefaultKeys() {
        return this.getKeys();
    }

    @Override
    public List<List<ColoredTextModule.Text>> getDefaultTextValues() {
        return Collections.singletonList(Collections.singletonList(ColoredTextModule.Text.getText("?", -1)));
    }

    @Override
    public void loadSettings() {
        this.enumMemoryType = EnumMemoryType.valueOf(this.getAttribute("memoryType", "PERCENT"));
        this.coloredNumber = Boolean.valueOf(this.getAttribute("coloredNumber", "true"));
        this.moreSpace = Boolean.valueOf(this.getAttribute("moreSpace", "true"));
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        DropDownMenu<EnumMemoryType> dropDownMenu = new DropDownMenu<EnumMemoryType>("Memory Display Type", 0, 0, 0, 0).fill(EnumMemoryType.values());
        dropDownMenu.setSelected(this.enumMemoryType);
        DropDownElement<EnumMemoryType> dropDownElement = new DropDownElement<EnumMemoryType>(this, "Memory Display Type", "memoryType", dropDownMenu, new DropDownElement.DrowpDownLoadValue<EnumMemoryType>(){

            @Override
            public EnumMemoryType load(String value) {
                return EnumMemoryType.valueOf(value);
            }
        });
        settingsElements.add(dropDownElement);
        settingsElements.add(new BooleanElement(this, this.getModuleIcon(this.getSettingName(), "colorednumber"), "Colored number", "coloredNumber"));
        settingsElements.add(new BooleanElement(this, new ControlElement.IconData(Material.DIODE), "More space", "moreSpace"));
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "memory";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public int getSortingId() {
        return 6;
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_INFO;
    }

    private static enum EnumMemoryType {
        PERCENT,
        USED,
        USED_PERCENT,
        USED_SLASH_MAX,
        USED_OF_MAX;

    }
}

