/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.enums.EnumModuleFormatting;
import net.labymod.ingamegui.moduletypes.ColoredTextModule;
import net.labymod.ingamegui.moduletypes.TextModule;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Material;

public class FModule
extends TextModule {
    private boolean directionNumber;
    private boolean cardinalPoints;
    private boolean xzDirection;
    private boolean shortenNames;

    @Override
    public String[] getKeys() {
        return new String[]{"F"};
    }

    @Override
    public String[] getDefaultKeys() {
        return this.getKeys();
    }

    @Override
    public List<List<ColoredTextModule.Text>> getTextValues() {
        XZDRange range;
        ArrayList<ColoredTextModule.Text> texts = new ArrayList<ColoredTextModule.Text>();
        double f2 = this.getFValue();
        if (this.directionNumber) {
            texts.add(ColoredTextModule.Text.getText(String.valueOf(f2), this.valueColor));
        }
        if ((this.cardinalPoints || this.xzDirection) && (range = XZDRange.getRangeByF(f2)) != null) {
            if (this.cardinalPoints) {
                if (!texts.isEmpty()) {
                    texts.add(ColoredTextModule.Text.getText(" "));
                }
                texts.addAll(this.getCardinalPoint(range));
            }
            if (this.xzDirection) {
                if (!texts.isEmpty()) {
                    texts.add(ColoredTextModule.Text.getText(" "));
                }
                texts.addAll(this.getXZD(range));
            }
        }
        if (texts.isEmpty()) {
            texts.add(ColoredTextModule.Text.getText("Useless"));
        }
        return Collections.singletonList(texts);
    }

    @Override
    public List<List<ColoredTextModule.Text>> getDefaultTextValues() {
        return Collections.singletonList(Collections.singletonList(ColoredTextModule.Text.getText("?", -1)));
    }

    private double getFValue() {
        double f2;
        pk entity = LabyModCore.getMinecraft().getRenderViewEntity();
        if (entity == null) {
            entity = LabyModCore.getMinecraft().getPlayer();
        }
        if ((f2 = (double)LabyModCore.getMath().wrapAngleTo180_float(entity == null ? 1.0f : entity.y)) <= 0.0) {
            f2 += 360.0;
        }
        f2 /= 8.0;
        f2 /= 11.0;
        if ((f2 = (double)Math.round(f2 * 10.0) / 10.0) >= 4.0) {
            f2 = 0.0;
        }
        return f2;
    }

    private List<ColoredTextModule.Text> getCardinalPoint(XZDRange range) {
        List<XZDRange.DisplayedDirection> displayedDirections = Arrays.asList(range.getDisplayed());
        ArrayList<String> cardinalPoints = new ArrayList<String>();
        ArrayList<ColoredTextModule.Text> texts = new ArrayList<ColoredTextModule.Text>();
        if (displayedDirections.contains((Object)XZDRange.DisplayedDirection.ZMINUS)) {
            cardinalPoints.add(this.shortenNames ? "N" : "North");
        }
        if (displayedDirections.contains((Object)XZDRange.DisplayedDirection.ZPLUS)) {
            cardinalPoints.add(this.shortenNames ? "S" : "South");
        }
        if (displayedDirections.contains((Object)XZDRange.DisplayedDirection.XPLUS)) {
            cardinalPoints.add(this.shortenNames ? "E" : "East");
        }
        if (displayedDirections.contains((Object)XZDRange.DisplayedDirection.XMINUS)) {
            cardinalPoints.add(this.shortenNames ? "W" : "West");
        }
        for (String point : cardinalPoints) {
            if (!texts.isEmpty()) {
                texts.add(ColoredTextModule.Text.getText("/", this.bracketsColor));
            }
            texts.add(ColoredTextModule.Text.getText(point, this.valueColor));
        }
        return texts;
    }

    private List<ColoredTextModule.Text> getXZD(XZDRange range) {
        ArrayList<ColoredTextModule.Text> texts = new ArrayList<ColoredTextModule.Text>();
        if (range == null) {
            return Collections.emptyList();
        }
        EnumModuleFormatting displayFormatting = this.getDisplayFormatting();
        ColoredTextModule.Text prefix = null;
        ColoredTextModule.Text suffix = null;
        if (this.cardinalPoints || this.directionNumber) {
            switch (displayFormatting) {
                case SQUARE_BRACKETS: {
                    prefix = ColoredTextModule.Text.getText("[", this.bracketsColor);
                    suffix = ColoredTextModule.Text.getText("]", this.bracketsColor);
                    break;
                }
                case BRACKETS: {
                    prefix = ColoredTextModule.Text.getText("<", this.bracketsColor);
                    suffix = ColoredTextModule.Text.getText(">", this.bracketsColor);
                    break;
                }
                case HYPHEN: {
                    prefix = ColoredTextModule.Text.getText("(", this.bracketsColor);
                    suffix = ColoredTextModule.Text.getText(")", this.bracketsColor);
                    break;
                }
                case COLON: {
                    break;
                }
                case DEFAULT: {
                    break;
                }
            }
        }
        if (prefix != null) {
            texts.add(prefix);
        }
        texts.addAll(range.getTexts(this.valueColor, this.bracketsColor));
        if (suffix != null) {
            texts.add(suffix);
        }
        return texts;
    }

    @Override
    public void loadSettings() {
        this.directionNumber = Boolean.valueOf(this.getAttribute("directionNumber", "true"));
        this.cardinalPoints = Boolean.valueOf(this.getAttribute("cardinalPoints", "true"));
        this.xzDirection = Boolean.valueOf(this.getAttribute("xzDirection", "true"));
        this.shortenNames = Boolean.valueOf(this.getAttribute("shortenNames", "false"));
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        settingsElements.add(new BooleanElement(this, new ControlElement.IconData(Material.COMPASS), "Direction Number", "directionNumber"));
        settingsElements.add(new BooleanElement(this, new ControlElement.IconData(Material.COMPASS), "Cardinal points", "cardinalPoints"));
        settingsElements.add(new BooleanElement(this, new ControlElement.IconData(Material.COMPASS), "XZ Direction", "xzDirection"));
        settingsElements.add(new BooleanElement(this, new ControlElement.IconData(Material.SIGN), "Shorten cardinal names", "shortenNames"));
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "f";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public int getSortingId() {
        return 2;
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_INFO;
    }

    private static enum XZDRange {
        ZPLUS(0.0, 0.3, DisplayedDirection.ZPLUS),
        ZPLUS_XMINUS(0.3, 0.8, DisplayedDirection.XMINUS, DisplayedDirection.ZPLUS),
        XMINUS(0.8, 1.4, DisplayedDirection.XMINUS),
        XMINUS_ZMINUS(1.4, 1.8, DisplayedDirection.XMINUS, DisplayedDirection.ZMINUS),
        ZMINUS(1.8, 2.4, DisplayedDirection.ZMINUS),
        ZMINUS_XPLUS(2.4, 2.8, DisplayedDirection.XPLUS, DisplayedDirection.ZMINUS),
        XPLUS(2.8, 3.4, DisplayedDirection.XPLUS),
        XPLUS_ZPLUS(3.4, 3.8, DisplayedDirection.XPLUS, DisplayedDirection.ZPLUS),
        ZPLUS_2(3.8, 4.0, DisplayedDirection.ZPLUS);

        private double min;
        private double max;
        private DisplayedDirection[] displayed;

        private XZDRange(double min, double max, DisplayedDirection ... displayed) {
            this.min = min;
            this.max = max;
            this.displayed = displayed;
        }

        public static XZDRange getRangeByF(double f2) {
            if (f2 >= 4.0) {
                return ZPLUS_2;
            }
            for (XZDRange range : XZDRange.values()) {
                if (!(f2 >= range.min) || !(f2 < range.max)) continue;
                return range;
            }
            return null;
        }

        public List<ColoredTextModule.Text> getTexts(int valueColor, int bracketsColor) {
            ArrayList<ColoredTextModule.Text> texts = new ArrayList<ColoredTextModule.Text>();
            for (DisplayedDirection direction : this.displayed) {
                if (texts.size() > 0) {
                    texts.add(ColoredTextModule.Text.getText(", ", bracketsColor));
                }
                texts.add(direction.getText(valueColor));
            }
            return texts;
        }

        public DisplayedDirection[] getDisplayed() {
            return this.displayed;
        }

        private static enum DisplayedDirection {
            XPLUS("X+"),
            XMINUS("X-"),
            ZPLUS("Z+"),
            ZMINUS("Z-");

            private String text;

            private DisplayedDirection(String text) {
                this.text = text;
            }

            public ColoredTextModule.Text getText(int valueColor) {
                return ColoredTextModule.Text.getText(this.text, valueColor);
            }
        }
    }
}

