/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.labymod.gui.elements.DropDownMenu;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.moduletypes.SimpleModule;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.DropDownElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.settings.elements.StringElement;
import net.labymod.utils.Material;

public class ClockModule
extends SimpleModule {
    private String selectedClockFormat;
    private SimpleDateFormat clockFormat;
    private Date date = new Date();

    @Override
    public String getDisplayName() {
        return "Clock";
    }

    @Override
    public String getDisplayValue() {
        this.date.setTime(System.currentTimeMillis());
        return this.clockFormat == null ? "Invalid time format: " + this.selectedClockFormat : this.clockFormat.format(this.date);
    }

    @Override
    public String getDefaultValue() {
        return "Unknown";
    }

    private void updateSimpleDateFormat() {
        try {
            this.clockFormat = new SimpleDateFormat(this.selectedClockFormat);
        }
        catch (IllegalArgumentException error) {
            this.clockFormat = null;
        }
    }

    @Override
    public void loadSettings() {
        this.selectedClockFormat = this.getAttribute("timeFormat", "hh:mm aa");
        if (this.selectedClockFormat.equals("Use Custom Format")) {
            this.selectedClockFormat = this.getAttribute("customFormat", "hh:mm aa");
        }
        this.updateSimpleDateFormat();
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        DropDownMenu<String> dropDownMenu = new DropDownMenu<String>("Time format", 0, 0, 0, 0);
        dropDownMenu.addOption("hh:mm aa");
        dropDownMenu.addOption("HH:mm");
        dropDownMenu.addOption("HH:mm:ss");
        dropDownMenu.addOption("Use Custom Format");
        dropDownMenu.setSelected(this.selectedClockFormat);
        DropDownElement dropDownElement = new DropDownElement(this, "Time format", "timeFormat", dropDownMenu, null);
        settingsElements.add(dropDownElement);
        settingsElements.add(new StringElement(this, new ControlElement.IconData(Material.ANVIL), "Custom format", "customFormat"));
    }

    @Override
    public ControlElement.IconData getIconData() {
        return new ControlElement.IconData(Material.WATCH);
    }

    @Override
    public String getSettingName() {
        return "clock";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_INFO;
    }

    @Override
    public int getSortingId() {
        return 3;
    }
}

