/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.util.List;
import net.labymod.api.events.MouseInputEvent;
import net.labymod.gui.elements.DropDownMenu;
import net.labymod.ingamegui.Module;
import net.labymod.ingamegui.moduletypes.SimpleModule;
import net.labymod.main.LabyMod;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.DropDownElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Material;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;

public class ClickTestModule
extends SimpleModule
implements MouseInputEvent {
    private String selectedMouseTracking = null;
    private TrackingKey trackingKey0 = new TrackingKey(0);
    private TrackingKey trackingKey1 = new TrackingKey(1);
    private int currentlyTrackingKey = -1;
    private int selectedMouseTrackingMode;
    private boolean displayAtZeroClicks;
    private boolean fpsPolling;

    public ClickTestModule() {
        LabyMod.getInstance().getEventManager().register(this);
    }

    @Override
    public String getDisplayName() {
        return "Clicks";
    }

    @Override
    public String getDisplayValue() {
        int count = this.getTrackingCount();
        return String.valueOf(count);
    }

    @Override
    public String getDefaultValue() {
        return "?";
    }

    private int getTrackingCount() {
        int count = 0;
        switch (this.currentlyTrackingKey) {
            case -1: {
                count = this.trackingKey0.getClicks() + this.trackingKey1.getClicks();
                if (this.selectedMouseTrackingMode != 3) break;
                this.currentlyTrackingKey = this.trackingKey0.isPressed() ? 0 : 1;
                break;
            }
            case 0: {
                count = this.trackingKey0.getClicks();
                break;
            }
            case 1: {
                count = this.trackingKey1.getClicks();
            }
        }
        return count;
    }

    @Override
    public boolean isShown() {
        int count;
        if (this.isEnabled(Module.getLastDrawnDisplayType())) {
            if (this.fpsPolling) {
                this.trackingKey0.checkKeyState();
                this.trackingKey1.checkKeyState();
            } else {
                this.trackingKey0.updateResult();
                this.trackingKey1.updateResult();
            }
        }
        return (count = this.getTrackingCount()) != 0 || this.displayAtZeroClicks;
    }

    @Override
    public void receiveMouseInput(int mouseButton) {
        if (!this.fpsPolling) {
            if (mouseButton == 0) {
                this.trackingKey0.mouseEvent();
            } else if (mouseButton == 1) {
                this.trackingKey1.mouseEvent();
            }
        }
    }

    @Override
    public void draw(double x, double y, double rightX) {
        super.draw(x, y, rightX);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        switch (this.selectedMouseTrackingMode) {
            case 0: {
                this.currentlyTrackingKey = -1;
                break;
            }
            case 1: {
                this.currentlyTrackingKey = 0;
                break;
            }
            case 2: {
                this.currentlyTrackingKey = 1;
            }
            case 3: {
                if (this.getTrackingCount() != 0) break;
                this.currentlyTrackingKey = -1;
            }
        }
    }

    @Override
    public void loadSettings() {
        this.selectedMouseTracking = this.getAttribute("mouseTrackingMode", "Left and rightclick");
        this.selectedMouseTrackingMode = this.selectedMouseTracking == null || this.selectedMouseTracking.equals("Left and rightclick") ? 0 : (this.selectedMouseTracking.equals("Leftclick") ? 1 : (this.selectedMouseTracking.equals("Rightclick") ? 2 : 3));
        this.displayAtZeroClicks = Boolean.valueOf(this.getAttribute("displayAtZeroClicks", "false"));
        this.fpsPolling = this.getAttribute("mouseTrackingMethod", "FPS Polling").equals("Actual Mouse Input");
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        DropDownMenu<String> dropDownMenu = new DropDownMenu<String>("Tracking mouse keys", 0, 0, 0, 0);
        dropDownMenu.addOption("First clicked key");
        dropDownMenu.addOption("Left and rightclick");
        dropDownMenu.addOption("Leftclick");
        dropDownMenu.addOption("Rightclick");
        dropDownMenu.setSelected(this.selectedMouseTracking);
        DropDownElement<String> dropDownElement = new DropDownElement<String>(this, "Tracking mouse keys", "mouseTrackingMode", dropDownMenu, new DropDownElement.DrowpDownLoadValue<String>(){

            @Override
            public String load(String value) {
                return value;
            }
        });
        settingsElements.add(dropDownElement);
        settingsElements.add(new BooleanElement(this, new ControlElement.IconData(Material.EYE_OF_ENDER), "Visible at 0 clicks", "displayAtZeroClicks"));
        DropDownMenu<String> dropDownMenuMethod = new DropDownMenu<String>("Tracking method", 0, 0, 0, 0);
        dropDownMenuMethod.addOption("Actual Mouse Input");
        dropDownMenuMethod.addOption("FPS Polling");
        dropDownMenuMethod.setSelected(this.selectedMouseTracking);
        DropDownElement<String> dropDownElementMethod = new DropDownElement<String>(this, "Tracking method", "mouseTrackingMethod", dropDownMenuMethod, new DropDownElement.DrowpDownLoadValue<String>(){

            @Override
            public String load(String value) {
                return value;
            }
        });
        settingsElements.add(dropDownElementMethod);
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "clicktest";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public int getSortingId() {
        return 0;
    }

    public static class TrackingKey {
        private int keyId;
        private long lastCPSCheck = 0L;
        private int cpsCount;
        private int cpsCountSecond;
        private boolean cpsPressed;

        public TrackingKey(int keyId) {
            this.keyId = keyId;
        }

        public boolean isPressed() {
            return Mouse.isButtonDown((int)this.keyId);
        }

        public void checkKeyState() {
            if (this.isPressed()) {
                if (!this.cpsPressed) {
                    this.cpsPressed = true;
                    ++this.cpsCount;
                }
            } else {
                this.cpsPressed = false;
            }
            this.updateResult();
        }

        public void mouseEvent() {
            ++this.cpsCount;
        }

        public void updateResult() {
            if (this.lastCPSCheck + 1000L < System.currentTimeMillis()) {
                this.lastCPSCheck = System.currentTimeMillis();
                this.cpsCountSecond = this.cpsCount;
                this.cpsCount = 0;
            }
        }

        public int getClicks() {
            return this.cpsCountSecond;
        }
    }
}

