/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.util.List;
import net.labymod.api.protocol.chunk.ChunkCachingProtocol;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.moduletypes.SimpleTextModule;
import net.labymod.main.LabyMod;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.ModUtils;

public class ChunkCachingModule
extends SimpleTextModule {
    @Override
    public String[] getKeys() {
        String[] stringArray;
        ChunkCachingProtocol ccp = LabyMod.getInstance().getChunkCachingProtocol();
        if (ccp.isCachingSupported()) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = "Cached";
            stringArray2[1] = "Cache size";
            stringArray2[2] = "Downloaded";
            stringArray = stringArray2;
            stringArray2[3] = "Skipped";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "CCP";
        }
        return stringArray;
    }

    @Override
    public String[] getValues() {
        ChunkCachingProtocol ccp = LabyMod.getInstance().getChunkCachingProtocol();
        if (!ccp.isCachingSupported()) {
            return new String[]{"Not supported here"};
        }
        long cachedMemory = ccp.getCurrentlyCachedBytes().get();
        long loadedBytes = ccp.getLoadedBytesInSession();
        long downloadedBytes = ccp.getDownloadedBytesInSession();
        int count = ccp.getChunkCache().size();
        String lineAmount = count + "";
        String lineSize = ModUtils.humanReadableByteCount(cachedMemory, true, true);
        String lineDownloaded = ModUtils.humanReadableByteCount(downloadedBytes, true, true);
        String lineSkipped = ModUtils.humanReadableByteCount(loadedBytes, true, true);
        return new String[]{lineAmount, lineSize, lineDownloaded, lineSkipped};
    }

    @Override
    public String[] getDefaultValues() {
        return this.getValues();
    }

    @Override
    public boolean isShown() {
        ChunkCachingProtocol ccp = LabyMod.getInstance().getChunkCachingProtocol();
        return ccp.isCachingSupported() || ave.A().m instanceof awv;
    }

    @Override
    public String[] getDefaultKeys() {
        return this.getKeys();
    }

    @Override
    public void loadSettings() {
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getControlName() {
        return "Chunk Caching Info";
    }

    @Override
    public String getSettingName() {
        return "chunkcaching";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public int getSortingId() {
        return 6;
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_INFO;
    }
}

