/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui.modules;

import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.moduletypes.SimpleModule;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.NumberElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.utils.Material;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;

public class AfkTimerModule
extends SimpleModule {
    private boolean afk;
    private String timer = "";
    private int currentCount = 0;
    private int currentTick = 0;
    private long lastMove;
    private long lastTimeAfk;
    private int lastMouseX;
    private int lastMouseY;
    private int idleSeconds = 20;

    @Override
    public String getDisplayName() {
        return "AFK";
    }

    @Override
    public String getDisplayValue() {
        return this.timer;
    }

    @Override
    public String getDefaultValue() {
        return "00:00";
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (LabyModCore.getMinecraft().getPlayer() == null || this.getEnabled().size() == 0) {
            this.currentCount = 0;
            this.timer = "";
            return;
        }
        int currentMouseX = Mouse.getX();
        int currentMouseY = Mouse.getY();
        long currentMillis = System.currentTimeMillis();
        if (this.lastMouseX != currentMouseX || this.lastMouseY != currentMouseY || LabyModCore.getMinecraft().getPlayer().ba != 0.0f || LabyModCore.getMinecraft().getPlayer().aZ != 0.0f || LabyModCore.getMinecraft().getPlayer().O != 0.0f) {
            if (this.afk) {
                this.afk = false;
                this.timer = ModColor.cl("c") + this.timer;
                this.lastTimeAfk = currentMillis;
            }
            this.lastMove = currentMillis;
        } else if (this.afk) {
            if (++this.currentTick >= 20) {
                this.currentTick = 0;
                ++this.currentCount;
                this.timer = ModUtils.parseTimer(this.currentCount);
            }
        } else if (currentMillis - this.lastMove >= (long)(1000 * this.idleSeconds)) {
            this.afk = true;
            this.currentCount = 0;
            this.timer = "00:00";
        }
        if (!this.afk && currentMillis - this.lastTimeAfk >= 5000L) {
            this.timer = "";
            this.currentCount = 0;
        }
        this.lastMouseX = currentMouseX;
        this.lastMouseY = currentMouseY;
    }

    @Override
    public void loadSettings() {
        this.idleSeconds = Integer.parseInt(this.getAttribute("idleSeconds", "20"));
        if (this.idleSeconds < 3) {
            this.idleSeconds = 3;
        }
    }

    @Override
    public void fillSubSettings(List<SettingsElement> settingsElements) {
        super.fillSubSettings(settingsElements);
        settingsElements.add(new NumberElement(this, new ControlElement.IconData(Material.WATCH), "Idle seconds", "idleSeconds").setRange(3, 1800));
    }

    @Override
    public ControlElement.IconData getIconData() {
        return this.getModuleIcon(this.getSettingName());
    }

    @Override
    public String getSettingName() {
        return "afk_timer";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public int getSortingId() {
        return 0;
    }

    @Override
    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_OTHER;
    }

    @Override
    public boolean isShown() {
        return !this.timer.isEmpty();
    }
}

