/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamegui;

import com.google.common.reflect.ClassPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.labymod.api.permissions.Permissions;
import net.labymod.core.LabyModCore;
import net.labymod.gui.ModGuiIngameMenu;
import net.labymod.gui.elements.ColorPicker;
import net.labymod.ingamegui.ModuleCategory;
import net.labymod.ingamegui.ModuleCategoryRegistry;
import net.labymod.ingamegui.ModuleConfig;
import net.labymod.ingamegui.ModuleConfigElement;
import net.labymod.ingamegui.ModuleGui;
import net.labymod.ingamegui.enums.EnumDisplayType;
import net.labymod.ingamegui.enums.EnumItemSlot;
import net.labymod.ingamegui.enums.EnumModuleAlignment;
import net.labymod.ingamegui.enums.EnumModuleRegion;
import net.labymod.ingamegui.modules.AfkTimerModule;
import net.labymod.ingamegui.modules.BiomeModule;
import net.labymod.ingamegui.modules.ClickTestModule;
import net.labymod.ingamegui.modules.ClockModule;
import net.labymod.ingamegui.modules.ComboModule;
import net.labymod.ingamegui.modules.CoordinatesModule;
import net.labymod.ingamegui.modules.DateModule;
import net.labymod.ingamegui.modules.EntityCountModule;
import net.labymod.ingamegui.modules.FModule;
import net.labymod.ingamegui.modules.FPSModule;
import net.labymod.ingamegui.modules.LavaTimerModule;
import net.labymod.ingamegui.modules.MemoryModule;
import net.labymod.ingamegui.modules.OnlinePlayersModule;
import net.labymod.ingamegui.modules.PingModule;
import net.labymod.ingamegui.modules.PotionEffectsModule;
import net.labymod.ingamegui.modules.RangeModule;
import net.labymod.ingamegui.modules.ScoreboardModule;
import net.labymod.ingamegui.modules.ServerAddressModule;
import net.labymod.ingamegui.modules.ServerInfoModule;
import net.labymod.ingamegui.modules.ServerSupportModule;
import net.labymod.ingamegui.modules.SpeedModule;
import net.labymod.ingamegui.modules.YouTubeRealTimeModule;
import net.labymod.ingamegui.modules.item.ArrowAmountModule;
import net.labymod.ingamegui.modules.item.BootsModule;
import net.labymod.ingamegui.modules.item.ChestplateModule;
import net.labymod.ingamegui.modules.item.HeldItemModule;
import net.labymod.ingamegui.modules.item.HelmetModule;
import net.labymod.ingamegui.modules.item.LeggingsModule;
import net.labymod.ingamegui.moduletypes.ItemModule;
import net.labymod.ingamegui.moduletypes.ResizeableModule;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.settings.DefaultElementsCreator;
import net.labymod.settings.LabyModModuleEditorGui;
import net.labymod.settings.elements.BooleanElement;
import net.labymod.settings.elements.ControlElement;
import net.labymod.settings.elements.SettingsElement;
import net.labymod.settings.elements.SliderElement;
import net.labymod.utils.Consumer;
import net.minecraftforge.common.MinecraftForge;

public abstract class Module {
    private static int lastRegisteredModuleId = -1;
    private static double lastLeft;
    private static double lastRight;
    private static double lastTop;
    private static double lastBottom;
    private static double prevWidth;
    private static double prevHeight;
    private static ModuleGui currentModuleGui;
    private static EnumDisplayType lastDrawnDisplayType;
    private static List<Module> moduleList;
    private static List<Module> registerQueue;
    private static Map<String, Module> modulesByOverlistedModules;
    public static final ave mc;
    public static long lastTablistRendered;
    private ModuleConfigElement moduleConfigElement;
    private Set<EnumDisplayType> enabled;
    private EnumModuleRegion[] regions = new EnumModuleRegion[]{EnumModuleRegion.TOP_LEFT, EnumModuleRegion.TOP_LEFT};
    private double[] x = new double[]{0.0, 0.0};
    private double[] y = new double[]{0.0, 0.0};
    private double lastX;
    private double lastY;
    private boolean lastCenter;
    private boolean lastRightBound;
    private String listedAfter;
    private Map<String, String> attributes;
    private int id;
    private String moduleName = null;
    protected boolean backgroundVisible = false;
    protected int backgroundColor = Integer.MIN_VALUE;
    protected int backgroundTransparency = 50;
    protected int padding = 0;
    public BooleanElement rawBooleanElement;

    public static void registerModule(Module module, boolean loadConfigValues) {
        module.setId(++lastRegisteredModuleId);
        MinecraftForge.EVENT_BUS.register(module);
        registerQueue.add(module);
        if (LabyModCore.getMinecraft().getWorld() == null) {
            Module.handleRegisterQueue();
        }
        if (loadConfigValues) {
            ModuleConfig.loadModule(module);
        }
    }

    private static void handleRegisterQueue() {
        if (!registerQueue.isEmpty()) {
            moduleList.addAll(registerQueue);
            registerQueue.clear();
        }
    }

    public static void draw(double left, double top, double right, double bottom, EnumDisplayType displayType, boolean scaling) {
        boolean isShown;
        double scale;
        bfl.E();
        bfl.b((double)0.0, (double)0.0, (double)(lastTablistRendered + 20L >= System.currentTimeMillis() ? -0.1 : 1.0));
        if (scaling && (scale = 2.0 - (double)ModuleConfig.getConfig().getGuiScale() / 100.0) != 1.0) {
            bfl.a((double)(1.0 / scale), (double)(1.0 / scale), (double)1.0);
            left *= scale;
            right *= scale;
            top *= scale;
            bottom *= scale;
        }
        lastDrawnDisplayType = displayType;
        lastLeft = left;
        lastRight = right;
        lastTop = top;
        lastBottom = bottom;
        double screenCenter = Module.getLastLeft() + (Module.getLastRight() - Module.getLastLeft()) / 2.0;
        Module.checkResizeAllModules();
        if (!ModuleConfig.getConfig().isModulesEnabled()) {
            bfl.F();
            return;
        }
        Module.handleRegisterQueue();
        boolean itemSlotGravity = ModuleConfig.getConfig().isItemSlotGravity() && (Module.getCurrentModuleGui() == null || !Module.getCurrentModuleGui().isShowAllModules());
        HashSet<Byte> takenItemSlots = null;
        if (itemSlotGravity) {
            Collections.sort(moduleList, new Comparator<Module>(){

                @Override
                public int compare(Module o1, Module o2) {
                    return o1 instanceof ItemModule && o2 instanceof ItemModule ? Integer.valueOf(((ItemModule)o2).getItemSlot().ordinal()).compareTo(((ItemModule)o1).getItemSlot().ordinal()) : Integer.valueOf(o1.getId()).compareTo(o2.getId());
                }
            });
            takenItemSlots = new HashSet<Byte>(EnumItemSlot.values().length);
            for (Module module : moduleList) {
                EnumItemSlot itemSlot;
                if (!(module instanceof ItemModule) || module.getListedAfter() != null && displayType != EnumDisplayType.ESCAPE) continue;
                boolean bl = isShown = (module.isShown() || Module.getCurrentModuleGui() != null && Module.getCurrentModuleGui().isShowAllModules()) && module.getCategory().isEnabled();
                if (!module.isEnabled(displayType) || !isShown || (itemSlot = ((ItemModule)module).getItemSlot()) == null || itemSlot == EnumItemSlot.NONE) continue;
                takenItemSlots.add((byte)itemSlot.ordinal());
            }
        }
        for (Module module : moduleList) {
            if (module.getListedAfter() != null && displayType != EnumDisplayType.ESCAPE) continue;
            boolean bl = isShown = (module.isShown() || Module.getCurrentModuleGui() != null && Module.getCurrentModuleGui().isShowAllModules()) && module.getCategory().isEnabled();
            if (ave.A().m != null && ave.A().m instanceof ColorPicker.AdvancedColorSelectorGui) {
                isShown = true;
            }
            double x = module.getRegion(displayType.ordinal()).getMinecraftX(module.getX(displayType.ordinal()), left, right);
            double y = module.getRegion(displayType.ordinal()).getMinecraftY(module.getY(displayType.ordinal()), top, bottom);
            if (x > Module.getLastRight()) {
                x = Module.getLastRight();
            }
            if (y < Module.getLastTop()) {
                y = Module.getLastTop();
            }
            boolean rightBound = module.isRightBound(displayType);
            boolean inItemSlot = false;
            boolean inScoreboardSlot = false;
            if (module.isEnabled(displayType) && isShown) {
                double scale2;
                boolean inCenter;
                double width = module.getWidth();
                double moduleX = Math.max(Module.getLastLeft(), Math.min(rightBound ? x - width : x, Module.getLastRight()));
                boolean isItemModule = false;
                EnumItemSlot itemSlot = null;
                int scoreboardSlot = -1;
                isItemModule = module instanceof ItemModule;
                if (isItemModule) {
                    itemSlot = ((ItemModule)module).getItemSlot();
                    if (itemSlot != null && itemSlot != EnumItemSlot.NONE) {
                        if (itemSlotGravity) {
                            EnumItemSlot prevSlot = itemSlot;
                            EnumItemSlot[] alternativeSlots = itemSlot.getAlternativeSlots();
                            if (alternativeSlots != null) {
                                for (EnumItemSlot alternativeSlot : alternativeSlots) {
                                    if (takenItemSlots.contains((byte)alternativeSlot.ordinal())) continue;
                                    itemSlot = alternativeSlot;
                                }
                            }
                            if (itemSlot != prevSlot) {
                                takenItemSlots.remove((byte)prevSlot.ordinal());
                            }
                            takenItemSlots.add((byte)itemSlot.ordinal());
                        }
                        moduleX = itemSlot.getX(Module.getLastRight() - Module.getLastLeft()) + Module.getLastLeft();
                        y = itemSlot.getY(Module.getLastBottom() - Module.getLastTop()) + Module.getLastTop();
                        inItemSlot = true;
                    } else {
                        itemSlot = null;
                    }
                }
                if (module instanceof ScoreboardModule && (scoreboardSlot = ((ScoreboardModule)module).getSlot()) != -1) {
                    inScoreboardSlot = true;
                }
                boolean bl2 = inCenter = Math.abs(screenCenter - (moduleX + width / 2.0)) < 3.0;
                if (!(module instanceof ResizeableModule || inCenter || !module.isLastCenter() || Module.getCurrentModuleGui() != null && module.equals(Module.getCurrentModuleGui().getDraggingModule()))) {
                    inCenter = true;
                    moduleX = screenCenter - width / 2.0;
                    module.setX(displayType.ordinal(), module.getRegion(displayType.ordinal()).getOffsetX(moduleX, Module.getLastLeft(), Module.getLastRight()));
                    module.getModuleConfigElement().setX(displayType.ordinal(), module.getX(displayType.ordinal()));
                    ModuleConfig.getConfigManager().save();
                }
                module.setLastX(moduleX);
                module.setLastY(y);
                module.setLastCenter(inCenter);
                module.setLastRightBound(rightBound);
                double tX = module.getLastX();
                double tY = y;
                double tRight = rightBound ? moduleX + width : -1.0;
                bfl.E();
                if (inItemSlot) {
                    scale2 = scaling ? 2.0 - (double)ModuleConfig.getConfig().getGuiScale() / 100.0 : 1.0;
                    bfl.a((double)(1.0 * scale2), (double)(1.0 * scale2), (double)1.0);
                    tX = itemSlot.getX(Module.getLastRight() / scale2 - Module.getLastLeft() / scale2) + Module.getLastLeft() / scale2;
                    tY = itemSlot.getY(Module.getLastBottom() / scale2 - Module.getLastTop() / scale2) + Module.getLastTop() / scale2;
                }
                if (inScoreboardSlot) {
                    switch (scoreboardSlot) {
                        case 0: {
                            tX = Module.getLastRight() - module.getWidth() - 1.0;
                            tY = Module.getLastTop() + (Module.getLastBottom() - Module.getLastTop()) / 2.0 - module.getHeight() / 2.0;
                            break;
                        }
                        case 1: {
                            tX = Module.getLastLeft() + 1.0;
                            tY = Module.getLastTop() + (Module.getLastBottom() - Module.getLastTop()) / 2.0 - module.getHeight() / 2.0;
                        }
                    }
                }
                if (displayType == EnumDisplayType.ESCAPE && tY + module.getHeight() > lastBottom) {
                    tY += lastBottom - (tY + module.getHeight());
                    module.setY(displayType.ordinal(), module.getRegion(displayType.ordinal()).getOffsetY(tY, Module.getLastTop(), Module.getLastBottom()));
                }
                bfl.E();
                if (module.supportsRescale()) {
                    module.applyScale(true);
                    tX = module.scaleModuleSize(tX, true);
                    tY = module.scaleModuleSize(tY, true);
                    if (rightBound) {
                        tRight = module.scaleModuleSize(tRight, true);
                    }
                }
                if (!isItemModule) {
                    module.draw(tX, tY, tRight);
                } else {
                    ((ItemModule)module).draw(tX, tY, tRight, itemSlot);
                }
                if (inItemSlot || inScoreboardSlot) {
                    scale2 = scaling ? 2.0 - (double)ModuleConfig.getConfig().getGuiScale() / 100.0 : 1.0;
                    bfl.a((double)(1.0 / scale2), (double)(1.0 / scale2), (double)1.0);
                }
                bfl.F();
                bfl.F();
                y += module.getHeight();
            }
            String currentModule = module.getName();
            if (displayType == EnumDisplayType.ESCAPE || !modulesByOverlistedModules.containsKey(currentModule)) continue;
            double width = module.getWidth();
            double moduleX = Math.max(Module.getLastLeft(), Math.min(rightBound ? x - width : x, Module.getLastRight()));
            while (displayType != EnumDisplayType.ESCAPE && modulesByOverlistedModules.containsKey(currentModule)) {
                Module listedAfter = modulesByOverlistedModules.get(currentModule);
                boolean bl3 = isShown = (listedAfter.isShown() || Module.getCurrentModuleGui() != null && Module.getCurrentModuleGui().isShowAllModules()) && listedAfter.getCategory().isEnabled();
                if (listedAfter.isEnabled(displayType) && isShown) {
                    width = listedAfter.getWidth();
                    moduleX = Math.max(Module.getLastLeft(), Math.min(rightBound ? x - width : x, Module.getLastRight()));
                    listedAfter.setLastX(moduleX);
                    listedAfter.setLastY(y);
                    listedAfter.setLastRightBound(rightBound);
                    double tRight = rightBound ? moduleX + width : -1.0;
                    bfl.E();
                    double mY = y;
                    if (listedAfter.supportsRescale()) {
                        listedAfter.applyScale(true);
                        moduleX = listedAfter.scaleModuleSize(moduleX, true);
                        mY = listedAfter.scaleModuleSize(y, true);
                        if (rightBound) {
                            tRight = listedAfter.scaleModuleSize(tRight, true);
                        }
                    }
                    listedAfter.draw(moduleX, mY, tRight);
                    bfl.F();
                    y += listedAfter.getHeight() + (double)listedAfter.getSpacing();
                }
                listedAfter.setLastCenter(false);
                currentModule = listedAfter.getName();
            }
        }
        bfl.F();
    }

    protected boolean supportsRescale() {
        return false;
    }

    public static boolean isDrawn() {
        if (ave.A().m instanceof ModGuiIngameMenu || ave.A().m instanceof LabyModModuleEditorGui) {
            return true;
        }
        if (ave.A().t.aC) {
            return false;
        }
        return Permissions.isAllowed(Permissions.Permission.GUI_ALL);
    }

    public static Module getModuleByName(String name) {
        for (Module module : Module.getModules()) {
            if (!module.getName().equalsIgnoreCase(name)) continue;
            return module;
        }
        return null;
    }

    public static Module getModuleByClass(Class<?> clazz) {
        for (Module module : Module.getModules()) {
            if (!module.getClass().equals(clazz)) continue;
            return module;
        }
        return null;
    }

    public static Map<String, Module> getModulesByOverlistedModules() {
        return modulesByOverlistedModules;
    }

    public static ModuleGui getCurrentModuleGui() {
        return currentModuleGui;
    }

    public static void setCurrentModuleGui(ModuleGui currentModuleGui) {
        Module.currentModuleGui = currentModuleGui;
    }

    public static void checkResizeAllModules() {
        double w = Module.getLastRight() - Module.getLastLeft();
        double h = Module.getLastTop() - Module.getLastBottom();
        if (prevWidth != -1.0 && prevHeight != -1.0 && (prevWidth != w || prevHeight != h)) {
            for (Module module : Module.getModules()) {
                module.onResize(w, h, prevWidth, prevHeight);
            }
            prevWidth = w;
            prevHeight = h;
        } else {
            prevWidth = w;
            prevHeight = h;
        }
    }

    public static List<Module> getModules() {
        return moduleList;
    }

    public static double getLastLeft() {
        return lastLeft;
    }

    public static double getLastRight() {
        return lastRight;
    }

    public static double getLastTop() {
        return lastTop;
    }

    public static double getLastBottom() {
        return lastBottom;
    }

    @Deprecated
    public void draw(int x, int y, int rightX) {
    }

    public void draw(double x, double y, double rightX) {
        this.draw((int)Math.round(x), (int)Math.round(y), (int)Math.round(rightX));
    }

    public String getName() {
        return this.moduleName == null ? (this.moduleName = this.getClass().getSimpleName()) : this.moduleName;
    }

    public void init() {
        try {
            this.loadSettings();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public EnumDisplayType[] getDisplayTypes() {
        return new EnumDisplayType[]{EnumDisplayType.INGAME};
    }

    public void createSettingElement() {
        String displayName = this.getControlName();
        this.rawBooleanElement = new BooleanElement(this, this.getIconData(), displayName, "enabled");
        if (this.rawBooleanElement.getDisplayName() == null || !this.rawBooleanElement.getDisplayName().equals(displayName)) {
            this.rawBooleanElement.setDisplayName(displayName);
        }
        this.rawBooleanElement.setSortingId(this.getSortingId());
        ArrayList<SettingsElement> subList = new ArrayList<SettingsElement>();
        this.fillSubSettings(subList);
        this.rawBooleanElement.getSubSettings().addAll(subList);
    }

    public String getControlName() {
        String settingName = this.getSettingName();
        String key = "module_" + settingName;
        String translated = LanguageManager.translateOrReturnKey(key, new Object[0]);
        return translated.equals(key) ? key : translated;
    }

    public void settingUpdated(boolean enabled) {
    }

    public void fillSubSettings(List<SettingsElement> settingsElements) {
        String displayUseDefault = LanguageManager.translate("use_default_option");
        BooleanElement useDefaultElement = new BooleanElement(displayUseDefault, new ControlElement.IconData(ModTextures.SETTINGS_DEFAULT_USE_DEFAULT_SETTINGS), new Consumer<Boolean>(){

            @Override
            public void accept(Boolean value) {
                Module.this.getModuleConfigElement().setUseExtendedSettings(value == false);
                Module.this.init();
            }
        }, !this.getModuleConfigElement().isUsingExtendedSettings());
        settingsElements.add(useDefaultElement);
        if (this.supportsRescale()) {
            String displayScale = LanguageManager.translate("module_scale");
            SliderElement scaleElement = new SliderElement(displayScale, new ControlElement.IconData(ModTextures.SETTINGS_DEFAULT_GUI_SCALING), this.getModuleConfigElement().getScale());
            scaleElement.addCallback(new Consumer<Integer>(){

                @Override
                public void accept(Integer value) {
                    Module.this.getModuleConfigElement().setScale(value);
                    Module.this.init();
                }
            });
            scaleElement.setRange(50, 150).setSteps(5);
            settingsElements.add(scaleElement);
        }
        DefaultElementsCreator.createAlignment(this, false, settingsElements);
    }

    public String getAttribute(String attribute, String defaultValue) {
        String attr = this.getAttributes().get(attribute);
        String value = defaultValue;
        if (attr == null) {
            this.getAttributes().put(attribute, defaultValue);
        } else {
            value = attr;
        }
        return value;
    }

    public void setAttribute(String attribute, String value) {
        this.getAttributes().put(attribute, value);
    }

    public BooleanElement getBooleanElement() {
        if (this.rawBooleanElement == null) {
            this.createSettingElement();
        }
        return this.rawBooleanElement;
    }

    public void setBooleanElement(BooleanElement booleanElement) {
        this.rawBooleanElement = booleanElement;
    }

    protected void applyScale(boolean enabled) {
        double scale = (double)this.moduleConfigElement.getScale() / 100.0;
        double value = enabled ? scale : 1.0 / scale;
        bfl.a((double)value, (double)value, (double)1.0);
    }

    protected double scaleModuleSize(double value, boolean divide) {
        double scale = (double)this.moduleConfigElement.getScale() / 100.0;
        return divide ? value / scale : value * scale;
    }

    public abstract ControlElement.IconData getIconData();

    public boolean isShown() {
        return true;
    }

    public boolean isMovable(int mouseX, int mouseY) {
        return true;
    }

    public void initModuleGui(ModuleGui moduleGui) {
    }

    public ModuleCategory getCategory() {
        return ModuleCategoryRegistry.CATEGORY_OTHER;
    }

    public abstract double getHeight();

    public abstract double getWidth();

    public ModuleConfigElement getModuleConfigElement() {
        return this.moduleConfigElement;
    }

    public ModuleConfigElement setModuleConfigElement(ModuleConfigElement moduleConfigElement) {
        this.moduleConfigElement = moduleConfigElement;
        if (moduleConfigElement.getListedAfter() != null) {
            modulesByOverlistedModules.put(moduleConfigElement.getListedAfter(), this);
        }
        return moduleConfigElement;
    }

    public Set<EnumDisplayType> getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Set<EnumDisplayType> enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled(EnumDisplayType displayType) {
        return this.getEnabled() != null && this.getEnabled().contains((Object)displayType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRightBound(EnumDisplayType displayType) {
        EnumModuleAlignment alignment = this.getModuleConfigElement().getAlignment(displayType.ordinal()) == EnumModuleAlignment.DEFAULT || !this.getModuleConfigElement().isUsingExtendedSettings() ? ModuleConfig.getConfig().getDefaultAlignment() : this.getModuleConfigElement().getAlignment(displayType.ordinal());
        EnumModuleRegion region = this.getRegion(displayType.ordinal());
        if (this.getListedAfter() == null && alignment == EnumModuleAlignment.AUTO) {
            if (region.getHorizontalPosition() == 2) {
                if (this.getX(displayType.ordinal()) > 0.0) return true;
            }
            if (region.getHorizontalPosition() == 3) {
                return true;
            }
        } else if (alignment == EnumModuleAlignment.RIGHT) return true;
        if (this.getListedAfter() == null) return false;
        if (!this.lastRightBound) return false;
        return true;
    }

    public void onMouseClick(int mouseX, int mouseY, int mouseButton) {
    }

    public void onMouseMove(int mouseX, int mouseY, int mouseButton) {
    }

    public void onMouseRelease(int mouseX, int mouseY, int mouseButton) {
    }

    public void onMouseScroll(int mouseX, int mouseY) {
    }

    public void onKeyType(char charType, int keyCode) {
    }

    public String getListedAfter() {
        return this.listedAfter;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public EnumModuleRegion getRegion(int index) {
        return this.regions[index];
    }

    public double getX(int index) {
        return this.x[index];
    }

    public double getY(int index) {
        return this.y[index];
    }

    public void setListedAfter(String listedAfter) {
        this.listedAfter = listedAfter;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setRegion(int index, EnumModuleRegion region) {
        this.regions[index] = region;
    }

    public void setRegions(EnumModuleRegion[] regions) {
        this.regions = regions;
    }

    public void setX(int index, double x) {
        this.x[index] = x;
    }

    public void setX(double[] x) {
        this.x = x;
    }

    public void setY(int index, double y) {
        this.y[index] = y;
    }

    public void setY(double[] y) {
        this.y = y;
    }

    public void onResize(double width, double height, double prevWidth, double prevHeight) {
    }

    public abstract void loadSettings();

    protected ControlElement.IconData getModuleIcon(String name) {
        return new ControlElement.IconData(new jy("labymod/textures/settings/modules/" + name + ".png"));
    }

    protected ControlElement.IconData getModuleIcon(String name, String subSetting) {
        return new ControlElement.IconData(new jy("labymod/textures/settings/modules/" + name + "_" + subSetting + ".png"));
    }

    protected int getSpacing() {
        return 2;
    }

    public abstract String getSettingName();

    public abstract String getDescription();

    public abstract int getSortingId();

    public static EnumDisplayType getLastDrawnDisplayType() {
        return lastDrawnDisplayType;
    }

    public static void setLastDrawnDisplayType(EnumDisplayType lastDrawnDisplayType) {
        Module.lastDrawnDisplayType = lastDrawnDisplayType;
    }

    public double getLastX() {
        return this.lastX;
    }

    public void setLastX(double lastX) {
        this.lastX = lastX;
    }

    public double getLastY() {
        return this.lastY;
    }

    public void setLastY(double lastY) {
        this.lastY = lastY;
    }

    public boolean isLastCenter() {
        return this.lastCenter;
    }

    public void setLastCenter(boolean lastCenter) {
        this.lastCenter = lastCenter;
    }

    public boolean isLastRightBound() {
        return this.lastRightBound;
    }

    public void setLastRightBound(boolean lastRightBound) {
        this.lastRightBound = lastRightBound;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setRawBooleanElement(BooleanElement rawBooleanElement) {
        this.rawBooleanElement = rawBooleanElement;
    }

    static {
        prevWidth = -1.0;
        prevHeight = -1.0;
        lastDrawnDisplayType = EnumDisplayType.INGAME;
        moduleList = new ArrayList<Module>();
        registerQueue = new ArrayList<Module>();
        modulesByOverlistedModules = new HashMap<String, Module>();
        mc = ave.A();
        lastTablistRendered = 0L;
        boolean noModulesFound = true;
        try {
            for (ClassPath.ClassInfo classInfo : ClassPath.from((ClassLoader)Module.class.getClassLoader()).getTopLevelClassesRecursive("net.labymod.ingamegui.modules")) {
                Module module = (Module)classInfo.load().newInstance();
                Module.registerModule(module, false);
                noModulesFound = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            noModulesFound = true;
        }
        try {
            if (noModulesFound) {
                for (Class moduleClass : new Class[]{AfkTimerModule.class, BiomeModule.class, ClickTestModule.class, ClockModule.class, ComboModule.class, CoordinatesModule.class, DateModule.class, EntityCountModule.class, FModule.class, FPSModule.class, LavaTimerModule.class, MemoryModule.class, OnlinePlayersModule.class, PingModule.class, PotionEffectsModule.class, RangeModule.class, ScoreboardModule.class, ServerAddressModule.class, ServerInfoModule.class, ServerSupportModule.class, SpeedModule.class, YouTubeRealTimeModule.class, ArrowAmountModule.class, BootsModule.class, ChestplateModule.class, HeldItemModule.class, HelmetModule.class, LeggingsModule.class}) {
                    Module module = (Module)moduleClass.newInstance();
                    Module.registerModule(module, false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

