/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamechat.tabs;

import java.io.IOException;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ModTextField;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.ingamechat.GuiChatCustom;
import net.labymod.ingamechat.tools.playermenu.PlayerMenu;
import net.labymod.main.LabyMod;
import net.labymod.main.lang.LanguageManager;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.manager.TooltipHelper;

public class GuiChatPlayerMenu
extends GuiChatCustom {
    private final int windowWidth = 148;
    private final int windowHeight = 194;
    private Scrollbar scrollbar = new Scrollbar(10);
    private PlayerMenu.PlayerMenuEntry openPlayerMenuEntry = null;
    private PlayerMenu.PlayerMenuEntry hoverPlayerMenuEntry = null;
    private boolean hoverSendInstantlyCheckbox = false;
    private boolean hoverAddButton = false;
    private boolean hoverCancelButton = false;
    private boolean hoverSaveButton = false;
    private boolean hoverDeleteButton = false;
    private ModTextField fieldDisplayName;
    private ModTextField fieldCommand;
    private boolean canHighlightRed = false;

    public GuiChatPlayerMenu(String defaultText) {
        super(defaultText);
    }

    @Override
    public void b() {
        super.b();
        this.fieldDisplayName = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, 0, 10);
        this.fieldCommand = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, 0, 10);
        this.fieldDisplayName.setEnableBackgroundDrawing(false);
        this.fieldCommand.setEnableBackgroundDrawing(false);
        this.fieldDisplayName.setMaxStringLength(120);
        this.fieldCommand.setMaxStringLength(120);
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTicks) {
        super.a(mouseX, mouseY, partialTicks);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int margin = 2;
        int chatHeight = 16;
        int x = draw.getWidth() - this.windowWidth - margin;
        int y = draw.getHeight() - this.windowHeight - chatHeight;
        DrawUtils.a((int)x, (int)y, (int)(x + this.windowWidth), (int)(y + this.windowHeight), (int)Integer.MIN_VALUE);
        draw.drawString(LanguageManager.translate("ingame_chat_tab_playermenu"), x, y - 10);
        this.hoverPlayerMenuEntry = null;
        this.hoverDeleteButton = false;
        List<PlayerMenu.PlayerMenuEntry> playerMenuEntries = LabyMod.getInstance().getChatToolManager().getPlayerMenu();
        this.scrollbar.setPosition(draw.getWidth() - margin - 1, y + margin, draw.getWidth() - margin, draw.getHeight() - chatHeight - margin);
        this.scrollbar.update(playerMenuEntries.size());
        int listPadding = 2;
        int listX = x + listPadding;
        double listY = (double)(y + listPadding) + this.scrollbar.getScrollY();
        for (PlayerMenu.PlayerMenuEntry playerMenuComponent : playerMenuEntries) {
            if (listY >= (double)y && listY < (double)(draw.getHeight() - chatHeight - listPadding)) {
                boolean hoverDeleteButton;
                boolean hover = draw.drawRect(mouseX, mouseY, listX - listPadding, listY, listX - listPadding + this.windowWidth, listY + 10.0, 0, ModColor.toRGB(100, 200, 200, 100));
                String displayName = playerMenuComponent.getDisplayName();
                draw.drawString(displayName, listX, listY + 1.0);
                boolean bl = hoverDeleteButton = hover && mouseX > listX - listPadding + this.windowWidth - 10;
                if (hover) {
                    draw.drawRightString(ModColor.cl(hoverDeleteButton ? (char)'c' : '4') + "\u2718", listX - listPadding + this.windowWidth, listY + 1.0);
                }
                if (hover) {
                    this.hoverPlayerMenuEntry = playerMenuComponent;
                    this.hoverDeleteButton = hoverDeleteButton;
                }
            }
            listY += 10.0;
        }
        this.scrollbar.draw();
        if (this.openPlayerMenuEntry == null) {
            int buttonSize = 14;
            int buttonMargin = 2;
            this.hoverAddButton = draw.drawRect(mouseX, mouseY, (this.hoverAddButton ? ModColor.cl('a') : "") + "+", x - buttonSize - buttonMargin, y, x - buttonMargin, y + buttonSize, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.hoverSaveButton = false;
            this.hoverCancelButton = false;
        } else {
            int editorWidth = 130;
            int editorMargin = 2;
            int editorPadding = 2;
            int editorYIndex = y + editorPadding;
            DrawUtils.a((int)(x - editorWidth - editorMargin), (int)y, (int)(x - editorMargin), (int)(y + this.windowHeight), (int)Integer.MIN_VALUE);
            draw.drawString(LanguageManager.translate("chat_playermenu_displayname") + ":", x - editorWidth + editorPadding - editorMargin, editorYIndex);
            this.fieldDisplayName.width = editorWidth - editorPadding * 2;
            this.fieldDisplayName.xPosition = x - editorWidth + editorPadding - editorMargin;
            this.fieldDisplayName.yPosition = (editorYIndex += 10) + 1;
            int fieldplayerMenuColor = this.canHighlightRed && this.fieldDisplayName.getText().isEmpty() ? ModColor.toRGB(200, 100, 100, 200) : Integer.MAX_VALUE;
            DrawUtils.a((int)(x - editorWidth + editorPadding - editorMargin), (int)editorYIndex, (int)(x - editorPadding - editorMargin), (int)(editorYIndex + 10), (int)fieldplayerMenuColor);
            this.fieldDisplayName.drawTextBox();
            draw.drawString(LanguageManager.translate("chat_playermenu_command") + ":", x - editorWidth + editorPadding - editorMargin, editorYIndex += 15);
            this.fieldCommand.width = editorWidth - editorPadding * 2;
            this.fieldCommand.xPosition = x - editorWidth + editorPadding - editorMargin;
            this.fieldCommand.yPosition = (editorYIndex += 10) + 1;
            int fieldReplacementColor = this.canHighlightRed && this.fieldCommand.getText().isEmpty() ? ModColor.toRGB(200, 100, 100, 200) : Integer.MAX_VALUE;
            DrawUtils.a((int)(x - editorWidth + editorPadding - editorMargin), (int)editorYIndex, (int)(x - editorPadding - editorMargin), (int)(editorYIndex + 10), (int)fieldReplacementColor);
            this.fieldCommand.drawTextBox();
            editorYIndex += 13;
            if (mouseX > this.fieldCommand.xPosition && mouseX < this.fieldCommand.xPosition + this.fieldCommand.width && mouseY > this.fieldCommand.yPosition && mouseY < this.fieldCommand.yPosition + this.fieldCommand.height) {
                TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, LanguageManager.translate("chat_playermenu_tooltip"));
            }
            this.hoverSendInstantlyCheckbox = this.drawElementCheckBox("sendinstantly", this.openPlayerMenuEntry.isSendInstantly(), x - editorWidth + editorPadding - editorMargin, editorYIndex + 1, mouseX, mouseY);
            editorYIndex += 15;
            int buttonHeight = 12;
            this.hoverCancelButton = draw.drawRect(mouseX, mouseY, LanguageManager.translate("button_cancel"), x - editorWidth + editorPadding - editorMargin, y + this.windowHeight - editorPadding - buttonHeight, x - editorWidth + editorPadding - editorMargin + editorWidth / 2 - editorPadding, y + this.windowHeight - editorPadding, Integer.MAX_VALUE, ModColor.toRGB(200, 100, 100, 200));
            this.hoverSaveButton = draw.drawRect(mouseX, mouseY, LanguageManager.translate("button_save"), x - editorWidth + editorPadding - editorMargin + editorWidth / 2 + editorPadding, y + this.windowHeight - editorPadding - buttonHeight, x - editorMargin - editorPadding, y + this.windowHeight - editorPadding, Integer.MAX_VALUE, ModColor.toRGB(100, 200, 100, 200));
            this.hoverAddButton = false;
        }
    }

    @Override
    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        if (this.hoverAddButton && mouseButton == 0) {
            this.openPlayerMenuEntry = new PlayerMenu.PlayerMenuEntry("", "", true);
            this.canHighlightRed = false;
            this.fieldDisplayName.setText("");
            this.fieldCommand.setText("");
        }
        if (this.hoverPlayerMenuEntry != null && mouseButton == 0) {
            if (this.hoverDeleteButton) {
                List<PlayerMenu.PlayerMenuEntry> entries = LabyMod.getInstance().getChatToolManager().getPlayerMenu();
                entries.remove(this.hoverPlayerMenuEntry);
                if (this.hoverPlayerMenuEntry == this.openPlayerMenuEntry) {
                    this.openPlayerMenuEntry = null;
                }
                LabyMod.getInstance().getChatToolManager().saveTools();
            } else {
                this.openPlayerMenuEntry = this.hoverPlayerMenuEntry;
                this.canHighlightRed = false;
                this.fieldDisplayName.setText(this.openPlayerMenuEntry.getDisplayName());
                this.fieldCommand.setText(this.openPlayerMenuEntry.getCommand());
            }
        }
        if (this.hoverCancelButton && mouseButton == 0) {
            this.openPlayerMenuEntry = null;
        }
        if (this.hoverSaveButton && mouseButton == 0) {
            String playerMenu = this.fieldDisplayName.getText();
            String replacement = this.fieldCommand.getText();
            if (playerMenu.isEmpty() || replacement.isEmpty()) {
                this.canHighlightRed = true;
                return;
            }
            this.canHighlightRed = false;
            this.openPlayerMenuEntry.setDisplayName(this.fieldDisplayName.getText());
            this.openPlayerMenuEntry.setCommand(this.fieldCommand.getText());
            List<PlayerMenu.PlayerMenuEntry> entries = LabyMod.getInstance().getChatToolManager().getPlayerMenu();
            if (!entries.contains(this.openPlayerMenuEntry)) {
                entries.add(this.openPlayerMenuEntry);
            }
            this.openPlayerMenuEntry = null;
            LabyMod.getInstance().getChatToolManager().saveTools();
        }
        if (this.openPlayerMenuEntry != null) {
            this.fieldDisplayName.mouseClicked(mouseX, mouseY, mouseButton);
            this.fieldCommand.mouseClicked(mouseX, mouseY, mouseButton);
            if (this.hoverSendInstantlyCheckbox) {
                this.openPlayerMenuEntry.setSendInstantly(!this.openPlayerMenuEntry.isSendInstantly());
            }
        }
    }

    private boolean drawElementCheckBox(String text, boolean check, int x, int y, int mouseX, int mouseY) {
        String displayText = LanguageManager.translate("chat_playermenu_" + text) + ":";
        LabyMod.getInstance().getDrawUtils().drawString(displayText, x + 2, y + 2, 0.7);
        boolean hover = mouseX > x + 3 && mouseX < x + 12 && mouseY > (y += 10) + 1 && mouseY < y + 10;
        GuiChatPlayerMenu.a((int)(x + 3), (int)(y + 1), (int)(x + 12), (int)(y + 10), (int)(hover ? 2147483547 : Integer.MAX_VALUE));
        if (!check) {
            return hover;
        }
        this.a(LabyModCore.getMinecraft().getFontRenderer(), ModColor.cl("a") + "\u2714", x + 8, y + 1, Integer.MAX_VALUE);
        return hover;
    }

    @Override
    protected void a(char typedChar, int keyCode) throws IOException {
        if (this.openPlayerMenuEntry != null) {
            this.fieldDisplayName.textboxKeyTyped(typedChar, keyCode);
            this.fieldCommand.textboxKeyTyped(typedChar, keyCode);
            if (keyCode == 15) {
                if (this.fieldDisplayName.isFocused()) {
                    this.fieldDisplayName.setFocused(false);
                    this.fieldCommand.setFocused(true);
                } else {
                    this.fieldDisplayName.setFocused(true);
                    this.fieldCommand.setFocused(false);
                }
            }
            if (keyCode == 1) {
                super.a(typedChar, keyCode);
            }
        } else {
            super.a(typedChar, keyCode);
        }
    }

    @Override
    protected void b(int mouseX, int mouseY, int state) {
        super.b(mouseX, mouseY, state);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
    }

    @Override
    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
    }

    @Override
    public void k() throws IOException {
        super.k();
        this.scrollbar.mouseInput();
    }

    public void e() {
        if (this.openPlayerMenuEntry != null) {
            this.fieldDisplayName.updateCursorCounter();
            this.fieldCommand.updateCursorCounter();
        }
    }
}

