/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.ingamechat.tabs;

import java.io.IOException;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ModTextField;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.ingamechat.GuiChatCustom;
import net.labymod.ingamechat.namehistory.NameHistory;
import net.labymod.ingamechat.namehistory.NameHistoryUtil;
import net.labymod.main.LabyMod;
import net.labymod.main.lang.LanguageManager;
import net.labymod.utils.Consumer;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModUtils;
import net.labymod.utils.UUIDFetcher;

public class GuiChatNameHistory
extends GuiChatCustom {
    private final int windowWidth = 160;
    private final int windowHeight = 16;
    private final int entryHeight = 11;
    private final int maxEntries = 10;
    private Scrollbar scrollbar = new Scrollbar(this.entryHeight);
    private ModTextField fieldSearch;
    private boolean hoverSearchButton = false;
    private NameHistory nameHistory;
    private boolean lastSearchNotFound = false;
    private String forceNameSearch = null;
    private boolean hoverLabyNet = false;

    public GuiChatNameHistory(String defaultText) {
        super(defaultText);
    }

    public GuiChatNameHistory(String defaultText, String username) {
        super(defaultText);
        this.forceNameSearch = username;
    }

    @Override
    public void b() {
        super.b();
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        double buttonWidth = (double)draw.getStringWidth(LanguageManager.translate("button_search")) * 0.7 + 4.0;
        this.fieldSearch = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, (int)((double)this.windowWidth - buttonWidth), this.windowHeight);
        this.fieldSearch.setEnableBackgroundDrawing(false);
        this.fieldSearch.setMaxStringLength(16);
        this.fieldSearch.setFocused(true);
        this.scrollbar.setSpeed(this.entryHeight);
        this.scrollbar.init();
        if (this.forceNameSearch != null) {
            this.fieldSearch.setText(this.forceNameSearch);
            this.fieldSearch.setFocused(true);
            this.fieldSearch.setCursorPositionEnd();
            this.doNameSearch(this.forceNameSearch);
            this.forceNameSearch = null;
        }
    }

    @Override
    public void a(int mouseX, int mouseY, float partialTicks) {
        super.a(mouseX, mouseY, partialTicks);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int x = this.l - 2 - this.windowWidth;
        double y = this.m - 16 - this.windowHeight;
        draw.drawRect(x, y -= (double)this.pushSearchBarUp(), x + this.windowWidth, y + (double)this.windowHeight, Integer.MIN_VALUE);
        int paddingField = 1;
        int fieldColor = !this.fieldSearch.isFocused() ? ModColor.toRGB(12, 12, 12, 180) : Integer.MIN_VALUE;
        draw.drawRect(x + paddingField, y + (double)paddingField, x + this.fieldSearch.getWidth() - paddingField, y + (double)this.windowHeight - (double)paddingField, fieldColor);
        this.fieldSearch.xPosition = x + 3;
        this.fieldSearch.yPosition = (int)(y + 4.0);
        this.fieldSearch.drawTextBox();
        int searchX = x + this.fieldSearch.getWidth();
        double searchY = y;
        int searchWidth = this.l - 2 - searchX;
        boolean bl = this.hoverSearchButton = mouseX > searchX && searchX < searchX + searchWidth && (double)mouseY > searchY && (double)mouseY < searchY + 16.0;
        int buttonColor = this.fieldSearch.getText().isEmpty() ? ModColor.toRGB(100, 100, 100, 200) : (this.hoverSearchButton ? ModColor.toRGB(100, 200, 100, 200) : Integer.MAX_VALUE);
        int paddingButton = 1;
        draw.drawRect(searchX + paddingButton, searchY + (double)paddingButton, searchX + searchWidth - paddingButton, searchY + (double)this.windowHeight - (double)paddingButton, buttonColor);
        draw.drawCenteredString(LanguageManager.translate("button_search"), (double)searchX + (double)searchWidth / 2.0, searchY + 5.0, 0.7);
        double topY = y;
        if (this.nameHistory == null && this.lastSearchNotFound) {
            draw.drawRect(x, (y += (double)this.windowHeight) + 1.0, x + this.windowWidth, y + 14.0, Integer.MIN_VALUE);
            draw.drawString(ModColor.cl('c') + LanguageManager.translate("search_not_found"), x + 3, y + 4.0);
        } else if (this.nameHistory != null && this.nameHistory.getChanges() != null) {
            y += (double)this.windowHeight;
            y += this.scrollbar.getScrollY();
            double labyNetX = searchX - 5;
            double labyNetY = searchY - 11.0;
            this.hoverLabyNet = (double)mouseX > labyNetX && mouseX < searchX + searchWidth && (double)mouseY > labyNetY && (double)mouseY < labyNetY + 10.0;
            draw.drawRect(labyNetX, labyNetY, searchX + searchWidth, labyNetY + 10.0, Integer.MIN_VALUE);
            draw.drawString(ModColor.cl(this.hoverLabyNet ? (char)'e' : 'f') + ModColor.cl('l') + "LABYnet", labyNetX + 1.0, labyNetY + 2.0, 0.7);
            int index = 0;
            for (UUIDFetcher fetchedName : this.nameHistory.getChanges()) {
                if (y >= topY + (double)this.windowHeight && y < (double)(this.m - 16) && this.nameHistory != null && this.nameHistory.getChanges() != null && fetchedName != null) {
                    boolean latestName = index == 0;
                    boolean originalName = index == this.nameHistory.getChanges().length - 1;
                    draw.drawRect(x, y + 1.0, x + this.windowWidth, y + (double)this.entryHeight, Integer.MIN_VALUE);
                    String nameColor = ModColor.cl((char)(latestName ? 97 : (originalName ? 98 : 55)));
                    draw.drawString(nameColor + (fetchedName.hidden ? "<hidden>" : fetchedName.username), x + 2, y + (double)(latestName || originalName ? 2 : 3), latestName || originalName ? 1.0 : 0.7);
                    String timeDiff = fetchedName.changedToAt == 0L ? LanguageManager.translate("original_name") : ModUtils.getTimeDiff(fetchedName.changedToAt);
                    draw.drawRightString(ModColor.cl('e') + timeDiff, x + this.windowWidth - 4, y + 4.0, 0.6);
                    if (this.nameHistory != null && this.nameHistory.getChanges() != null && this.nameHistory.getChanges().length > 1) {
                        int color = originalName ? ModColor.toRGB(100, 200, 200, 250) : (latestName ? ModColor.toRGB(100, 200, 100, 250) : ModColor.toRGB(180, 180, 180, 100));
                        draw.drawRect(x - 3, y + (double)(latestName ? this.entryHeight / 2 : 0), x - 3 + 1, y + (double)(originalName ? this.entryHeight / 2 + 1 : this.entryHeight), color);
                        draw.drawRect(x - 3 + 1, y + (double)(this.entryHeight / 2), x, y + (double)(this.entryHeight / 2) + 1.0, color);
                    }
                }
                y += (double)this.entryHeight;
                ++index;
            }
        }
        this.scrollbar.setPosition((double)(x + this.windowWidth - 3), topY + (double)this.windowHeight, (double)(x + this.windowWidth), (double)(this.m - 16));
        this.scrollbar.draw();
        draw.drawString(LanguageManager.translate("ingame_chat_tab_namehistory"), x, topY - 10.0);
    }

    @Override
    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        int x = this.l - 2 - this.windowWidth;
        int y = this.m - 16 - this.windowHeight;
        this.fieldSearch.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseX > x && mouseX < x + this.fieldSearch.getWidth() && mouseY > (y -= this.pushSearchBarUp()) && mouseY < y + this.windowHeight) {
            this.fieldSearch.setFocused(true);
        } else {
            this.fieldSearch.setFocused(false);
        }
        if (this.hoverLabyNet && this.nameHistory != null) {
            LabyMod.getInstance().openWebpage(String.format("https://laby.net/@%s", this.nameHistory.getUUID()), false);
        }
        if (this.hoverSearchButton && !this.fieldSearch.getText().isEmpty()) {
            this.doNameSearch(this.fieldSearch.getText());
        }
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.CLICKED);
    }

    @Override
    protected void a(char typedChar, int keyCode) throws IOException {
        if (this.fieldSearch.isFocused()) {
            this.fieldSearch.textboxKeyTyped(typedChar, keyCode);
            if (keyCode == 28) {
                this.doNameSearch(this.fieldSearch.getText());
            }
        } else {
            super.a(typedChar, keyCode);
        }
    }

    @Override
    protected void b(int mouseX, int mouseY, int state) {
        super.b(mouseX, mouseY, state);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
    }

    @Override
    protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
        this.scrollbar.setScrollY((int)(this.scrollbar.getScrollY() / (double)this.entryHeight) * this.entryHeight);
    }

    @Override
    public void k() throws IOException {
        super.k();
        this.scrollbar.mouseInput();
    }

    public void e() {
        if (this.fieldSearch.isFocused()) {
            this.fieldSearch.updateCursorCounter();
        } else {
            super.e();
        }
    }

    private int pushSearchBarUp() {
        if (this.nameHistory != null) {
            return this.nameHistory.getChanges().length > this.maxEntries ? this.maxEntries * this.entryHeight : this.nameHistory.getChanges().length * this.entryHeight;
        }
        if (this.lastSearchNotFound) {
            return 14;
        }
        return 0;
    }

    private void doNameSearch(String username) {
        NameHistoryUtil.getNameHistory(username, new Consumer<NameHistory>(){

            @Override
            public void accept(NameHistory nameHistory) {
                GuiChatNameHistory.this.nameHistory = nameHistory;
                GuiChatNameHistory.this.lastSearchNotFound = nameHistory == null;
                if (nameHistory == null) {
                    GuiChatNameHistory.this.scrollbar.update(0);
                } else {
                    GuiChatNameHistory.this.scrollbar.update(nameHistory.getChanges().length);
                    GuiChatNameHistory.this.fieldSearch.setFocused(false);
                }
            }
        });
    }
}

