/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui.elements;

import java.awt.Color;
import java.util.ArrayList;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.Scrollbar;
import net.labymod.main.LabyMod;
import net.labymod.utils.Consumer;
import net.labymod.utils.ModColor;

public class DropDownMenu<T>
extends avp {
    private static final DropDownEntryDrawer defaultDrawer = new DropDownEntryDrawer(){

        @Override
        public void draw(Object object, int x, int y, String trimmedEntry) {
            LabyMod.getInstance().getDrawUtils().drawString(trimmedEntry, x, y);
        }
    };
    private String title;
    private T selected = null;
    private boolean enabled = true;
    private boolean open;
    private T hoverSelected = null;
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;
    private int maxY = Integer.MAX_VALUE;
    private ArrayList<T> list = new ArrayList();
    private DropDownEntryDrawer entryDrawer = null;
    private Scrollbar scrollbar;
    private Consumer<T> hoverCallback;

    public DropDownMenu(String title, int x, int y, int width, int height) {
        this.title = title;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public DropDownMenu<T> fill(T[] values) {
        for (T value : values) {
            this.list.add(value);
        }
        return this;
    }

    public void onScroll() {
        if (this.scrollbar != null) {
            this.scrollbar.mouseInput();
            this.scrollbar.setScrollY((int)(this.scrollbar.getScrollY() / (double)this.scrollbar.getSpeed()) * this.scrollbar.getSpeed());
        }
    }

    public void onDrag(int mouseX, int mouseY, int mouseButton) {
        if (this.scrollbar != null) {
            this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.DRAGGING);
        }
    }

    public void onRelease(int mouseX, int mouseY, int mouseButton) {
        if (this.scrollbar != null) {
            this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.RELEASED);
        }
    }

    public boolean onClick(int mouseX, int mouseY, int mouseButton) {
        if (this.scrollbar != null && this.scrollbar.isHoverTotalScrollbar(mouseX, mouseY)) {
            this.scrollbar.mouseAction(mouseX, mouseY, Scrollbar.EnumMouseAction.CLICKED);
            return true;
        }
        if (!this.enabled || this.list.isEmpty()) {
            return false;
        }
        if (mouseX > this.x - 1 && mouseX < this.x + this.width + 1 && mouseY > this.y - 1 && mouseY < this.y + this.height + 1) {
            boolean bl = this.open = !this.open;
            if (this.open && this.list.size() > 10) {
                if (this.scrollbar == null) {
                    this.scrollbar = new Scrollbar(13);
                }
                this.scrollbar.setSpeed(13);
                this.scrollbar.setListSize(this.list.size());
                this.scrollbar.setPosition(this.x + this.width - 5, this.y + this.height + 1, this.x + this.width, this.maxY == Integer.MAX_VALUE ? this.y + this.height + 1 + 130 - 1 : this.maxY);
            }
            return true;
        }
        if (this.hoverSelected != null) {
            this.selected = this.hoverSelected;
            this.open = false;
            return true;
        }
        this.open = false;
        if (!this.open && this.hoverCallback != null) {
            this.hoverCallback.accept(null);
        }
        return false;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX > this.x - 1 && mouseX < this.x + this.width + 1 && mouseY > this.y - 1 && mouseY < this.y + this.height + 1;
    }

    public void draw(int mouseX, int mouseY) {
        T prevHover = this.hoverSelected;
        this.hoverSelected = null;
        DropDownMenu.a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)Color.GRAY.getRGB());
        DropDownMenu.a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)Color.BLACK.getRGB());
        if (this.selected != null) {
            String trimmedEntry = LabyMod.getInstance().getDrawUtils().trimStringToWidth(ModColor.cl("f") + this.selected, this.width - 5);
            (this.entryDrawer == null ? defaultDrawer : this.entryDrawer).draw(this.selected, this.x + 5, this.y + this.height / 2 - 4, trimmedEntry);
        }
        if (this.enabled && !this.list.isEmpty()) {
            for (int i = 0; i <= 5; ++i) {
                DropDownMenu.a((int)(this.x + this.width - 16 + i), (int)(this.y + this.height / 2 - 2 + i), (int)(this.x + this.width - 5 - i), (int)(this.y + this.height / 2 + 1 - 2 + i), (int)Color.LIGHT_GRAY.getRGB());
            }
        }
        if (this.title != null) {
            LabyMod.getInstance().getDrawUtils().drawString(LabyModCore.getMinecraft().getFontRenderer().a(this.title, this.width), this.x, this.y - 13);
        }
        if (this.open) {
            this.drawMenuDirect(this.x, this.y, mouseX, mouseY);
        }
        if ((this.hoverSelected != null && prevHover == null || prevHover != null && !prevHover.equals(this.hoverSelected)) && this.hoverCallback != null) {
            this.hoverCallback.accept(this.hoverSelected);
        }
    }

    public void drawMenuDirect(int x, int y, int mouseX, int mouseY) {
        int yPositionList;
        int entryHeight = 13;
        int maxPointY = y + this.height + 2 + 13 * this.list.size();
        boolean buildUp = maxPointY > this.maxY;
        int n = yPositionList = buildUp ? y - 13 - 1 : y + this.height + 1;
        if (this.scrollbar != null) {
            yPositionList = (int)((double)yPositionList + this.scrollbar.getScrollY());
        }
        for (T option : this.list) {
            if (this.scrollbar == null || yPositionList > y + 8 && yPositionList + entryHeight < this.scrollbar.getPosBottom() + 2) {
                boolean hover;
                boolean bl = hover = mouseX > x && mouseX < x + this.width && mouseY > yPositionList && mouseY < yPositionList + entryHeight;
                if (hover) {
                    this.hoverSelected = option;
                }
                DropDownMenu.a((int)(x - 1), (int)yPositionList, (int)(x + this.width + 1), (int)(yPositionList + entryHeight), (int)ModColor.toRGB(0, 30, 70, 250));
                DropDownMenu.a((int)x, (int)(yPositionList + (buildUp ? 1 : 0)), (int)(x + this.width), (int)(yPositionList + entryHeight - 1 + (buildUp ? 1 : 0)), (int)(hover ? ModColor.toRGB(55, 55, 155, 215) : ModColor.toRGB(0, 10, 10, 250)));
                String trimmedEntry = LabyMod.getInstance().getDrawUtils().trimStringToWidth(ModColor.cl("f") + option, this.width - 5);
                (this.entryDrawer == null ? defaultDrawer : this.entryDrawer).draw(option, x + 5, yPositionList + 3, trimmedEntry);
            }
            yPositionList += buildUp ? -entryHeight : entryHeight;
        }
        if (this.scrollbar != null) {
            this.scrollbar.draw();
        }
    }

    public void clear() {
        this.open = false;
        this.selected = null;
        this.list.clear();
        this.setSelected(null);
    }

    public void remove(T type) {
        this.list.remove(type);
    }

    public void addOption(T option) {
        this.list.add(option);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public T getSelected() {
        return this.selected;
    }

    public void setSelected(T selected) {
        this.selected = selected;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public T getHoverSelected() {
        return this.hoverSelected;
    }

    public void setHoverSelected(T hoverSelected) {
        this.hoverSelected = hoverSelected;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    public DropDownEntryDrawer getEntryDrawer() {
        return this.entryDrawer;
    }

    public void setEntryDrawer(DropDownEntryDrawer entryDrawer) {
        this.entryDrawer = entryDrawer;
    }

    public void setHoverCallback(Consumer<T> hoverCallback) {
        this.hoverCallback = hoverCallback;
    }

    public static interface DropDownEntryDrawer {
        public void draw(Object var1, int var2, int var3, String var4);
    }
}

