/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.gui;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.online.AddonInfoManager;
import net.labymod.addon.online.info.AddonInfo;
import net.labymod.addon.online.info.OnlineAddonInfo;
import net.labymod.gui.elements.CheckBox;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.main.listeners.AddonRecommendationListener;
import net.labymod.settings.LabyModAddonsGui;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.ModUtils;
import net.labymod.utils.ServerData;

public class GuiAddonRecommendation
extends axu {
    private final String serverName;
    private final List<RecommendedAddon> addons;
    private final boolean notifyServer;
    private avs buttonDone;
    private CheckBox checkBox;

    public GuiAddonRecommendation(String serverName, List<RecommendedAddon> addons, boolean notifyServer) {
        this.serverName = serverName;
        this.addons = addons;
        this.notifyServer = notifyServer;
        AddonInfoManager.getInstance().createElementsForAddons();
    }

    public void b() {
        super.b();
        boolean hasRequired = false;
        for (RecommendedAddon addon : this.addons) {
            OnlineAddonInfo info = addon.getOnlineAddonInfo();
            if (info == null || !addon.isRequired()) continue;
            hasRequired = true;
        }
        if (hasRequired) {
            this.n.add(new avs(1, this.l / 2 - 100 - 5, this.m - 50, 100, 20, LanguageManager.translate("button_cancel")));
            this.buttonDone = new avs(0, this.l / 2 + 5, this.m - 50, 100, 20, LanguageManager.translate("button_done"));
            this.n.add(this.buttonDone);
        } else {
            this.buttonDone = new avs(0, this.l / 2 - 100, this.m - 50, LanguageManager.translate("button_done"));
            this.n.add(this.buttonDone);
        }
        this.checkBox = new CheckBox("", CheckBox.EnumCheckBoxValue.DISABLED, null, 0, this.m - 80, 20, 20);
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c();
        int amount = 0;
        boolean hasRequired = false;
        boolean allInstalled = true;
        for (RecommendedAddon addon : this.addons) {
            OnlineAddonInfo info = addon.getOnlineAddonInfo();
            if (info == null) continue;
            ++amount;
            if (!addon.isRequired()) continue;
            hasRequired = true;
        }
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int width = 300;
        int x = draw.getWidth() / 2 - width / 2;
        int y = draw.getHeight() / 2 - 42 * amount / 2;
        String translationKey = hasRequired ? "addon_recommendation_title_required" : "addon_recommendation_title_optional";
        ServerData serverData = LabyMod.getInstance().getCurrentServerData();
        String ip2 = this.serverName == null ? (serverData == null || serverData.getIp() == null ? "<server>" : serverData.getIp()) : this.serverName;
        String title = String.format(ModColor.cl('a') + LanguageManager.translate(translationKey), ModColor.cl('E') + ip2 + ModColor.cl('a'));
        draw.drawCenteredString(title, draw.getWidth() / 2, y - 20);
        for (RecommendedAddon addon : this.addons) {
            OnlineAddonInfo info = addon.getOnlineAddonInfo();
            if (info == null) continue;
            info.getAddonElement().draw(x, y, x + width, y + 40, mouseX, mouseY, false);
            if (AddonLoader.hasInstalled(addon.getOnlineAddonInfo())) {
                ave.A().P().a(ModTextures.BUTTON_CHECKBOX);
                draw.drawTexture(x - 25, y + 10, 255.0, 255.0, 20.0, 20.0);
            } else if (addon.isRequired()) {
                ave.A().P().a(ModTextures.BUTTON_EXCLAMATION);
                draw.drawTexture(x - 20, y + 10, 127.0, 255.0, 10.0, 20.0);
                allInstalled = false;
            } else {
                allInstalled = false;
            }
            if (addon.isRequired()) {
                draw.drawString(ModColor.cl('c') + ModColor.cl('l') + LanguageManager.translate("addon_recommendation_required"), x + width + 5, y + 15);
            }
            y += 42;
        }
        if (!hasRequired) {
            String checkBoxLabel = LanguageManager.translate("addon_recommendation_ignore");
            this.checkBox.setX(draw.getWidth() / 2 - draw.getStringWidth(checkBoxLabel) / 2 - 25);
            this.checkBox.drawCheckbox(mouseX, mouseY);
            draw.drawCenteredString(checkBoxLabel, draw.getWidth() / 2, draw.getHeight() - 74);
        }
        boolean bl = this.buttonDone.l = !hasRequired || allInstalled;
        if (hasRequired && LabyModAddonsGui.isRestartRequired()) {
            this.buttonDone.j = LanguageManager.translate("button_restart");
            this.buttonDone.l = true;
        } else {
            this.buttonDone.j = LanguageManager.translate("button_done");
        }
        super.a(mouseX, mouseY, partialTicks);
    }

    public void m() {
        super.m();
        if (this.notifyServer) {
            AddonRecommendationListener.sendMissingStatus(this.addons, true);
        }
    }

    protected void a(char typedChar, int keyCode) throws IOException {
        super.a(typedChar, keyCode);
    }

    public void e() {
        super.e();
    }

    protected void a(avs button) throws IOException {
        super.a(button);
        boolean hasRequired = false;
        for (RecommendedAddon addon : this.addons) {
            OnlineAddonInfo info = addon.getOnlineAddonInfo();
            if (info == null || !addon.isRequired()) continue;
            hasRequired = true;
        }
        switch (button.k) {
            case 0: {
                boolean trusted;
                ServerData currentServer = LabyMod.getInstance().getCurrentServerData();
                boolean bl = trusted = currentServer != null && currentServer.getIp() != null && this.checkBox.getValue() == CheckBox.EnumCheckBoxValue.ENABLED;
                if (trusted) {
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(LabyMod.getSettings().ignoredAddonRecommendationServers));
                    String profileAddress = ModUtils.getProfileNameByIp(currentServer.getIp());
                    if (trusted && !list.contains(profileAddress)) {
                        list.add(profileAddress);
                        String[] array = new String[list.size()];
                        list.toArray(array);
                        LabyMod.getSettings().ignoredAddonRecommendationServers = array;
                        LabyMod.getMainConfig().save();
                    }
                }
                if (hasRequired && LabyModAddonsGui.isRestartRequired()) {
                    ave.A().m();
                    break;
                }
                ave.A().a(null);
                break;
            }
            case 1: {
                ave.A().a(null);
            }
        }
    }

    protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.a(mouseX, mouseY, mouseButton);
        for (RecommendedAddon addon : this.addons) {
            OnlineAddonInfo info = addon.getOnlineAddonInfo();
            if (info == null) continue;
            info.getAddonElement().mouseClicked(mouseX, mouseY, mouseButton);
        }
        boolean hasRequired = false;
        for (RecommendedAddon addon : this.addons) {
            OnlineAddonInfo info = addon.getOnlineAddonInfo();
            if (info == null || !addon.isRequired()) continue;
            hasRequired = true;
        }
        if (!hasRequired) {
            this.checkBox.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    public static class RecommendedAddon {
        private UUID uuid;
        private boolean required;
        private transient OnlineAddonInfo onlineAddonInfo;

        public void bindAddon(AddonInfoManager manager) {
            AddonInfo addonInfo = manager.getAddonInfoMap().get(this.uuid);
            if (addonInfo instanceof OnlineAddonInfo) {
                this.onlineAddonInfo = (OnlineAddonInfo)addonInfo;
            }
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public boolean isRequired() {
            return this.required;
        }

        public OnlineAddonInfo getOnlineAddonInfo() {
            return this.onlineAddonInfo;
        }

        @ConstructorProperties(value={"uuid", "required", "onlineAddonInfo"})
        public RecommendedAddon(UUID uuid, boolean required, OnlineAddonInfo onlineAddonInfo) {
            this.uuid = uuid;
            this.required = required;
            this.onlineAddonInfo = onlineAddonInfo;
        }
    }
}

