/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.discordapp;

import java.util.Locale;
import java.util.Objects;
import net.labymod.core.LabyModCore;
import net.labymod.discordapp.DiscordApp;
import net.labymod.discordapp.api.DiscordRPCLibrary;
import net.labymod.discordapp.api.DiscordRichPresence;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;

public class ModRichPresence {
    private static final long UPDATE_COOLDOWN = 2000L;
    private static final long HEART_BEAT_TICK = 5000L;
    private DiscordRichPresence drp = new DiscordRichPresence();
    private boolean updateRequired = true;
    private long lastCallbackUpdate = 0L;
    private long lastRichPresenceUpdate = 0L;
    private String displayingScreen = "Menu";
    private String serverAddress = null;
    private boolean singlePlayer = false;
    private float health = 20.0f;
    private int gamemode = 0;
    private String matchSecret = null;
    private String joinSecret = null;
    private String spectateSecret = null;
    private boolean party = false;
    private String partyId = null;
    private int partySize = 0;
    private int partyMax = 0;
    private boolean game = false;
    private long gameStartTimestamp = 0L;
    private long gameEndTimestamp = 0L;
    private String serverGamemode = null;

    public ModRichPresence(DiscordApp discordApp) {
    }

    public void screenUpdated(axu currentScreen) {
        String prevDisplayingScreen = this.displayingScreen;
        if (LabyMod.getInstance().isInGame()) {
            this.displayingScreen = currentScreen == null || currentScreen instanceof awv ? "Ingame" : "Ingame Menu";
        } else {
            this.displayingScreen = "Menu";
            if (this.serverAddress != null) {
                this.serverUpdated(null, false);
            }
        }
        if (!prevDisplayingScreen.equals(this.displayingScreen)) {
            this.updateRequired = true;
        }
    }

    public void serverUpdated(bde serverData, boolean singlePlayer) {
        String prevServerAddress = this.serverAddress;
        this.serverAddress = singlePlayer ? "Singleplayer" : (serverData == null ? null : serverData.b);
        if (!Objects.equals(prevServerAddress, this.serverAddress)) {
            this.updateRequired = true;
            this.singlePlayer = singlePlayer;
            this.gameStartTimestamp = System.currentTimeMillis();
        }
    }

    public void serverMatchSecretUpdated(String matchSecret) {
        if (!Objects.equals(this.matchSecret, matchSecret)) {
            this.updateRequired = true;
        }
        this.matchSecret = matchSecret;
    }

    public void serverSpectateSecretUpdated(String spectateSecret) {
        if (!Objects.equals(this.spectateSecret, spectateSecret)) {
            this.updateRequired = true;
        }
        this.spectateSecret = spectateSecret;
    }

    public void serverJoinSecretUpdated(String joinSecret) {
        if (!Objects.equals(this.matchSecret, joinSecret)) {
            this.updateRequired = true;
        }
        this.joinSecret = joinSecret;
    }

    public void serverSecretUpdated(String matchSecret, String joinSecret, String spectateSecret) {
        if (!(Objects.equals(this.matchSecret, matchSecret) && Objects.equals(this.joinSecret, joinSecret) && Objects.equals(this.spectateSecret, spectateSecret))) {
            this.updateRequired = true;
        }
        this.matchSecret = matchSecret;
        this.joinSecret = joinSecret;
        this.spectateSecret = spectateSecret;
    }

    public void serverPartyUpdated(boolean party, String partyId, int size, int max) {
        if (this.party != party || !Objects.equals(this.partyId, partyId) || size != this.partySize || this.partyMax != max) {
            this.updateRequired = true;
        }
        this.party = party;
        this.partyId = partyId;
        this.partySize = size;
        this.partyMax = max;
    }

    public void serverGameUpdated(boolean game, String serverGamemode, long started, long end) {
        if (this.game != game || !Objects.equals(this.serverGamemode, serverGamemode) || started != this.gameStartTimestamp || this.gameEndTimestamp != end) {
            this.updateRequired = true;
        }
        this.game = game;
        this.serverGamemode = serverGamemode;
        this.gameStartTimestamp = started;
        this.gameEndTimestamp = end;
    }

    public DiscordRichPresence build() {
        String state = this.displayingScreen;
        String details = null;
        if (this.singlePlayer) {
            state = this.serverAddress;
            String displayHearts = "";
            if (this.gamemode == 0 || this.gamemode == 2) {
                if (this.health != 0.0f) {
                    displayHearts = this.health % 2.0f == 0.0f ? String.valueOf((int)(this.health / 2.0f)) : String.valueOf(this.health / 2.0f);
                    displayHearts = displayHearts + " heart" + (this.health == 2.0f ? "" : "s");
                } else {
                    displayHearts = "Dead";
                }
            }
            switch (this.gamemode) {
                case 0: {
                    details = "Survival - " + displayHearts;
                    break;
                }
                case 1: {
                    details = "Creative mode";
                    break;
                }
                case 2: {
                    details = "Adventure mode" + displayHearts;
                    break;
                }
                case 3: {
                    details = "Spectator";
                }
            }
            this.drp.smallImageKey = null;
            this.drp.endTimestamp = 0L;
            this.drp.startTimestamp = this.gameStartTimestamp;
            this.joinSecret = null;
            this.spectateSecret = null;
            this.game = false;
            this.drp.partySize = 0;
            this.drp.partyMax = 0;
        } else if (this.serverAddress != null) {
            String[] domainParts;
            if (LabyMod.getSettings().discordShowIpAddress) {
                if (this.serverAddress.contains(".")) {
                    try {
                        domainParts = this.serverAddress.split("\\.");
                        String address = "";
                        int max = Math.min(4, domainParts.length);
                        for (int i = 0; i < max; ++i) {
                            if (!address.isEmpty()) {
                                address = address + ".";
                            }
                            address = address + domainParts[domainParts.length - max + i];
                        }
                        details = address;
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                } else {
                    details = this.serverAddress;
                }
            }
            if (this.serverAddress.contains(".") && (domainParts = this.serverAddress.split("\\.")).length >= 2) {
                String preDomainEnding = domainParts[domainParts.length - 2];
                this.drp.smallImageKey = preDomainEnding.toLowerCase(Locale.ENGLISH);
            }
            if (this.party) {
                this.drp.partySize = this.partySize;
                this.drp.partyMax = this.partyMax;
            }
            if (this.game && this.serverGamemode != null) {
                state = this.serverGamemode;
                this.drp.startTimestamp = this.gameStartTimestamp;
                this.drp.endTimestamp = this.gameEndTimestamp;
            } else {
                this.drp.endTimestamp = 0L;
                this.drp.startTimestamp = this.gameStartTimestamp;
            }
        } else {
            this.drp.smallImageKey = null;
            this.drp.endTimestamp = 0L;
            this.drp.startTimestamp = 0L;
            this.joinSecret = null;
            this.spectateSecret = null;
            this.game = false;
            this.party = false;
            this.drp.partySize = 0;
            this.drp.partyMax = 0;
        }
        this.drp.partyId = this.partyId == null ? LabyMod.getInstance().getPlayerUUID().toString() : this.partyId;
        this.drp.matchSecret = this.matchSecret;
        this.drp.joinSecret = this.joinSecret;
        this.drp.spectateSecret = this.spectateSecret;
        this.drp.details = details;
        this.drp.state = state;
        this.drp.largeImageText = "MC " + Source.ABOUT_MC_VERSION + " - LabyMod " + "3.9.62" + " " + "";
        this.drp.smallImageText = this.drp.smallImageKey == null ? "" : this.drp.smallImageKey;
        this.drp.largeImageKey = "labymod";
        this.drp.instance = 0;
        return this.drp;
    }

    private boolean tickUpdateRequired() {
        if (!LabyMod.getInstance().isInGame()) {
            return false;
        }
        float health = LabyModCore.getMinecraft().getPlayer().bn();
        int gamemode = LabyModCore.getMinecraft().getGameMode(LabyMod.getInstance().getPlayerUUID());
        if (health != this.health || gamemode != this.gamemode) {
            this.health = health;
            this.gamemode = gamemode;
            return true;
        }
        return false;
    }

    public void updateRichPresence() {
        if (!this.tickUpdateRequired() && !this.updateRequired && this.lastRichPresenceUpdate + 5000L > System.currentTimeMillis()) {
            return;
        }
        this.lastRichPresenceUpdate = System.currentTimeMillis();
        DiscordRPCLibrary.updatePresence(this.build());
        this.updateRequired = false;
    }

    public void forceUpdate() {
        this.updateRequired = true;
    }

    public void updateCallbacks() {
        if (this.lastCallbackUpdate + 2000L < System.currentTimeMillis()) {
            this.lastCallbackUpdate = System.currentTimeMillis();
            DiscordRPCLibrary.runCallbacks();
        }
    }

    public boolean isUpdateRequired() {
        return this.updateRequired;
    }

    public long getLastCallbackUpdate() {
        return this.lastCallbackUpdate;
    }
}

