/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.discordapp;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.UUID;
import net.labymod.api.events.PluginMessageEvent;
import net.labymod.api.events.ServerMessageEvent;
import net.labymod.core.LabyModCore;
import net.labymod.discordapp.ModRichPresence;
import net.labymod.discordapp.api.DiscordEventHandlers;
import net.labymod.discordapp.api.DiscordLibraryProvider;
import net.labymod.discordapp.api.DiscordRPCLibrary;
import net.labymod.discordapp.listeners.DisconnectListener;
import net.labymod.discordapp.listeners.ErroredListener;
import net.labymod.discordapp.listeners.JoinGameListener;
import net.labymod.discordapp.listeners.JoinRequestListener;
import net.labymod.discordapp.listeners.ReadyListener;
import net.labymod.discordapp.listeners.SpectateGameListener;
import net.labymod.main.LabyMod;
import net.labymod.support.util.Debug;
import net.labymod.utils.Consumer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DiscordApp
implements PluginMessageEvent,
ServerMessageEvent {
    private static final String APPLICATION_ID = "576456544942686228";
    public static File libraryFile = null;
    private DiscordEventHandlers handlers = new DiscordEventHandlers();
    private ModRichPresence richPresence = new ModRichPresence(this);
    private boolean initialized = false;
    private boolean connected = false;
    private UUID queuedSpectateKey = null;
    private UUID queuedJoinKey = null;

    public DiscordApp() {
        this.handlers.ready = new ReadyListener(this);
        this.handlers.disconnected = new DisconnectListener(this);
        this.handlers.errored = new ErroredListener(this);
        this.handlers.joinGame = new JoinGameListener(this);
        this.handlers.joinRequest = new JoinRequestListener(this);
        this.handlers.spectateGame = new SpectateGameListener(this);
        LabyMod.getInstance().getEventManager().registerShutdownHook(new Runnable(){

            @Override
            public void run() {
                DiscordApp.this.shutdown();
            }
        });
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (!LabyMod.getSettings().discordRichPresence) {
            return;
        }
        Debug.log(Debug.EnumDebugMode.DISCORD, "Initialize discord rpc..");
        DiscordLibraryProvider discordLibraryProvider = new DiscordLibraryProvider();
        if (discordLibraryProvider.isValidOS()) {
            discordLibraryProvider.execute(new Consumer<File>(){

                @Override
                public void accept(File libraryFile) {
                    if (libraryFile != null) {
                        DiscordApp.libraryFile = libraryFile;
                        try {
                            DiscordRPCLibrary.initialize(DiscordApp.APPLICATION_ID, DiscordApp.this.handlers, 1, null);
                            DiscordApp.this.initialized = true;
                            DiscordApp.this.onLibraryLoaded();
                        }
                        catch (Throwable error) {
                            DiscordApp.this.initialized = false;
                            error.printStackTrace();
                        }
                    } else {
                        Debug.log(Debug.EnumDebugMode.DISCORD, "No Discord library found!");
                    }
                }
            });
        }
    }

    public void shutdown() {
        if (this.initialized) {
            Debug.log(Debug.EnumDebugMode.DISCORD, "Shutdown discord rpc..");
            DiscordRPCLibrary.shutdown();
            this.initialized = false;
            this.connected = false;
        }
    }

    private void onLibraryLoaded() {
        Debug.log(Debug.EnumDebugMode.DISCORD, "Discord library's successfully loaded!");
        MinecraftForge.EVENT_BUS.register(this);
        LabyMod.getInstance().getEventManager().register(this);
        LabyMod.getInstance().getEventManager().register(this);
        this.richPresence.forceUpdate();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGuiOpen(GuiOpenEvent event) {
        axu gui = LabyModCore.getForge().getGuiOpenEventGui(event);
        this.richPresence.screenUpdated(gui);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.initialized) {
            this.richPresence.updateCallbacks();
            if (this.connected) {
                this.richPresence.updateRichPresence();
            }
        }
    }

    @Override
    public void receiveMessage(String channelName, em packetBuffer) {
        if (channelName.equals("MC|Brand")) {
            bde serverData = ave.A().D();
            boolean singlePlayer = ave.A().F();
            this.richPresence.serverUpdated(serverData, singlePlayer);
            this.redeemQueuedSecretKeys();
        }
    }

    @Override
    public void onServerMessage(String messageKey, JsonElement serverMessage) {
        if (!messageKey.equals("discord_rpc")) {
            return;
        }
        JsonObject obj = serverMessage.getAsJsonObject();
        if (obj.has("hasMatchSecret")) {
            boolean hasMatchSecret = obj.get("hasMatchSecret").getAsBoolean();
            if (hasMatchSecret) {
                String matchSecret = obj.get("matchSecret").getAsString();
                this.richPresence.serverMatchSecretUpdated(matchSecret);
            } else {
                this.richPresence.serverMatchSecretUpdated(null);
            }
        }
        if (obj.has("hasSpectateSecret")) {
            boolean hasSpectateSecret = obj.get("hasSpectateSecret").getAsBoolean();
            if (hasSpectateSecret) {
                String spectateSecret = obj.get("spectateSecret").getAsString();
                this.richPresence.serverSpectateSecretUpdated(spectateSecret);
            } else {
                this.richPresence.serverSpectateSecretUpdated(null);
            }
        }
        if (obj.has("hasJoinSecret")) {
            boolean hasJoinSecret = obj.get("hasJoinSecret").getAsBoolean();
            if (hasJoinSecret) {
                String joinSecret = obj.get("joinSecret").getAsString();
                this.richPresence.serverJoinSecretUpdated(joinSecret);
            } else {
                this.richPresence.serverJoinSecretUpdated(null);
            }
        }
        if (obj.has("hasParty")) {
            boolean hasParty = obj.get("hasParty").getAsBoolean();
            if (hasParty) {
                String partyId = obj.get("partyId").getAsString();
                int partySize = obj.get("party_size").getAsInt();
                int partyMax = obj.get("party_max").getAsInt();
                this.richPresence.serverPartyUpdated(true, partyId, partySize, partyMax);
            } else {
                this.richPresence.serverPartyUpdated(false, null, 0, 0);
            }
        }
        if (obj.has("hasGame")) {
            boolean hasGame = obj.get("hasGame").getAsBoolean();
            if (hasGame) {
                long startTime = obj.get("game_startTime").getAsLong();
                long endTime = obj.get("game_endTime").getAsLong();
                String gamemode = obj.get("game_mode").getAsString();
                this.richPresence.serverGameUpdated(true, gamemode, startTime, endTime);
            } else {
                this.richPresence.serverGameUpdated(false, null, 0L, 0L);
            }
        }
    }

    public void respond(String userId, int reply) {
        DiscordRPCLibrary.respond(userId, reply);
    }

    public void redeemSpectateKey(UUID spectateKey, String serverDomain) {
        Debug.log(Debug.EnumDebugMode.DISCORD, "Redeem spectate secret key: " + spectateKey.toString() + " on " + serverDomain);
        this.queuedSpectateKey = spectateKey;
        if (!LabyMod.getInstance().switchServer(serverDomain, false)) {
            this.redeemQueuedSecretKeys();
        }
    }

    public void redeemJoinKey(UUID joinKey, String serverDomain) {
        Debug.log(Debug.EnumDebugMode.DISCORD, "Redeem join secret key: " + joinKey.toString() + " on " + serverDomain);
        this.queuedJoinKey = joinKey;
        if (!LabyMod.getInstance().switchServer(serverDomain, false)) {
            this.redeemQueuedSecretKeys();
        }
    }

    private void redeemQueuedSecretKeys() {
        if (this.queuedJoinKey == null && this.queuedSpectateKey == null) {
            return;
        }
        JsonObject obj = new JsonObject();
        if (this.queuedJoinKey != null) {
            obj.addProperty("joinSecret", this.queuedJoinKey.toString());
        } else if (this.queuedSpectateKey != null) {
            obj.addProperty("spectateSecret", this.queuedSpectateKey.toString());
        }
        LabyMod.getInstance().getLabyModAPI().sendJsonMessageToServer("discord_rpc", (JsonElement)obj);
        this.queuedSpectateKey = null;
        this.queuedJoinKey = null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }
}

