/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.core_implementation.mc18.serverpinger;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.labymod.core.ServerPingerData;
import net.labymod.utils.Consumer;
import org.apache.commons.lang3.ArrayUtils;

public class ServerPinger {
    private static final Splitter PING_RESPONSE_SPLITTER = Splitter.on((char)'\u0000').limit(6);
    private final List<ek> pingDestinations = Collections.synchronizedList(Lists.newArrayList());

    public void ping(final Consumer<ServerPingerData> doneCallback, final ServerPingerData server) throws Throwable {
        bdd serveraddress = bdd.a((String)server.getIpAddress());
        ek networkmanager = null;
        try {
            networkmanager = ek.a((InetAddress)InetAddress.getByName(serveraddress.a()), (int)serveraddress.b(), (boolean)false);
        }
        catch (UnknownHostException e) {
            doneCallback.accept(null);
            e.printStackTrace();
        }
        this.pingDestinations.add(networkmanager);
        final ek finalNetworkManager = networkmanager;
        networkmanager.a((ep)new jp(){
            private boolean successful;
            private boolean receivedStatus;
            private long pinged;

            public void a(jr packetIn) {
                if (this.receivedStatus) {
                    finalNetworkManager.a((eu)new fa("Received unrequested status"));
                } else {
                    String s;
                    this.receivedStatus = true;
                    js serverstatusresponse = packetIn.a();
                    server.setPingToServer(System.currentTimeMillis() - server.getTimePinged());
                    if (serverstatusresponse.a() != null) {
                        server.setMotd(serverstatusresponse.a().d());
                    } else {
                        server.setMotd("");
                    }
                    if (serverstatusresponse.b() != null) {
                        server.setCurrentPlayers(serverstatusresponse.b().b());
                        server.setMaxPlayers(serverstatusresponse.b().a());
                        if (ArrayUtils.isNotEmpty((Object[])serverstatusresponse.b().c())) {
                            StringBuilder stringbuilder = new StringBuilder();
                            for (GameProfile gameprofile : serverstatusresponse.b().c()) {
                                if (stringbuilder.length() > 0) {
                                    stringbuilder.append("\n");
                                }
                                stringbuilder.append(gameprofile.getName());
                            }
                            if (serverstatusresponse.b().c().length < serverstatusresponse.b().b()) {
                                if (stringbuilder.length() > 0) {
                                    stringbuilder.append("\n");
                                }
                                stringbuilder.append("... and ").append(serverstatusresponse.b().b() - serverstatusresponse.b().c().length).append(" more ...");
                            }
                            server.setPlayerList(stringbuilder.toString());
                        }
                    }
                    if (serverstatusresponse.d() != null && (s = serverstatusresponse.d()).startsWith("data:image/png;base64,")) {
                        server.setBase64EncodedIconData(s.substring("data:image/png;base64,".length()));
                    }
                    if (serverstatusresponse.c() != null) {
                        server.setGameVersion(serverstatusresponse.c().a());
                        server.setVersion(serverstatusresponse.c().b());
                    } else {
                        server.setGameVersion("?");
                    }
                    this.successful = true;
                    this.pinged = ave.J();
                    finalNetworkManager.a((ff)new ju(this.pinged));
                }
            }

            public void a(jq packetIn) {
                long i = this.pinged;
                long j = ave.J();
                server.setPingToServer(j - i);
                doneCallback.accept(server);
                finalNetworkManager.a((eu)new fa("Finished"));
            }

            public void a(eu reason) {
                if (!this.successful) {
                    try {
                        ServerPinger.this.tryCompatibilityPing(doneCallback, server);
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
            }
        });
        try {
            networkmanager.a((ff)new jc(47, serveraddress.a(), serveraddress.b(), el.c));
            networkmanager.a((ff)new jv());
        }
        catch (Throwable throwable) {
            doneCallback.accept(null);
            throwable.printStackTrace();
        }
    }

    private void tryCompatibilityPing(final Consumer<ServerPingerData> doneCallback, final ServerPingerData server) {
        final bdd serveraddress = bdd.a((String)server.getIpAddress());
        if (serveraddress == null) {
            return;
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)ek.d.c())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel p_initChannel_1_) throws Exception {
                try {
                    p_initChannel_1_.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                p_initChannel_1_.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void channelActive(ChannelHandlerContext p_channelActive_1_) throws Exception {
                        super.channelActive(p_channelActive_1_);
                        ByteBuf bytebuf = Unpooled.buffer();
                        try {
                            bytebuf.writeByte(254);
                            bytebuf.writeByte(1);
                            bytebuf.writeByte(250);
                            char[] achar = "MC|PingHost".toCharArray();
                            bytebuf.writeShort(achar.length);
                            for (char c0 : achar) {
                                bytebuf.writeChar((int)c0);
                            }
                            bytebuf.writeShort(7 + 2 * serveraddress.a().length());
                            bytebuf.writeByte(127);
                            achar = serveraddress.a().toCharArray();
                            bytebuf.writeShort(achar.length);
                            for (char c1 : achar) {
                                bytebuf.writeChar((int)c1);
                            }
                            bytebuf.writeInt(serveraddress.b());
                            p_channelActive_1_.channel().writeAndFlush((Object)bytebuf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                        }
                        finally {
                            bytebuf.release();
                        }
                    }

                    protected void channelRead0(ChannelHandlerContext p_channelRead0_1_, ByteBuf p_channelRead0_2_) throws Exception {
                        short short1 = p_channelRead0_2_.readUnsignedByte();
                        boolean success = false;
                        if (short1 == 255) {
                            String s = new String(p_channelRead0_2_.readBytes(p_channelRead0_2_.readShort() * 2).array(), Charsets.UTF_16BE);
                            String[] astring = (String[])Iterables.toArray((Iterable)PING_RESPONSE_SPLITTER.split((CharSequence)s), String.class);
                            if ("\u00a71".equals(astring[0])) {
                                String s2 = astring[3];
                                int j = ns.a((String)astring[4], (int)-1);
                                int k = ns.a((String)astring[5], (int)-1);
                                server.setMotd(s2);
                                server.setCurrentPlayers(j);
                                server.setMaxPlayers(k);
                                success = true;
                                doneCallback.accept(server);
                            }
                        }
                        if (!success) {
                            doneCallback.accept(null);
                        }
                        p_channelRead0_1_.close();
                    }

                    public void exceptionCaught(ChannelHandlerContext p_exceptionCaught_1_, Throwable p_exceptionCaught_2_) throws Exception {
                        p_exceptionCaught_1_.close();
                        doneCallback.accept(null);
                    }
                }});
            }
        })).channel(NioSocketChannel.class)).connect(serveraddress.a(), serveraddress.b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingPendingNetworks() {
        List<ek> list = this.pingDestinations;
        synchronized (list) {
            Iterator<ek> iterator = this.pingDestinations.iterator();
            while (iterator.hasNext()) {
                ek networkmanager = iterator.next();
                try {
                    if (networkmanager == null) continue;
                    if (networkmanager.g()) {
                        networkmanager.a();
                        continue;
                    }
                    iterator.remove();
                    networkmanager.l();
                }
                catch (Exception error) {
                    error.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingNetworks() {
        List<ek> list = this.pingDestinations;
        synchronized (list) {
            Iterator<ek> iterator = this.pingDestinations.iterator();
            while (iterator.hasNext()) {
                ek networkmanager = iterator.next();
                if (networkmanager == null || !networkmanager.g()) continue;
                iterator.remove();
                networkmanager.a((eu)new fa("Cancelled"));
            }
        }
    }
}

