/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.api.protocol.screen.render.components.widgets;

import com.google.gson.JsonObject;
import java.awt.Color;
import net.labymod.api.protocol.screen.render.components.RenderWidget;
import net.labymod.api.protocol.screen.render.util.IInteractionCallback;
import net.labymod.api.protocol.screen.render.util.IScreenAccessor;
import net.labymod.gui.elements.ColorPicker;
import net.labymod.serverapi.common.widgets.components.widgets.ColorPickerWidget;

public class RenderColorPickerWidget
extends RenderWidget<ColorPickerWidget>
implements ColorPicker.DefaultColorCallback {
    private ColorPicker colorPicker;

    public RenderColorPickerWidget(ColorPickerWidget widget, IInteractionCallback callback) {
        super(widget, callback);
    }

    @Override
    public void createScreen(IScreenAccessor accessor) {
        this.colorPicker = new ColorPicker(((ColorPickerWidget)this.widget).getTitle(), ((ColorPickerWidget)this.widget).getSelectedColor(), this, this.getX(accessor), this.getY(accessor), ((ColorPickerWidget)this.widget).getWidth(), ((ColorPickerWidget)this.widget).getHeight());
        this.colorPicker.setHasAdvanced(((ColorPickerWidget)this.widget).isRgb());
    }

    @Override
    public void initScreen(IScreenAccessor accessor) {
        super.initScreen(accessor);
        this.colorPicker.setX(this.getX(accessor));
        this.colorPicker.setY(this.getY(accessor));
    }

    @Override
    public void renderScreen(IScreenAccessor accessor, int mouseX, int mouseY) {
        this.colorPicker.drawColorPicker(mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(IScreenAccessor accessor, double mouseX, double mouseY, int button) {
        return this.colorPicker.mouseClicked((int)mouseX, (int)mouseY, button);
    }

    @Override
    public Color getDefaultColor() {
        return Color.WHITE;
    }

    @Override
    protected void fillResponsePayload(JsonObject state) {
        super.fillResponsePayload(state);
        state.addProperty("color", "#" + Integer.toHexString(this.colorPicker.getSelectedColor().getRGB()).substring(2));
    }
}

