/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addon.online;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.labymod.addon.AddonLoader;
import net.labymod.addon.LabyModOFAddon;
import net.labymod.addon.online.info.AddonInfo;
import net.labymod.addon.online.info.OnlineAddonInfo;
import net.labymod.api.LabyModAddon;
import net.labymod.gui.elements.CheckBox;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.support.util.Debug;
import net.labymod.utils.request.DownloadServerRequest;

public class AddonInfoManager {
    private static AddonInfoManager instance;
    private Map<UUID, AddonInfo> addonInfoMap = new HashMap<UUID, AddonInfo>();
    private List<AddonInfo> addonInfoList = new ArrayList<AddonInfo>();
    private List<OnlineAddonInfo> allMinecraftVersionsAddonInfoList = new ArrayList<OnlineAddonInfo>();
    private List<String> categories = new ArrayList<String>(Arrays.asList("All"));
    private CheckBox[] categorieCheckboxList = new CheckBox[this.categories.size()];
    private boolean loaded = false;
    private boolean calledInit = false;

    public static AddonInfoManager getInstance() {
        if (instance == null) {
            instance = new AddonInfoManager();
        }
        return instance;
    }

    public void init() {
        if (this.calledInit) {
            return;
        }
        this.calledInit = true;
        String majorVersion = Source.getMajorVersion();
        try {
            JsonObject jsonObject = (JsonObject)DownloadServerRequest.getJsonObject("https://dl.labymod.net/addons.json");
            JsonArray array = jsonObject.get("categories").getAsJsonArray();
            this.categorieCheckboxList = new CheckBox[array.size()];
            int i = 0;
            for (JsonElement element : array) {
                String displayName = element.getAsString();
                this.categories.add(displayName);
                this.categorieCheckboxList[i] = new CheckBox(displayName, CheckBox.EnumCheckBoxValue.ENABLED, null, 0, 0, 15, 15);
                ++i;
            }
            Set addonsSet = jsonObject.get("addons").getAsJsonObject().entrySet();
            for (Map.Entry entry : addonsSet) {
                JsonArray jsonArray = ((JsonElement)entry.getValue()).getAsJsonArray();
                Iterator addonIterator = jsonArray.iterator();
                while (addonIterator.hasNext()) {
                    JsonObject object = ((JsonElement)addonIterator.next()).getAsJsonObject();
                    JsonElement addonUUID = object.get("uuid");
                    JsonElement addonName = object.get("name");
                    JsonElement addonVersion = object.get("version");
                    JsonElement addonHash = object.get("hash");
                    JsonElement addonAuthor = object.get("author");
                    JsonElement addonDescription = object.get("description");
                    JsonElement addonCategory = object.get("category");
                    JsonElement addonEnabled = object.get("enabled");
                    JsonElement addonIncludeInJar = object.get("includeInJar");
                    JsonElement addonRestart = object.get("restart");
                    JsonElement addonVerified = object.get("verified");
                    JsonElement addonMcVersion = object.get("mcversion");
                    if (addonUUID == null || addonName == null || addonVersion == null || addonHash == null || addonAuthor == null || addonDescription == null || addonCategory == null || addonEnabled == null || addonIncludeInJar == null || addonRestart == null || addonVerified == null || addonMcVersion == null) continue;
                    int[] sorting = new int[this.categories.size()];
                    if (object.has("sorting")) {
                        JsonArray addonSorting = object.get("sorting").getAsJsonArray();
                        sorting = new int[addonSorting.size()];
                        int index = 0;
                        for (JsonElement element : addonSorting) {
                            sorting[index] = element.getAsInt();
                            ++index;
                        }
                    }
                    OnlineAddonInfo onlineAddonInfo = new OnlineAddonInfo(UUID.fromString(addonUUID.getAsString()), addonName.getAsString(), addonVersion.getAsInt(), addonHash.getAsString(), addonAuthor.getAsString(), addonDescription.getAsString(), addonCategory.getAsInt(), addonEnabled.getAsBoolean(), addonIncludeInJar.getAsBoolean(), addonRestart.getAsBoolean(), addonVerified.getAsBoolean(), addonMcVersion.getAsString(), sorting);
                    this.allMinecraftVersionsAddonInfoList.add(onlineAddonInfo);
                    if (!majorVersion.equals(entry.getKey())) continue;
                    UUID uuid = onlineAddonInfo.getUuid();
                    this.addonInfoMap.put(uuid, onlineAddonInfo);
                    this.addonInfoList.add(onlineAddonInfo);
                    if (LabyModOFAddon.INSTALLED_VERSION != null && LabyModOFAddon.OPTIFINE_VERSIONS.containsValue(uuid)) {
                        onlineAddonInfo.setName(LabyModOFAddon.INSTALLED_VERSION);
                    }
                    AddonLoader.getOfflineAddons().remove(uuid);
                    Debug.log(Debug.EnumDebugMode.ADDON, "Resolved addon " + onlineAddonInfo.getName() + " " + onlineAddonInfo.getVersion() + " by " + onlineAddonInfo.getAuthor());
                }
            }
            this.addonInfoMap = this.addonInfoMap;
            this.addonInfoList = this.addonInfoList;
            for (AddonInfo offlineAddon : AddonLoader.getOfflineAddons()) {
                this.addonInfoList.add(offlineAddon);
                this.addonInfoMap.put(offlineAddon.getUuid(), offlineAddon);
            }
            this.loaded = true;
        }
        catch (Exception e) {
            Debug.log(Debug.EnumDebugMode.ADDON, "Failed getting available addons!");
            e.printStackTrace();
        }
        LabyMod.getInstance().getEventManager().registerShutdownHook(new Runnable(){

            @Override
            public void run() {
                try {
                    Debug.log(Debug.EnumDebugMode.ADDON, "Addon shutdown hook!");
                    boolean deleteOptifine = false;
                    boolean deleteAction = false;
                    for (LabyModAddon labyModAddon : AddonLoader.getAddons()) {
                        if (!labyModAddon.about.deleted) continue;
                        deleteAction = true;
                    }
                    if (deleteAction) {
                        File file = AddonLoader.getDeleteQueueFile();
                        FileWriter fileWriter = new FileWriter(file, true);
                        try {
                            Path path = file.toPath();
                            Files.setAttribute(path, "dos:hidden", true, new LinkOption[0]);
                        }
                        catch (Exception error) {
                            Debug.log(Debug.EnumDebugMode.ADDON, "Can't hide file: " + error.getMessage());
                        }
                        for (LabyModAddon labyModAddon : AddonLoader.getAddons()) {
                            if (!labyModAddon.about.deleted) continue;
                            Debug.log(Debug.EnumDebugMode.ADDON, "Delete " + labyModAddon.about.name);
                            if (labyModAddon instanceof LabyModOFAddon) {
                                deleteOptifine = true;
                                continue;
                            }
                            File foundFile = AddonLoader.getFiles().get(labyModAddon.about.uuid);
                            if (foundFile != null && foundFile.exists()) {
                                fileWriter.write(foundFile.getName() + "\n");
                                continue;
                            }
                            Debug.log(Debug.EnumDebugMode.ADDON, "Error while adding " + labyModAddon.about.name + " to delete queue");
                        }
                        fileWriter.close();
                    }
                    if (deleteOptifine) {
                        LabyModOFAddon.executeOfHandler(false);
                    } else if (LabyModOFAddon.INSTALL) {
                        LabyModOFAddon.executeOfHandler(true);
                    }
                }
                catch (Throwable error) {
                    error.printStackTrace();
                }
            }
        });
    }

    public void createElementsForAddons() {
        for (AddonInfo info : AddonInfoManager.getInstance().getAddonInfoList()) {
            info.init();
        }
        for (AddonInfo info : AddonLoader.getOfflineAddons()) {
            info.init();
        }
    }

    public Map<UUID, AddonInfo> getAddonInfoMap() {
        return this.addonInfoMap;
    }

    public List<AddonInfo> getAddonInfoList() {
        return this.addonInfoList;
    }

    public List<OnlineAddonInfo> getAllMinecraftVersionsAddonInfoList() {
        return this.allMinecraftVersionsAddonInfoList;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public CheckBox[] getCategorieCheckboxList() {
        return this.categorieCheckboxList;
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

