/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.addon;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;

public class ForgeModsScanner {
    private static final ForgeModsScanner instance = new ForgeModsScanner();
    private JsonArray jsonArray = new JsonArray();

    public static ForgeModsScanner getInstance() {
        return instance;
    }

    public ForgeModsScanner() {
        try {
            File modsFolder = new File("mods");
            if (!modsFolder.exists()) {
                return;
            }
            File[] list = modsFolder.listFiles();
            if (list != null) {
                for (File file : list) {
                    if (file == null || file.isDirectory() || !file.getName().endsWith(".jar")) continue;
                    try {
                        JsonObject entry = new JsonObject();
                        entry.addProperty("hash", "sha256:" + Files.hash((File)file, (HashFunction)Hashing.sha256()).toString());
                        entry.addProperty("name", file.getName());
                        this.jsonArray.add((JsonElement)entry);
                    }
                    catch (Exception error) {
                        error.printStackTrace();
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public JsonArray getJsonArray() {
        return this.jsonArray;
    }
}

