/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.microsoft.model.msa.msa;

import com.google.gson.annotations.SerializedName;
import java.util.Date;
import net.labymod.accountmanager.authentication.microsoft.MicrosoftAuthentication;
import net.labymod.accountmanager.authentication.microsoft.model.oauth.OAuthResponse;
import net.labymod.accountmanager.storage.loader.microsoft.model.msa.msa.AccessToken;

public class MSA {
    @SerializedName(value="user_id")
    public String userId;
    @SerializedName(value="refresh_token")
    public String refreshToken;
    public String foci;
    @SerializedName(value="access_tokens")
    public AccessToken[] accessTokens;

    public MSA(OAuthResponse oAuth) {
        this.userId = oAuth.userId;
        this.refreshToken = oAuth.refreshToken;
        this.foci = oAuth.foci;
        long expireTimestamp = System.currentTimeMillis() + oAuth.expiresIn * 1000L;
        String date = MicrosoftAuthentication.DATE_FORMAT_EXACT.format(new Date(expireTimestamp));
        this.accessTokens = new AccessToken[]{new AccessToken(oAuth.accessToken, date, oAuth.scope.toLowerCase())};
    }
}

