/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.microsoft;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.account.AccountSessionState;
import net.labymod.accountmanager.storage.credentials.CredentialsAccessor;
import net.labymod.accountmanager.storage.loader.JsonStorageImpl;
import net.labymod.accountmanager.storage.loader.microsoft.model.LauncherAccount;
import net.labymod.accountmanager.storage.loader.microsoft.model.LauncherAccounts;

public class MicrosoftLauncherStorage
extends JsonStorageImpl<LauncherAccounts, LauncherAccount> {
    protected final CredentialsAccessor credentialsAccessor;
    protected final File minecraftDirectory;
    private LauncherAccounts storage;

    public MicrosoftLauncherStorage(CredentialsAccessor credentialsAccessor, File minecraftDirectory) {
        this.credentialsAccessor = credentialsAccessor;
        this.minecraftDirectory = minecraftDirectory;
    }

    @Override
    public File getFile() {
        return new File(this.minecraftDirectory, "launcher_accounts.json");
    }

    @Override
    protected Class<?> onJsonObjectClass() {
        return LauncherAccounts.class;
    }

    @Override
    protected LauncherAccounts getStorage() {
        return this.storage;
    }

    @Override
    public boolean isLoaded() {
        return this.storage != null && this.storage.accounts != null;
    }

    @Override
    protected void onStorageLoaded(LauncherAccounts storage) {
        this.storage = storage;
    }

    @Override
    protected void onPreLoad() {
        if (this.credentialsAccessor == null || this.storage == null) {
            return;
        }
        try {
            this.storage.mojangClientToken = this.credentialsAccessor.getValue(this.getType(), "mojangClientToken");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onPostLoad() {
        if (this.credentialsAccessor == null || this.storage == null) {
            return;
        }
        if (this.storage.accounts != null) {
            for (Map.Entry<String, LauncherAccount> entry : this.storage.accounts.entrySet()) {
                LauncherAccount account = entry.getValue();
                if (account.isPremium()) continue;
                account.setSessionState(AccountSessionState.VALIDATING);
                try {
                    String accessToken = this.credentialsAccessor.getValue(this.getType(), entry.getKey());
                    if (accessToken == null) continue;
                    account.setAccessToken(accessToken);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public Collection<LauncherAccount> getAccounts() {
        return this.storage.accounts.values();
    }

    @Override
    public String getClientToken() {
        return this.storage.mojangClientToken;
    }

    @Override
    public Account getActiveAccount() {
        return this.storage.activeAccountLocalId == null ? null : (Account)this.storage.accounts.get(this.storage.activeAccountLocalId);
    }

    @Override
    public StorageType getType() {
        return StorageType.MICROSOFT;
    }
}

