/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.external.model.token;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.Map;
import net.labymod.accountmanager.storage.account.TokenAccessor;
import net.labymod.accountmanager.utils.TokenPatcher;

public class Token {
    private String token;
    @SerializedName(value="expires_at")
    private long expiresAt;
    @SerializedName(value="additional_data")
    private Map<String, String> additionalData = new HashMap<String, String>();

    public Token() {
        this(null, 0L);
    }

    public Token(String accessToken, long expiresAt) {
        this.token = accessToken;
        this.expiresAt = expiresAt;
    }

    public Token update(TokenAccessor accessor) {
        this.token = accessor.getToken();
        this.expiresAt = accessor.getExpiresAt();
        return this;
    }

    public Token update(String token, long expiresAt) {
        this.token = token;
        this.expiresAt = expiresAt;
        return this;
    }

    public boolean hasData(String key) {
        return this.additionalData.containsKey(key);
    }

    public String getData(String key) {
        return this.additionalData.get(key);
    }

    public Token setData(String key, String value) {
        this.additionalData.put(key, value);
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public boolean hasExpired() {
        return System.currentTimeMillis() > this.expiresAt;
    }

    public void patch(TokenPatcher patcher) throws Exception {
        this.token = patcher.patch(this.token);
        String refreshToken = this.additionalData.get("refresh_token");
        if (refreshToken != null) {
            this.additionalData.put("refresh_token", patcher.patch(refreshToken));
        }
    }
}

