/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.external.model;

import com.google.gson.annotations.SerializedName;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import net.labymod.accountmanager.authentication.microsoft.model.MicrosoftAccountResult;
import net.labymod.accountmanager.authentication.microsoft.model.minecraft.LoginResponse;
import net.labymod.accountmanager.storage.loader.external.model.ExternalAccount;
import net.labymod.accountmanager.storage.loader.external.model.token.TokenChain;
import net.labymod.accountmanager.utils.CertificateLoader;
import net.labymod.accountmanager.utils.TokenPatcher;

public class ExternalMicrosoftAccount
extends ExternalAccount {
    @SerializedName(value="avatar_image")
    private String avatarImage;
    @SerializedName(value="tokens")
    private TokenChain tokens = new TokenChain();

    public ExternalMicrosoftAccount(UUID uuid, String name, MicrosoftAccountResult result) {
        super(uuid, name, result.getMinecraftAPILogin().accessToken);
        this.tokens.update(result);
        this.updateProfile(result);
    }

    @Override
    public boolean isMicrosoft() {
        return true;
    }

    @Override
    public String getAvatarImage() {
        return this.avatarImage;
    }

    public TokenChain getTokens() {
        return this.tokens;
    }

    public void updateProfile(MicrosoftAccountResult result) {
        if (this.tokens == null) {
            this.tokens = new TokenChain();
        }
        this.tokens.update(result);
        String url = result.getAvatarUrl();
        this.setAvatarUrl(url);
        LoginResponse minecraft = result.getMinecraftAPILogin();
        this.setAccessToken(minecraft.getToken());
        this.setAccessTokenExpiresAt(minecraft.getExpiresAt());
        this.setUsername(result.getMinecraftProfile().name);
    }

    public void setAvatarUrl(String avatarUrl) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            Base64.Encoder base64 = Base64.getEncoder();
            HttpsURLConnection connection = (HttpsURLConnection)new URL(avatarUrl).openConnection();
            connection.setSSLSocketFactory(CertificateLoader.getSocketFactory());
            BufferedImage image = ImageIO.read(connection.getInputStream());
            ImageIO.write((RenderedImage)image, "png", byteArrayOutputStream);
            this.avatarImage = "data:image/png;base64," + base64.encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void patchTokens(TokenPatcher patcher) throws Exception {
        super.patchTokens(patcher);
        this.tokens.patch(patcher);
    }
}

