/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader.external.model;

import com.google.gson.annotations.SerializedName;
import java.util.UUID;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.account.AbstractAccount;
import net.labymod.accountmanager.utils.TokenPatcher;

public class ExternalAccount
extends AbstractAccount {
    private final UUID uuid;
    private String username;
    @SerializedName(value="access_token")
    private String accessToken;

    public ExternalAccount(UUID uuid, String name, String accessToken) {
        this.uuid = uuid;
        this.username = name;
        this.accessToken = accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.EXTERNAL;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getAvatarImage() {
        return null;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public boolean isDemo() {
        return this.uuid == null || this.username == null;
    }

    @Override
    public boolean isMicrosoft() {
        return false;
    }

    @Override
    public boolean isPremium() {
        return !this.isDemo() && this.accessToken != null && this.accessToken.length() > 10;
    }

    public void patchTokens(TokenPatcher patcher) throws Exception {
        this.accessToken = patcher.patch(this.accessToken);
    }
}

