/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import net.labymod.accountmanager.storage.AbstractAccountStorage;
import net.labymod.accountmanager.storage.Accounts;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.account.AccountSessionState;
import net.labymod.accountmanager.utils.IOUtil;

public abstract class JsonStorageImpl<T extends Accounts, K extends Account>
extends AbstractAccountStorage<K> {
    protected final Gson gson;

    protected JsonStorageImpl() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        this.registerTypeAdapters(builder);
        this.gson = builder.create();
    }

    protected void registerTypeAdapters(GsonBuilder builder) {
    }

    protected abstract Class<?> onJsonObjectClass();

    protected abstract void onStorageLoaded(T var1);

    protected abstract T getStorage();

    @Override
    public void load() throws Exception {
        block17: {
            this.onPreLoad();
            File file = this.getFile();
            try {
                String json;
                if (!file.exists()) break block17;
                try (FileInputStream input = new FileInputStream(file);){
                    json = IOUtil.toString(input);
                }
                this.onStorageLoaded((Accounts)this.gson.fromJson(json, this.onJsonObjectClass()));
                if (this.isLoaded()) {
                    this.setAllSessionStatesTo(AccountSessionState.UNKNOWN);
                }
            }
            catch (Exception e) {
                if (file.exists() && file.delete()) {
                    e.printStackTrace();
                }
                throw e;
            }
        }
        this.onPostLoad();
        if (this.isLoaded()) {
            this.initializeAuthentication();
        }
    }

    protected void onPreLoad() {
    }

    protected void onPostLoad() {
    }

    @Override
    public void save() throws Exception {
        File file = this.getFile();
        if (this.isLoaded()) {
            String json = this.gson.toJson(this.getStorage());
            try (FileOutputStream output = new FileOutputStream(file);){
                IOUtil.write(json, (OutputStream)output, StandardCharsets.UTF_8);
            }
        }
    }
}

