/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.loader;

import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import net.labymod.accountmanager.storage.EncryptedAccounts;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.credentials.CredentialsAccessor;
import net.labymod.accountmanager.storage.loader.JsonStorageImpl;
import net.labymod.accountmanager.utils.TokenPatcher;

public abstract class EncryptedJsonStorageImpl<T extends EncryptedAccounts, K extends Account>
extends JsonStorageImpl<T, K> {
    private static final String CREDENTIAL_MANAGER_ENTRY_KEY = "externalAccountStorage.encryptionKey";
    protected final CredentialsAccessor credentialsAccessor;
    protected String encryptionKey;

    public EncryptedJsonStorageImpl() {
        this(null);
    }

    public EncryptedJsonStorageImpl(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    @Override
    protected void onPreLoad() {
        if (this.credentialsAccessor == null) {
            return;
        }
        this.encryptionKey = this.provideEncryptionKey(() -> this.credentialsAccessor.getValue(this.getType(), CREDENTIAL_MANAGER_ENTRY_KEY), key -> this.credentialsAccessor.setValue(this.getType(), CREDENTIAL_MANAGER_ENTRY_KEY, key));
    }

    @Override
    protected void onStorageLoaded(T object) {
        this.decryptTokens();
    }

    @Override
    public void save() throws Exception {
        this.encryptTokens();
        super.save();
        this.decryptTokens();
    }

    private void encryptTokens() {
        EncryptedAccounts storage = (EncryptedAccounts)this.getStorage();
        if (!this.isEncryptionSupported() || storage.isEncrypted()) {
            return;
        }
        try {
            this.patchTokens(encryptedValue -> this.encrypt(encryptedValue, this.encryptionKey));
            storage.setEncrypted(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not encrypt account storage", e);
        }
    }

    private void decryptTokens() {
        EncryptedAccounts storage = (EncryptedAccounts)this.getStorage();
        if (!this.isEncryptionSupported() || !storage.isEncrypted()) {
            return;
        }
        try {
            this.patchTokens(encryptedValue -> this.decrypt(encryptedValue, this.encryptionKey));
            storage.setEncrypted(false);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not decrypt account storage", e);
        }
    }

    private void patchTokens(TokenPatcher patcher) throws Exception {
        for (Account account : this.getAccounts()) {
            this.patchTokens(account, patcher);
        }
    }

    private String encrypt(String value, String key) throws Exception {
        DESKeySpec desKeySpec = new DESKeySpec(key.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(1, secretKey);
        byte[] encryptedBytes = cipher.doFinal(value.getBytes());
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    private String decrypt(String encryptedValue, String key) throws Exception {
        DESKeySpec desKeySpec = new DESKeySpec(key.getBytes());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(2, secretKey);
        byte[] decodedBytes = Base64.getDecoder().decode(encryptedValue);
        byte[] decryptedBytes = cipher.doFinal(decodedBytes);
        return new String(decryptedBytes);
    }

    private String generateEncryptionKey() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            builder.append((char)(Math.random() * 26.0 + 97.0));
        }
        return builder.toString();
    }

    private String provideEncryptionKey(EncryptionKeyGetter getter, EncryptionKeySetter setter) {
        String key = null;
        try {
            key = getter.get();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (key == null || key.isEmpty()) {
            try {
                String encryptionKey = this.generateEncryptionKey();
                setter.set(encryptionKey);
                key = encryptionKey;
            }
            catch (UnsupportedOperationException encryptionKey) {
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return key;
    }

    public boolean isEncryptionSupported() {
        return this.credentialsAccessor != null && this.encryptionKey != null && !this.encryptionKey.isEmpty();
    }

    protected abstract void patchTokens(K var1, TokenPatcher var2) throws Exception;

    public static interface EncryptionKeySetter {
        public void set(String var1) throws Exception;
    }

    public static interface EncryptionKeyGetter {
        public String get() throws Exception;
    }
}

