/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage.account;

import com.google.gson.annotations.SerializedName;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import net.labymod.accountmanager.authentication.microsoft.MicrosoftAuthentication;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.account.AccountSessionState;

public abstract class AbstractAccount
implements Account {
    private transient AccountSessionState state = AccountSessionState.UNKNOWN;
    private transient long lastAccessTokenUpdated;
    @SerializedName(value="access_token_expires_at")
    private long accessTokenExpiresAt;

    @Override
    public void setSessionState(AccountSessionState state) {
        this.state = state;
    }

    @Override
    public boolean isAccessTokenExpired() {
        return this.accessTokenExpiresAt != -1L && this.accessTokenExpiresAt < System.currentTimeMillis();
    }

    @Override
    public AccountSessionState getSessionState() {
        return this.state;
    }

    @Override
    public long getLastAccessTokenUpdated() {
        return this.lastAccessTokenUpdated;
    }

    public void setAccessTokenExpiresAt(long accessTokenExpiresAt) {
        this.accessTokenExpiresAt = accessTokenExpiresAt;
        this.lastAccessTokenUpdated = System.currentTimeMillis();
    }

    public void setAccessTokenExpiresAt(String accessTokenExpiresAt) {
        try {
            SimpleDateFormat format = accessTokenExpiresAt.contains(".") ? MicrosoftAuthentication.DATE_FORMAT_EXACT : MicrosoftAuthentication.DATE_FORMAT;
            long time = format.parse(accessTokenExpiresAt).getTime();
            this.setAccessTokenExpiresAt(time);
        }
        catch (ParseException e) {
            this.accessTokenExpiresAt = -1L;
            e.printStackTrace();
        }
    }
}

