/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager.storage;

import java.util.function.Consumer;
import net.labymod.accountmanager.authentication.AccountAuthentication;
import net.labymod.accountmanager.authentication.AsyncAccountAuthentication;
import net.labymod.accountmanager.storage.AccountStorage;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.account.AccountSessionState;

public abstract class AbstractAccountStorage<T extends Account>
implements AccountStorage<T> {
    protected AccountAuthentication authentication;

    @Override
    public boolean isAuthenticationInitialized() {
        return this.authentication != null;
    }

    @Override
    public void initializeAuthentication() {
        this.authentication = new AsyncAccountAuthentication(this.getClientToken());
    }

    @Override
    public AccountAuthentication getAuthentication() {
        return this.authentication;
    }

    @Override
    public void refreshAccounts(Consumer<Account> callback) {
        for (Account account : this.getAccounts()) {
            this.refreshAccount(account);
            callback.accept(account);
        }
    }

    private void refreshAccount(T account) {
        if (!this.isAuthenticationInitialized()) {
            throw new RuntimeException("Authentication has to be initialized before refreshing an account");
        }
        try {
            if (account.isPremium()) {
                if (account.isMicrosoft()) {
                    account.setSessionState(account.isAccessTokenExpired() ? AccountSessionState.EXPIRED : AccountSessionState.VALID);
                } else {
                    this.authentication.updateMojangSessionState((Account)account);
                }
            } else {
                account.setSessionState(AccountSessionState.OFFLINE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            account.setSessionState(AccountSessionState.EXPIRED);
        }
    }
}

