/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.accountmanager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.labymod.accountmanager.storage.AccountStorage;
import net.labymod.accountmanager.storage.StorageType;
import net.labymod.accountmanager.storage.account.Account;
import net.labymod.accountmanager.storage.account.AccountSessionState;
import net.labymod.accountmanager.storage.credentials.CredentialsAccessor;
import net.labymod.accountmanager.storage.loader.external.ExternalAccountStorage;
import net.labymod.accountmanager.storage.loader.java.JavaProfileLauncherStorage;
import net.labymod.accountmanager.storage.loader.microsoft.MicrosoftLauncherStorage;
import net.labymod.accountmanager.storage.loader.microsoft.MicrosoftStoreLauncherStorage;

public class AccountManager {
    private final Map<StorageType, AccountStorage<? extends Account>> launcherStorages = new HashMap<StorageType, AccountStorage<? extends Account>>();
    private final ExternalAccountStorage storage;

    public AccountManager(File file, CredentialsAccessor accessor, File minecraftDirectory) {
        this(file, accessor);
        this.launcherStorages.put(StorageType.MICROSOFT_STORE, new MicrosoftStoreLauncherStorage(accessor, minecraftDirectory));
        this.launcherStorages.put(StorageType.MICROSOFT, new MicrosoftLauncherStorage(accessor, minecraftDirectory));
        this.launcherStorages.put(StorageType.JAVA, new JavaProfileLauncherStorage(minecraftDirectory));
    }

    public AccountManager(File file) {
        this(file, null);
    }

    public AccountManager(File file, CredentialsAccessor accessor) {
        this.storage = new ExternalAccountStorage(file, accessor);
    }

    public void load() throws Exception {
        this.storage.load();
        for (AccountStorage<? extends Account> storage : this.launcherStorages.values()) {
            try {
                storage.load();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void refreshExternalSessions() {
        this.refreshExternalSessions(account -> {});
    }

    public void refreshExternalSessions(Consumer<Account> callback) {
        if (!this.storage.isLoaded()) {
            return;
        }
        this.storage.setAllSessionStatesTo(AccountSessionState.VALIDATING);
        this.storage.refreshAccounts(callback);
    }

    public void refreshLauncherSessions() {
        this.refreshLauncherSessions(account -> {});
    }

    public void refreshLauncherSessions(Consumer<Account> callback) {
        for (AccountStorage<? extends Account> storage : this.launcherStorages.values()) {
            if (!storage.isLoaded()) continue;
            storage.setAllSessionStatesTo(AccountSessionState.VALIDATING);
        }
        for (AccountStorage<? extends Account> storage : this.launcherStorages.values()) {
            if (!storage.isLoaded()) continue;
            storage.refreshAccounts(callback);
        }
    }

    public void save() throws Exception {
        this.storage.save();
    }

    public Account[] getAccounts() {
        ArrayList<? extends Account> accounts = new ArrayList<Account>();
        for (AccountStorage<? extends Account> storage : this.launcherStorages.values()) {
            if (!storage.isLoaded()) continue;
            accounts.addAll(storage.getAccounts());
        }
        accounts.addAll(this.storage.getAccounts());
        Account[] array = new Account[accounts.size()];
        accounts.toArray(array);
        return array;
    }

    public Collection<StorageType> getLauncherStorageTypes() {
        return this.launcherStorages.keySet();
    }

    public AccountStorage<? extends Account> getLauncherStorageOf(StorageType type) {
        if (type == StorageType.EXTERNAL) {
            return this.storage;
        }
        return this.launcherStorages.get((Object)type);
    }

    public ExternalAccountStorage getStorage() {
        return this.storage;
    }
}

