/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.dec;

import org.brotli.dec.WordTransformType;

final class Transform {
    private final byte[] prefix;
    private final int type;
    private final byte[] suffix;
    static final Transform[] TRANSFORMS = new Transform[]{new Transform("", 0, ""), new Transform("", 0, " "), new Transform(" ", 0, " "), new Transform("", 12, ""), new Transform("", 10, " "), new Transform("", 0, " the "), new Transform(" ", 0, ""), new Transform("s ", 0, " "), new Transform("", 0, " of "), new Transform("", 10, ""), new Transform("", 0, " and "), new Transform("", 13, ""), new Transform("", 1, ""), new Transform(", ", 0, " "), new Transform("", 0, ", "), new Transform(" ", 10, " "), new Transform("", 0, " in "), new Transform("", 0, " to "), new Transform("e ", 0, " "), new Transform("", 0, "\""), new Transform("", 0, "."), new Transform("", 0, "\">"), new Transform("", 0, "\n"), new Transform("", 3, ""), new Transform("", 0, "]"), new Transform("", 0, " for "), new Transform("", 14, ""), new Transform("", 2, ""), new Transform("", 0, " a "), new Transform("", 0, " that "), new Transform(" ", 10, ""), new Transform("", 0, ". "), new Transform(".", 0, ""), new Transform(" ", 0, ", "), new Transform("", 15, ""), new Transform("", 0, " with "), new Transform("", 0, "'"), new Transform("", 0, " from "), new Transform("", 0, " by "), new Transform("", 16, ""), new Transform("", 17, ""), new Transform(" the ", 0, ""), new Transform("", 4, ""), new Transform("", 0, ". The "), new Transform("", 11, ""), new Transform("", 0, " on "), new Transform("", 0, " as "), new Transform("", 0, " is "), new Transform("", 7, ""), new Transform("", 1, "ing "), new Transform("", 0, "\n\t"), new Transform("", 0, ":"), new Transform(" ", 0, ". "), new Transform("", 0, "ed "), new Transform("", 20, ""), new Transform("", 18, ""), new Transform("", 6, ""), new Transform("", 0, "("), new Transform("", 10, ", "), new Transform("", 8, ""), new Transform("", 0, " at "), new Transform("", 0, "ly "), new Transform(" the ", 0, " of "), new Transform("", 5, ""), new Transform("", 9, ""), new Transform(" ", 10, ", "), new Transform("", 10, "\""), new Transform(".", 0, "("), new Transform("", 11, " "), new Transform("", 10, "\">"), new Transform("", 0, "=\""), new Transform(" ", 0, "."), new Transform(".com/", 0, ""), new Transform(" the ", 0, " of the "), new Transform("", 10, "'"), new Transform("", 0, ". This "), new Transform("", 0, ","), new Transform(".", 0, " "), new Transform("", 10, "("), new Transform("", 10, "."), new Transform("", 0, " not "), new Transform(" ", 0, "=\""), new Transform("", 0, "er "), new Transform(" ", 11, " "), new Transform("", 0, "al "), new Transform(" ", 11, ""), new Transform("", 0, "='"), new Transform("", 11, "\""), new Transform("", 10, ". "), new Transform(" ", 0, "("), new Transform("", 0, "ful "), new Transform(" ", 10, ". "), new Transform("", 0, "ive "), new Transform("", 0, "less "), new Transform("", 11, "'"), new Transform("", 0, "est "), new Transform(" ", 10, "."), new Transform("", 11, "\">"), new Transform(" ", 0, "='"), new Transform("", 10, ","), new Transform("", 0, "ize "), new Transform("", 11, "."), new Transform("\u00c2\u00a0", 0, ""), new Transform(" ", 0, ","), new Transform("", 10, "=\""), new Transform("", 11, "=\""), new Transform("", 0, "ous "), new Transform("", 11, ", "), new Transform("", 10, "='"), new Transform(" ", 10, ","), new Transform(" ", 11, "=\""), new Transform(" ", 11, ", "), new Transform("", 11, ","), new Transform("", 11, "("), new Transform("", 11, ". "), new Transform(" ", 11, "."), new Transform("", 11, "='"), new Transform(" ", 11, ". "), new Transform(" ", 10, "=\""), new Transform(" ", 11, "='"), new Transform(" ", 10, "='")};

    Transform(String prefix2, int type2, String suffix) {
        this.prefix = Transform.readUniBytes(prefix2);
        this.type = type2;
        this.suffix = Transform.readUniBytes(suffix);
    }

    static byte[] readUniBytes(String uniBytes) {
        byte[] result2 = new byte[uniBytes.length()];
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = (byte)uniBytes.charAt(i);
        }
        return result2;
    }

    static int transformDictionaryWord(byte[] dst, int dstOffset, byte[] word, int wordOffset, int len, Transform transform2) {
        int offset = dstOffset;
        byte[] string = transform2.prefix;
        int tmp = string.length;
        int i = 0;
        while (i < tmp) {
            dst[offset++] = string[i++];
        }
        int op = transform2.type;
        tmp = WordTransformType.getOmitFirst(op);
        if (tmp > len) {
            tmp = len;
        }
        wordOffset += tmp;
        len -= tmp;
        for (i = len -= WordTransformType.getOmitLast(op); i > 0; --i) {
            dst[offset++] = word[wordOffset++];
        }
        if (op == 11 || op == 10) {
            int uppercaseOffset = offset - len;
            if (op == 10) {
                len = 1;
            }
            while (len > 0) {
                tmp = dst[uppercaseOffset] & 0xFF;
                if (tmp < 192) {
                    if (tmp >= 97 && tmp <= 122) {
                        int n = uppercaseOffset;
                        dst[n] = (byte)(dst[n] ^ 0x20);
                    }
                    ++uppercaseOffset;
                    --len;
                    continue;
                }
                if (tmp < 224) {
                    int n = uppercaseOffset + 1;
                    dst[n] = (byte)(dst[n] ^ 0x20);
                    uppercaseOffset += 2;
                    len -= 2;
                    continue;
                }
                int n = uppercaseOffset + 2;
                dst[n] = (byte)(dst[n] ^ 5);
                uppercaseOffset += 3;
                len -= 3;
            }
        }
        string = transform2.suffix;
        tmp = string.length;
        i = 0;
        while (i < tmp) {
            dst[offset++] = string[i++];
        }
        return offset - dstOffset;
    }
}

