/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.core.file;

import gg.skytils.vigilance.impl.nightconfig.core.file.FileConfig;
import gg.skytils.vigilance.impl.nightconfig.core.file.FileWatcher;
import gg.skytils.vigilance.impl.nightconfig.core.utils.ConfigWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

final class AutoreloadFileConfig<C extends FileConfig>
extends ConfigWrapper<C>
implements FileConfig {
    private final FileWatcher watcher = FileWatcher.defaultInstance();

    AutoreloadFileConfig(C config2) {
        super(config2);
        try {
            this.watcher.addWatch(config2.getFile(), () -> config2.load());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create the autoreloaded config", e);
        }
    }

    @Override
    public File getFile() {
        return ((FileConfig)this.config).getFile();
    }

    @Override
    public Path getNioPath() {
        return ((FileConfig)this.config).getNioPath();
    }

    @Override
    public void save() {
        ((FileConfig)this.config).save();
    }

    @Override
    public void load() {
        ((FileConfig)this.config).load();
    }

    @Override
    public void close() {
        this.watcher.removeWatch(((FileConfig)this.config).getFile());
        ((FileConfig)this.config).close();
    }
}

