/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.core.conversion;

import gg.skytils.vigilance.impl.nightconfig.core.CommentedConfig;
import gg.skytils.vigilance.impl.nightconfig.core.Config;
import gg.skytils.vigilance.impl.nightconfig.core.ConfigFormat;
import gg.skytils.vigilance.impl.nightconfig.core.UnmodifiableConfig;
import gg.skytils.vigilance.impl.nightconfig.core.conversion.ConvertedCommentedConfig;
import gg.skytils.vigilance.impl.nightconfig.core.conversion.ConvertedCommentedFileConfig;
import gg.skytils.vigilance.impl.nightconfig.core.conversion.ConvertedConfig;
import gg.skytils.vigilance.impl.nightconfig.core.conversion.ConvertedFileConfig;
import gg.skytils.vigilance.impl.nightconfig.core.file.CommentedFileConfig;
import gg.skytils.vigilance.impl.nightconfig.core.file.FileConfig;
import gg.skytils.vigilance.impl.nightconfig.core.utils.TransformingMap;
import gg.skytils.vigilance.impl.nightconfig.core.utils.TransformingSet;
import gg.skytils.vigilance.impl.nightconfig.core.utils.UnmodifiableConfigWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ConversionTable
implements Cloneable {
    private final Map<Class<?>, Function<?, Object>> conversionMap;

    public ConversionTable() {
        this.conversionMap = new HashMap();
    }

    private ConversionTable(ConversionTable toCopy) {
        this.conversionMap = new HashMap(toCopy.conversionMap);
    }

    public <T> void put(Class<T> classToConvert, Function<? super T, Object> conversionFunction) {
        this.conversionMap.put(classToConvert, conversionFunction);
    }

    public void remove(Class<?> classToConvert) {
        this.conversionMap.remove(classToConvert);
    }

    public boolean contains(Class<?> classToConvert) {
        return this.conversionMap.containsKey(classToConvert);
    }

    public Object convert(Object value) {
        Function<Object, Object> conversionFunction = this.getConversionFunction(value);
        if (conversionFunction == null) {
            return value;
        }
        return conversionFunction.apply(value);
    }

    public void convertShallow(Config config2) {
        for (Map.Entry<String, Object> configEntry : config2.valueMap().entrySet()) {
            Object value = configEntry.getValue();
            Function<Object, Object> conversionFunction = this.getConversionFunction(value);
            if (conversionFunction == null) continue;
            configEntry.setValue(conversionFunction.apply(value));
        }
    }

    public void convertDeep(Config config2) {
        for (Map.Entry<String, Object> configEntry : config2.valueMap().entrySet()) {
            Object value = configEntry.getValue();
            if (value instanceof Config) {
                this.convertDeep(config2);
                continue;
            }
            Function<Object, Object> conversionFunction = this.getConversionFunction(value);
            if (conversionFunction == null) continue;
            configEntry.setValue(conversionFunction.apply(value));
        }
    }

    private Function<Object, Object> getConversionFunction(Object value) {
        if (value == null) {
            return this.conversionMap.get(null);
        }
        Class<?> clazz = value.getClass();
        Function<Object, Object> conversionFunction = this.conversionMap.get(clazz);
        while (conversionFunction == null && (clazz = clazz.getSuperclass()) != null) {
            conversionFunction = this.conversionMap.get(clazz);
        }
        return conversionFunction;
    }

    public ConversionTable chainThen(ConversionTable after) {
        ConversionTable result2 = new ConversionTable(this);
        for (Map.Entry<Class<?>, Function<?, Object>> entry : result2.conversionMap.entrySet()) {
            entry.setValue(entry.getValue().andThen(after::convert));
        }
        for (Map.Entry<Class<?>, Function<?, Object>> entry : after.conversionMap.entrySet()) {
            result2.conversionMap.putIfAbsent(entry.getKey(), entry.getValue());
        }
        return result2;
    }

    public UnmodifiableConfig wrap(UnmodifiableConfig config2) {
        return new UnmodifiableConfigWrapper<UnmodifiableConfig>(config2){

            @Override
            public <T> T getRaw(List<String> path) {
                return (T)ConversionTable.this.convert(this.config.getRaw(path));
            }

            @Override
            public Map<String, Object> valueMap() {
                return new TransformingMap<String, Object, Object>(this.config.valueMap(), v -> ConversionTable.this.convert(v), v -> v, v -> v);
            }

            @Override
            public Set<? extends UnmodifiableConfig.Entry> entrySet() {
                Function<UnmodifiableConfig.Entry, UnmodifiableConfig.Entry> readTransfo = entry -> new UnmodifiableConfig.Entry((UnmodifiableConfig.Entry)entry){
                    final /* synthetic */ UnmodifiableConfig.Entry val$entry;
                    {
                        this.val$entry = entry;
                    }

                    @Override
                    public String getKey() {
                        return this.val$entry.getKey();
                    }

                    @Override
                    public <T> T getRawValue() {
                        return (T)ConversionTable.this.convert(this.val$entry.getRawValue());
                    }
                };
                return new TransformingSet<UnmodifiableConfig.Entry, UnmodifiableConfig.Entry>(this.config.entrySet(), readTransfo, o -> null, e -> e);
            }

            @Override
            public ConfigFormat<?> configFormat() {
                return this.config.configFormat();
            }
        };
    }

    public Config wrapRead(Config config2) {
        return new ConvertedConfig(config2, this::convert, v -> v, config2.configFormat()::supportsType);
    }

    public CommentedConfig wrapRead(CommentedConfig config2) {
        return new ConvertedCommentedConfig(config2, this::convert, v -> v, config2.configFormat()::supportsType);
    }

    public FileConfig wrapRead(FileConfig config2) {
        return new ConvertedFileConfig(config2, this::convert, v -> v, config2.configFormat()::supportsType);
    }

    public CommentedFileConfig wrapRead(CommentedFileConfig config2) {
        return new ConvertedCommentedFileConfig(config2, this::convert, v -> v, config2.configFormat()::supportsType);
    }

    public Config wrapWrite(Config config2, Predicate<Class<?>> supportValueTypePredicate) {
        return new ConvertedConfig(config2, v -> v, this::convert, supportValueTypePredicate);
    }

    public CommentedConfig wrapWrite(CommentedConfig config2, Predicate<Class<?>> supportValueTypePredicate) {
        return new ConvertedCommentedConfig(config2, v -> v, this::convert, supportValueTypePredicate);
    }

    public FileConfig wrapWrite(FileConfig config2, Predicate<Class<?>> supportValueTypePredicate) {
        return new ConvertedFileConfig(config2, v -> v, this::convert, supportValueTypePredicate);
    }

    public CommentedFileConfig wrapWrite(CommentedFileConfig config2, Predicate<Class<?>> supportValueTypePredicate) {
        return new ConvertedCommentedFileConfig(config2, v -> v, this::convert, supportValueTypePredicate);
    }

    public ConversionTable clone() {
        return new ConversionTable(this);
    }

    public String toString() {
        return "ConversionTable: " + this.conversionMap;
    }
}

