/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl;

import gg.skytils.vigilance.data.Migration;
import gg.skytils.vigilance.impl.nightconfig.core.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\u001aK\u0010\n\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u000b\u001a%\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u001f\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a)\u0010\u0017\u001a\u0004\u0018\u00018\u0000\"\u0004\b\u0000\u0010\u0015*\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a!\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004*\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a\"\u0014\u0010\u001b\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\"\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lgg/skytils/vigilance/impl/nightconfig/core/Config;", "root", "", "migration", "", "", "", "oldMap", "newMap", "", "applyMigration", "(Lgg/essential/vigilance/impl/nightconfig/core/Config;ILjava/util/Map;Ljava/util/Map;)V", "", "Lgg/skytils/vigilance/data/Migration;", "migrations", "migrate", "(Lgg/essential/vigilance/impl/nightconfig/core/Config;Ljava/util/List;)V", "migrationLogKey", "(I)Ljava/util/List;", "rollbackMigration", "(Lgg/essential/vigilance/impl/nightconfig/core/Config;I)V", "T", "keys", "purge", "(Lgg/essential/vigilance/impl/nightconfig/core/Config;Ljava/util/List;)Ljava/lang/Object;", "toMap", "(Lgg/essential/vigilance/impl/nightconfig/core/Config;)Ljava/util/Map;", "META_KEY", "Ljava/lang/String;", "VERSION_KEY", "Ljava/util/List;", "Vigilance"})
public final class MigrationKt {
    @NotNull
    private static final String META_KEY = "__meta";
    @NotNull
    private static final List<String> VERSION_KEY;

    private static final List<String> migrationLogKey(int migration) {
        String[] stringArray = new String[]{META_KEY, "migration_log", String.valueOf(migration)};
        return CollectionsKt.listOf(stringArray);
    }

    public static final void migrate(@NotNull Config root, @NotNull List<? extends Migration> migrations) {
        int fileVersion;
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(migrations, "migrations");
        Integer n = (Integer)root.get(VERSION_KEY);
        int n2 = fileVersion = n == null ? 0 : n;
        if (fileVersion < migrations.size()) {
            Map<String, Object> oldMap = MigrationKt.toMap(root);
            int n3 = fileVersion;
            int n4 = migrations.size();
            while (n3 < n4) {
                int migration = n3++;
                Map<String, Object> newMap = MapsKt.toMutableMap(oldMap);
                migrations.get(migration).apply(newMap);
                MigrationKt.applyMigration(root, migration, oldMap, newMap);
                root.update(VERSION_KEY, (Object)(migration + 1));
                oldMap = newMap;
                boolean bl = Intrinsics.areEqual(oldMap, MigrationKt.toMap(root));
                if (!_Assertions.ENABLED || bl) continue;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        } else if (fileVersion > migrations.size()) {
            int n5 = fileVersion - 1;
            int n6 = migrations.size();
            if (n6 <= n5) {
                int migration;
                do {
                    migration = n5--;
                    MigrationKt.rollbackMigration(root, migration);
                    root.update(VERSION_KEY, (Object)migration);
                } while (migration != n6);
            }
        }
    }

    private static final void applyMigration(Config root, int migration, Map<String, ? extends Object> oldMap, Map<String, ? extends Object> newMap) {
        Object newValue;
        Config migrationLog = root.createSubConfig();
        for (Map.Entry<String, ? extends Object> object : oldMap.entrySet()) {
            String string = object.getKey();
            Object oldValue = object.getValue();
            String[] stringArray = newMap;
            if (!stringArray.containsKey(string)) {
                String[] stringArray2 = new String[]{"changed", string};
                migrationLog.update(CollectionsKt.listOf(stringArray2), oldValue);
                stringArray2 = new String[]{"."};
                MigrationKt.purge(root, StringsKt.split$default((CharSequence)string, stringArray2, false, 0, 6, null));
                continue;
            }
            newValue = newMap.get(string);
            if (Intrinsics.areEqual(newValue, oldValue)) continue;
            stringArray = new String[]{"changed", string};
            migrationLog.update(CollectionsKt.listOf(stringArray), oldValue);
            root.update(string, newValue);
        }
        List added = new ArrayList();
        for (Map.Entry entry : newMap.entrySet()) {
            String key3 = (String)entry.getKey();
            newValue = entry.getValue();
            Map<String, ? extends Object> map2 = oldMap;
            if (map2.containsKey(key3)) continue;
            added.add(key3);
            root.update(key3, newValue);
        }
        if (!((Collection)added).isEmpty()) {
            migrationLog.update(CollectionsKt.listOf("added"), (Object)added);
        }
        if (!migrationLog.isEmpty()) {
            root.update(MigrationKt.migrationLogKey(migration), (Object)migrationLog);
        }
    }

    private static final void rollbackMigration(Config root, int migration) {
        Config config2 = (Config)MigrationKt.purge(root, MigrationKt.migrationLogKey(migration));
        if (config2 == null) {
            return;
        }
        Config migrationLog = config2;
        List<String> list = (List<String>)migrationLog.get(CollectionsKt.listOf("added"));
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List<String> added = list;
        Config config3 = (Config)migrationLog.get(CollectionsKt.listOf("changed"));
        Map<String, Object> map2 = config3 == null ? null : config3.valueMap();
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        Map<String, Object> changed = map2;
        for (String entry : added) {
            String[] stringArray = new String[]{"."};
            MigrationKt.purge(root, StringsKt.split$default((CharSequence)entry, stringArray, false, 0, 6, null));
        }
        for (Map.Entry entry : changed.entrySet()) {
            String key3 = (String)entry.getKey();
            Object oldValue = entry.getValue();
            root.update(key3, oldValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> T purge(Config $this$purge, List<String> keys2) {
        Object t;
        if (keys2.size() > 1) {
            void var3_4;
            Object t2 = $this$purge.get(CollectionsKt.listOf(keys2.get(0)));
            Config config2 = t2 instanceof Config ? (Config)t2 : null;
            if (config2 == null) {
                return null;
            }
            Config child = config2;
            T removed = MigrationKt.purge(child, keys2.subList(1, keys2.size()));
            if (child.isEmpty()) {
                $this$purge.remove(CollectionsKt.listOf(keys2.get(0)));
            }
            t = var3_4;
        } else {
            t = $this$purge.remove(keys2);
        }
        return t;
    }

    private static final Map<String, Object> toMap(Config $this$toMap) {
        Map result2 = new LinkedHashMap();
        MigrationKt.toMap$visit(result2, $this$toMap, "");
        return result2;
    }

    private static final void toMap$visit(Map<String, Object> result2, Config config2, String prefix2) {
        Map<String, Object> object2 = config2.valueMap();
        Intrinsics.checkNotNullExpressionValue(object2, "config.valueMap()");
        for (Map.Entry<String, Object> entry : object2.entrySet()) {
            String key2 = entry.getKey();
            Object value = entry.getValue();
            if (Intrinsics.areEqual(key2, META_KEY)) continue;
            if (value instanceof Config) {
                MigrationKt.toMap$visit(result2, (Config)value, prefix2 + key2 + '.');
                continue;
            }
            Map<String, Object> map2 = result2;
            String string = Intrinsics.stringPlus(prefix2, key2);
            map2.put(string, value);
        }
    }

    static {
        String[] stringArray = new String[]{META_KEY, "version"};
        VERSION_KEY = CollectionsKt.listOf(stringArray);
    }
}

