/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.gui.common.input;

import gg.essential.elementa.UIComponent;
import gg.essential.elementa.constraints.HeightConstraint;
import gg.essential.elementa.constraints.SuperConstraint;
import gg.essential.elementa.constraints.XConstraint;
import gg.essential.elementa.constraints.YConstraint;
import gg.essential.elementa.dsl.ConstraintsKt;
import gg.essential.elementa.dsl.UtilitiesKt;
import gg.essential.universal.UKeyboard;
import gg.essential.universal.UMatrixStack;
import gg.skytils.vigilance.gui.common.input.AbstractTextInput;
import gg.skytils.vigilance.gui.common.input.UIMultilineTextInput;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001Be\b\u0007\u0012\b\b\u0002\u0010#\u001a\u00020\u0007\u0012\b\b\u0002\u0010%\u001a\u00020$\u0012\n\b\u0002\u0010'\u001a\u0004\u0018\u00010&\u0012\b\b\u0002\u0010(\u001a\u00020&\u0012\b\b\u0002\u0010)\u001a\u00020&\u0012\b\b\u0002\u0010*\u001a\u00020$\u0012\b\b\u0002\u0010+\u001a\u00020&\u0012\b\b\u0002\u0010,\u001a\u00020&\u0012\b\b\u0002\u0010-\u001a\u00020&\u00a2\u0006\u0004\b.\u0010/J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\f\u0010\u000bJ#\u0010\u0011\u001a\u00060\u0010R\u00020\u00012\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0014\u001a\u00020\u00042\n\u0010\u0013\u001a\u00060\u0010R\u00020\u0001H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0006\u0010\u001e\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b \u0010!R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\"\u00a8\u00060"}, d2={"Lgg/skytils/vigilance/gui/common/input/UIMultilineTextInput;", "Lgg/skytils/vigilance/gui/common/input/AbstractTextInput;", "Lgg/essential/universal/UMatrixStack;", "matrixStack", "", "draw", "(Lgg/essential/universal/UMatrixStack;)V", "", "getText", "()Ljava/lang/String;", "onEnterPressed", "()V", "recalculateDimensions", "", "x", "y", "Lgg/skytils/vigilance/gui/common/input/AbstractTextInput$LinePosition;", "screenPosToVisualPos", "(FF)Lgg/essential/vigilance/gui/common/input/AbstractTextInput$LinePosition;", "pos", "scrollIntoView", "(Lgg/essential/vigilance/gui/common/input/AbstractTextInput$LinePosition;)V", "Lgg/essential/elementa/constraints/HeightConstraint;", "maxHeight", "setMaxHeight", "(Lgg/essential/elementa/constraints/HeightConstraint;)Lgg/essential/vigilance/gui/common/input/UIMultilineTextInput;", "", "maxLines", "setMaxLines", "(I)Lgg/essential/vigilance/gui/common/input/UIMultilineTextInput;", "text", "", "textToLines", "(Ljava/lang/String;)Ljava/util/List;", "Lgg/essential/elementa/constraints/HeightConstraint;", "placeholder", "", "shadow", "Ljava/awt/Color;", "shadowColor", "selectionBackgroundColor", "selectionForegroundColor", "allowInactiveSelection", "inactiveSelectionBackgroundColor", "inactiveSelectionForegroundColor", "cursorColor", "<init>", "(Ljava/lang/String;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;ZLjava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "Vigilance"})
public final class UIMultilineTextInput
extends AbstractTextInput {
    @Nullable
    private HeightConstraint maxHeight;

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor, @NotNull Color cursorColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionBackgroundColor, "inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionForegroundColor, "inactiveSelectionForegroundColor");
        Intrinsics.checkNotNullParameter(cursorColor, "cursorColor");
        super(placeholder, shadow, shadowColor, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, cursorColor);
    }

    public /* synthetic */ UIMultilineTextInput(String string, boolean bl, Color color, Color color2, Color color3, boolean bl2, Color color4, Color color5, Color color6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Color color7;
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            color = null;
        }
        if ((n & 8) != 0) {
            color7 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color7, "WHITE");
            color2 = color7;
        }
        if ((n & 0x10) != 0) {
            color3 = new Color(64, 139, 229);
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            color4 = new Color(176, 176, 176);
        }
        if ((n & 0x80) != 0) {
            color7 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color7, "WHITE");
            color5 = color7;
        }
        if ((n & 0x100) != 0) {
            color7 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color7, "WHITE");
            color6 = color7;
        }
        this(string, bl, color, color2, color3, bl2, color4, color5, color6);
    }

    @NotNull
    public final UIMultilineTextInput setMaxHeight(@NotNull HeightConstraint maxHeight) {
        UIMultilineTextInput uIMultilineTextInput;
        Intrinsics.checkNotNullParameter(maxHeight, "maxHeight");
        UIMultilineTextInput $this$setMaxHeight_u24lambda_u2d0 = uIMultilineTextInput = this;
        boolean bl = false;
        $this$setMaxHeight_u24lambda_u2d0.maxHeight = maxHeight;
        return uIMultilineTextInput;
    }

    @NotNull
    public final UIMultilineTextInput setMaxLines(int maxLines) {
        UIMultilineTextInput uIMultilineTextInput;
        UIMultilineTextInput $this$setMaxLines_u24lambda_u2d1 = uIMultilineTextInput = this;
        boolean bl = false;
        $this$setMaxLines_u24lambda_u2d1.maxHeight = (HeightConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf($this$setMaxLines_u24lambda_u2d1.getLineHeight() * (float)maxLines), (boolean)false, (boolean)false, (int)3, null);
        return uIMultilineTextInput;
    }

    @Override
    @NotNull
    public String getText() {
        return CollectionsKt.joinToString$default(this.getTextualLines(), "\n", null, null, 0, null, getText.1.INSTANCE, 30, null);
    }

    @Override
    @NotNull
    protected List<String> textToLines(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        char[] cArray = new char[]{'\n'};
        return StringsKt.split$default((CharSequence)text2, cArray, false, 0, 6, null);
    }

    @Override
    protected void scrollIntoView(@NotNull AbstractTextInput.LinePosition pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        AbstractTextInput.LinePosition visualPos = pos.toVisualPos();
        float visualLineOffset = (float)visualPos.getLine() * -this.getLineHeight();
        if (this.getTargetVerticalScrollingOffset() < visualLineOffset) {
            this.setTargetVerticalScrollingOffset(visualLineOffset);
        } else if (visualLineOffset - this.getLineHeight() < this.getTargetVerticalScrollingOffset() - this.getHeight()) {
            this.setTargetVerticalScrollingOffset(this.getTargetVerticalScrollingOffset() + (visualLineOffset - this.getLineHeight() - (this.getTargetVerticalScrollingOffset() - this.getHeight())));
        }
    }

    @Override
    protected void recalculateDimensions() {
        if (this.maxHeight == null) {
            return;
        }
        SuperConstraint superConstraint = (SuperConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf(this.getLineHeight() * (float)this.getVisualLines().size()), (boolean)false, (boolean)false, (int)3, null);
        HeightConstraint heightConstraint = this.maxHeight;
        Intrinsics.checkNotNull(heightConstraint);
        this.setHeight((HeightConstraint)ConstraintsKt.coerceAtMost((SuperConstraint)superConstraint, (SuperConstraint)((SuperConstraint)heightConstraint)));
    }

    @Override
    protected void onEnterPressed() {
        if (UKeyboard.isShiftKeyDown()) {
            this.commitTextAddition("\n");
            this.getUpdateAction().invoke(this.getText());
            this.getTextState().set((Object)this.getText());
        } else {
            this.getActivateAction().invoke(this.getText());
        }
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack) {
        Pair<Comparable<AbstractTextInput.LinePosition>, Comparable<AbstractTextInput.LinePosition>> pair;
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        this.beforeDraw(matrixStack);
        float textScale = this.getTextScale();
        if (!this.getActive() && !this.hasText()) {
            this.drawPlaceholder(matrixStack);
            super.draw(matrixStack);
            return;
        }
        if (this.hasSelection()) {
            this.getCursorComponent().hide(true);
        } else if (this.getActive()) {
            UIComponent.unhide$default((UIComponent)this.getCursorComponent(), (boolean)false, (int)1, null);
            pair = this.getCursor().toScreenPos();
            float cursorPosX = ((Number)((Object)pair.component1())).floatValue();
            float cursorPosY = ((Number)((Object)pair.component2())).floatValue();
            this.getCursorComponent().setX((XConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf(cursorPosX), (boolean)false, (boolean)false, (int)3, null));
            this.getCursorComponent().setY((YConstraint)UtilitiesKt.pixels$default((Number)Float.valueOf(cursorPosY), (boolean)false, (boolean)false, (int)3, null));
        }
        pair = this.getSelection();
        AbstractTextInput.LinePosition selectionStart = pair.component1();
        AbstractTextInput.LinePosition selectionEnd = pair.component2();
        Iterator<AbstractTextInput.VisualLine> iterator2 = this.getVisualLines().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            String string;
            String string2;
            int n2;
            String string3;
            int n3;
            int i = n++;
            AbstractTextInput.VisualLine visualLine = iterator2.next();
            float topOffset = this.getLineHeight() * (float)i * this.getTextScale() + this.getVerticalScrollingOffset();
            if (topOffset < -this.getLineHeight() * this.getTextScale() || topOffset > this.getHeight() + this.getLineHeight() * this.getTextScale()) continue;
            if (!this.hasSelection() || i < selectionStart.getLine() || i > selectionEnd.getLine()) {
                AbstractTextInput.drawUnselectedText$default(this, matrixStack, visualLine.getText(), this.getLeft(), i, null, false, null, 112, null);
                continue;
            }
            if (i == selectionStart.getLine() && selectionStart.getColumn() > 0) {
                String string4 = visualLine.getText();
                int n4 = 0;
                n3 = selectionStart.getColumn();
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n4, n3);
                string3 = string6;
                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string3 = "";
            }
            String startText = string3;
            if (selectionStart.getLine() == selectionEnd.getLine()) {
                String string7 = visualLine.getText();
                n3 = selectionStart.getColumn();
                n2 = selectionEnd.getColumn();
                String string8 = string7;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.substring(n3, n2);
                string2 = string9;
                Intrinsics.checkNotNullExpressionValue(string9, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else if (i > selectionStart.getLine() && i < selectionEnd.getLine()) {
                string2 = visualLine.getText();
            } else if (i == selectionStart.getLine()) {
                String string10 = visualLine.getText();
                n3 = selectionStart.getColumn();
                String string11 = string10;
                if (string11 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string12 = string11.substring(n3);
                string2 = string12;
                Intrinsics.checkNotNullExpressionValue(string12, "(this as java.lang.String).substring(startIndex)");
            } else if (i == selectionEnd.getLine()) {
                String string13 = visualLine.getText();
                n3 = 0;
                int n5 = selectionEnd.getColumn();
                String string14 = string13;
                if (string14 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string15 = string14.substring(n3, n5);
                string2 = string15;
                Intrinsics.checkNotNullExpressionValue(string15, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string2 = "";
            }
            String selectedText2 = string2;
            if (i == selectionEnd.getLine() && selectionEnd.getColumn() < this.getVisualLines().get(i).getLength()) {
                String string16 = visualLine.getText();
                n2 = selectionEnd.getColumn();
                String string17 = string16;
                if (string17 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string18 = string17.substring(n2);
                string = string18;
                Intrinsics.checkNotNullExpressionValue(string18, "(this as java.lang.String).substring(startIndex)");
            } else {
                string = "";
            }
            String endText = string;
            float startTextWidth = UtilitiesKt.width$default((String)startText, (float)textScale, null, (int)2, null);
            float selectedTextWidth = UtilitiesKt.width$default((String)selectedText2, (float)textScale, null, (int)2, null);
            float newlinePadding = i < selectionEnd.getLine() ? UtilitiesKt.width((char)' ', (float)textScale) : 0.0f;
            if (((CharSequence)startText).length() > 0) {
                AbstractTextInput.drawUnselectedText$default(this, matrixStack, startText, this.getLeft(), i, null, false, null, 112, null);
            }
            if (((CharSequence)selectedText2).length() > 0 || !(newlinePadding == 0.0f)) {
                this.drawSelectedText(matrixStack, selectedText2, this.getLeft() + startTextWidth, this.getLeft() + startTextWidth + selectedTextWidth + newlinePadding, i);
            }
            if (!(((CharSequence)endText).length() > 0)) continue;
            AbstractTextInput.drawUnselectedText$default(this, matrixStack, endText, this.getLeft() + startTextWidth + selectedTextWidth, i, null, false, null, 112, null);
        }
        super.draw(matrixStack);
    }

    @Override
    @NotNull
    protected AbstractTextInput.LinePosition screenPosToVisualPos(float x, float y) {
        float realY = y - this.getVerticalScrollingOffset();
        if (realY <= 0.0f) {
            return new AbstractTextInput.LinePosition(0, 0, true);
        }
        int line = (int)(realY / (this.getLineHeight() * this.getTextScale()));
        if (line > CollectionsKt.getLastIndex(this.getVisualLines())) {
            return new AbstractTextInput.LinePosition(CollectionsKt.getLastIndex(this.getVisualLines()), CollectionsKt.last(this.getVisualLines()).getText().length(), true);
        }
        String text2 = this.getVisualLines().get(line).getText();
        int column = 0;
        float currWidth = 0.0f;
        if (x <= 0.0f) {
            return new AbstractTextInput.LinePosition(line, 0, true);
        }
        if (x >= this.getWidth()) {
            return new AbstractTextInput.LinePosition(line, this.getVisualLines().get(line).getText().length(), true);
        }
        String string = text2;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "(this as java.lang.String).toCharArray()");
        char[] cArray2 = cArray;
        int n = 0;
        int n2 = cArray2.length;
        while (n < n2) {
            char c = cArray2[n];
            ++n;
            float charWidth = UtilitiesKt.width((char)c, (float)this.getTextScale());
            if (currWidth + charWidth / (float)2 >= x) {
                return new AbstractTextInput.LinePosition(line, column, true);
            }
            currWidth += charWidth;
            int n3 = column;
            column = n3 + 1;
        }
        return new AbstractTextInput.LinePosition(line, column, true);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor, @NotNull Color inactiveSelectionForegroundColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionBackgroundColor, "inactiveSelectionBackgroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionForegroundColor, "inactiveSelectionForegroundColor");
        this(placeholder, shadow, shadowColor, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, inactiveSelectionForegroundColor, null, 256, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection, @NotNull Color inactiveSelectionBackgroundColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        Intrinsics.checkNotNullParameter(inactiveSelectionBackgroundColor, "inactiveSelectionBackgroundColor");
        this(placeholder, shadow, shadowColor, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, inactiveSelectionBackgroundColor, null, null, 384, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor, boolean allowInactiveSelection) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        this(placeholder, shadow, shadowColor, selectionBackgroundColor, selectionForegroundColor, allowInactiveSelection, null, null, null, 448, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor, @NotNull Color selectionForegroundColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        Intrinsics.checkNotNullParameter(selectionForegroundColor, "selectionForegroundColor");
        this(placeholder, shadow, shadowColor, selectionBackgroundColor, selectionForegroundColor, false, null, null, null, 480, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor, @NotNull Color selectionBackgroundColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        Intrinsics.checkNotNullParameter(selectionBackgroundColor, "selectionBackgroundColor");
        this(placeholder, shadow, shadowColor, selectionBackgroundColor, null, false, null, null, null, 496, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow, @Nullable Color shadowColor) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        this(placeholder, shadow, shadowColor, null, null, false, null, null, null, 504, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder, boolean shadow) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        this(placeholder, shadow, null, null, null, false, null, null, null, 508, null);
    }

    @JvmOverloads
    public UIMultilineTextInput(@NotNull String placeholder) {
        Intrinsics.checkNotNullParameter(placeholder, "placeholder");
        this(placeholder, false, null, null, null, false, null, null, null, 510, null);
    }

    @JvmOverloads
    public UIMultilineTextInput() {
        this(null, false, null, null, null, false, null, null, null, 511, null);
    }
}

